# Unified Medical Language System - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Unified Medical Language System**

## NamingSystem: Unified Medical Language System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/umls | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*NLM | *Computable Name*:Umls |

 
UMLS codes as CUIs making up the values in a coding system. More information may be found at http://www.nlm.nih.gov/research/umls/ 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/umls |
| Version | 2.1.0 |
| Name | Umls |
| Title | Unified Medical Language System |
| Status | retired |
| Definition | UMLS codes as CUIs making up the values in a coding system. More information may be found at http://www.nlm.nih.gov/research/umls/ |
| Publisher | NLM |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.86
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/umls
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "umls",
  "url" : "http://terminology.hl7.org/NamingSystem/umls",
  "version" : "2.1.0",
  "name" : "Umls",
  "title" : "Unified Medical Language System",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "NLM",
  "contact" : [
    {
      "name" : "National Library of Medicine"
    }
  ],
  "responsible" : "NLM",
  "description" : "UMLS codes as CUIs making up the values in a coding system. More information may be found at http://www.nlm.nih.gov/research/umls/",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.86",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/umls",
      "preferred" : true
    }
  ]
}

```
