# Passport Numbers Namespace for MAURITIUS - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for MAURITIUS**

## NamingSystem: Passport Numbers Namespace for MAURITIUS 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-MUS | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_MUS |

 
Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-MUS |
| Version | 1.0.0 |
| Name | PassportNumNS_MUS |
| Title | Passport Numbers Namespace for MAURITIUS |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.480
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-MUS
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-MUS",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-MUS",
  "version" : "1.0.0",
  "name" : "PassportNumNS_MUS",
  "title" : "Passport Numbers Namespace for MAURITIUS",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of MAURITIUS.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.480",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-MUS",
      "preferred" : true
    }
  ]
}

```
