# Passport Numbers Namespace for LATVIA - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for LATVIA**

## NamingSystem: Passport Numbers Namespace for LATVIA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-LVA | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_LVA |

 
Identifier of the namespace for Passport Numbers issued by the country of LATVIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-LVA |
| Version | 1.0.0 |
| Name | PassportNumNS_LVA |
| Title | Passport Numbers Namespace for LATVIA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of LATVIA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.428
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-LVA
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-LVA",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-LVA",
  "version" : "1.0.0",
  "name" : "PassportNumNS_LVA",
  "title" : "Passport Numbers Namespace for LATVIA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of LATVIA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.428",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-LVA",
      "preferred" : true
    }
  ]
}

```
