# Passport Numbers Namespace for GUINEA - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for GUINEA**

## NamingSystem: Passport Numbers Namespace for GUINEA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-GIN | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_GIN |

 
Identifier of the namespace for Passport Numbers issued by the country of GUINEA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-GIN |
| Version | 1.0.0 |
| Name | PassportNumNS_GIN |
| Title | Passport Numbers Namespace for GUINEA |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of GUINEA. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.324
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-GIN
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-GIN",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-GIN",
  "version" : "1.0.0",
  "name" : "PassportNumNS_GIN",
  "title" : "Passport Numbers Namespace for GUINEA",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of GUINEA.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.324",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-GIN",
      "preferred" : true
    }
  ]
}

```
