# GTIN Global Trade Item Number - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GTIN Global Trade Item Number**

## NamingSystem: GTIN Global Trade Item Number 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/gtin | *Version*:3.0.0 |
| Active as of 2022-02-07 | *Computable Name*:Gtin |

 
The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain. Note: GTINs may be used in both Codes (http://build.fhir.org/datatypes.html#Coding) and Identifiers (http://build.fhir.org/datatypes.html#Identifier). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/gtin |
| Version | 3.0.0 |
| Name | Gtin |
| Title | GTIN Global Trade Item Number |
| Status | active |
| Definition | The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain. Note: GTINs may be used in both Codes (http://build.fhir.org/datatypes.html#Coding) and Identifiers (http://build.fhir.org/datatypes.html#Identifier). |

### Identifiers

* **Type**: OID
  * **Value**: 1.3.160
  * **Preferred**: true
* **Type**: URI
  * **Value**: https://www.gs1.org/gtin
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "gtin",
  "url" : "http://terminology.hl7.org/NamingSystem/gtin",
  "version" : "3.0.0",
  "name" : "Gtin",
  "title" : "GTIN Global Trade Item Number",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "description" : "The GS1 GTIN is a globally unique identifier of trade items. A trade item is any item (product or service) upon which there is a need to retrieve pre-defined information and that may be priced, or ordered, or invoiced at any point in any supply chain. Note: GTINs may be used in both Codes (http://build.fhir.org/datatypes.html#Coding) and Identifiers (http://build.fhir.org/datatypes.html#Identifier).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.3.160",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://www.gs1.org/gtin",
      "preferred" : true
    }
  ]
}

```
