# Occupation CDC Census 2010 - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Occupation CDC Census 2010**

## NamingSystem: Occupation CDC Census 2010 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/PHOccupationCDCCensus2010 | *Version*:2.1.0 |
| Active as of 2019-03-20 | *Computable Name*:PHOccupationCDCCensus2010 |

 
2010 Occupation coding system used by CDC (NIOSH and NCHS) for coding occupation text. Occupation describes a set of activities or tasks that individuals are paid to perform or, if unpaid, define a person's contribution to a household/family business/community. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/PHOccupationCDCCensus2010 |
| Version | 2.1.0 |
| Name | PHOccupationCDCCensus2010 |
| Title | Occupation CDC Census 2010 |
| Status | active |
| Definition | 2010 Occupation coding system used by CDC (NIOSH and NCHS) for coding occupation text. Occupation describes a set of activities or tasks that individuals are paid to perform or, if unpaid, define a person's contribution to a household/family business/community. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.114222.4.5.314
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/PHOccupationCDCCensus2010
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "PHOccupationCDCCensus2010",
  "url" : "http://terminology.hl7.org/NamingSystem/PHOccupationCDCCensus2010",
  "version" : "2.1.0",
  "name" : "PHOccupationCDCCensus2010",
  "title" : "Occupation CDC Census 2010",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "description" : "2010 Occupation coding system used by CDC (NIOSH and NCHS) for coding occupation text. Occupation describes a set of activities or tasks that individuals are paid to perform or, if unpaid, define a person's contribution to a household/family business/community.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.114222.4.5.314",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/PHOccupationCDCCensus2010",
      "preferred" : true
    }
  ]
}

```
