# Open Eligibility Taxonomy - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Open Eligibility Taxonomy**

## NamingSystem: Open Eligibility Taxonomy 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/OpenEligibilityTaxonomy | *Version*:1.0.0 |
| Active as of 2023-04-21 | *Computable Name*:OpenEligibilityTaxonomy |
| **Copyright/Legal**: "The Open Eligibility Human Services Taxonomy by Aunt Bertha, Inc. is licensed under a Creative Commons Attribution-ShareAlike 3.0 Unported License." | |

 
"The Open Eligibility Project is a collaborative for a series of standards for the human services sector. The Open Eligibility taxonomy is a simple way to categorize human services and human situations. With these common categories, we, as service providers, navigators, and people in need, can find human services quickly and easily." 
"The Open Eligibility taxonomy consists of two important concepts: Human Services and Human Situations. 
Human Services are services offered by government or charitable organizations, and include things such as housing, food pantries or counseling services. 
Human Situations are ways of describing attributes of a person that could help them find programs they are looking for, including examples like: veterans, physical disability or seniors." 
For more information, see[https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project](https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/OpenEligibilityTaxonomy |
| Version | 1.0.0 |
| Name | OpenEligibilityTaxonomy |
| Title | Open Eligibility Taxonomy |
| Status | active |
| Definition | "The Open Eligibility Project is a collaborative for a series of standards for the human services sector. The Open Eligibility taxonomy is a simple way to categorize human services and human situations. With these common categories, we, as service providers, navigators, and people in need, can find human services quickly and easily.""The Open Eligibility taxonomy consists of two important concepts: Human Services and Human Situations.Human Services are services offered by government or charitable organizations, and include things such as housing, food pantries or counseling services.Human Situations are ways of describing attributes of a person that could help them find programs they are looking for, including examples like: veterans, physical disability or seniors."For more information, see [https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project](https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project) |
| Copyright | "The Open Eligibility Human Services Taxonomy by Aunt Bertha, Inc. is licensed under a Creative Commons Attribution-ShareAlike 3.0 Unported License." |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/OpenEligibilityTaxonomy
  * **Preferred**: true
  * **Period**: 2023-03-08 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "OpenEligibilityTaxonomy",
  "url" : "http://terminology.hl7.org/NamingSystem/OpenEligibilityTaxonomy",
  "version" : "1.0.0",
  "name" : "OpenEligibilityTaxonomy",
  "title" : "Open Eligibility Taxonomy",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-04-21T00:00:00-00:00",
  "contact" : [
    {
      "name" : "Findhelp; The Open Eligibility Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://company.findhelp.com/"
        },
        {
          "system" : "email",
          "value" : "support@findhelp.com"
        }
      ]
    }
  ],
  "description" : "\"The Open Eligibility Project is a collaborative for a series of standards for the human services sector. The Open Eligibility taxonomy is a simple way to categorize human services and human situations. With these common categories, we, as service providers, navigators, and people in need, can find human services quickly and easily.\"\r\n\r\n\"The Open Eligibility taxonomy consists of two important concepts: Human Services and Human Situations.\r\n\r\nHuman Services are services offered by government or charitable organizations, and include things such as housing, food pantries or counseling services.\r\n\r\nHuman Situations are ways of describing attributes of a person that could help them find programs they are looking for, including examples like: veterans, physical disability or seniors.\"\r\n\r\nFor more information, see [https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project](https://support.findhelp.com/hc/en-us/articles/4404055283227-The-Open-Eligibility-Project)",
  "copyright" : "\"The Open Eligibility Human Services Taxonomy by Aunt Bertha, Inc. is licensed under a Creative Commons Attribution-ShareAlike 3.0 Unported License.\"",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/OpenEligibilityTaxonomy",
      "preferred" : true,
      "period" : {
        "start" : "2023-03-08"
      }
    }
  ]
}

```
