# National Drug File Reference Terminology (NDF-RT) - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **National Drug File Reference Terminology (NDF-RT)**

## NamingSystem: National Drug File Reference Terminology (NDF-RT) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NDFRT | *Version*:1.0.0 | |
| Active as of 2022-08-23 | *Responsible:*[National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS)](https://www.va.gov/) | *Computable Name*:NDFRT |
| **Copyright/Legal**: NDF-RT is released as part of UMLS. Therefore, each successive release has the date of the UMLS release as its version. | | |

 
NDF-RT is a concept-oriented terminology, a collection of concepts, each of which represents a single, unique meaning. Every concept has one fully-specified name and an arbitrary number of other names, all of which are intended to mean the same thing and are therefore synonymous terms. Synonymous terms from external vocabulary sources may have associated unique identifiers. Publication of NDF-RT has ended. The Medication Reference Terminology (MED-RT) is the evolutionary successor to the NDF-RT. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NDFRT |
| Version | 1.0.0 |
| Name | NDFRT |
| Title | National Drug File Reference Terminology (NDF-RT) |
| Status | active |
| Definition | NDF-RT is a concept-oriented terminology, a collection of concepts, each of which represents a single, unique meaning. Every concept has one fully-specified name and an arbitrary number of other names, all of which are intended to mean the same thing and are therefore synonymous terms. Synonymous terms from external vocabulary sources may have associated unique identifiers. Publication of NDF-RT has ended. The Medication Reference Terminology (MED-RT) is the evolutionary successor to the NDF-RT. |
| Publisher | National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS) |
| Copyright | NDF-RT is released as part of UMLS. Therefore, each successive release has the date of the UMLS release as its version. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.209
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/ndfrt
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NDFRT",
  "url" : "http://terminology.hl7.org/NamingSystem/NDFRT",
  "version" : "1.0.0",
  "name" : "NDFRT",
  "title" : "National Drug File Reference Terminology (NDF-RT)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-08-23T00:00:00-00:00",
  "publisher" : "National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS)",
  "contact" : [
    {
      "name" : "U.S. Department of Veterans Affairs, Veterans Health Administration",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.va.gov/"
        }
      ]
    }
  ],
  "responsible" : "U.S. Department of Veterans Affairs, Veterans Health Administration",
  "description" : "NDF-RT is a concept-oriented terminology, a collection of concepts, each of which represents a single, unique meaning. Every concept has one fully-specified name and an arbitrary number of other names, all of which are intended to mean the same thing and are therefore synonymous terms. Synonymous terms from external vocabulary sources may have associated unique identifiers. Publication of NDF-RT has ended. The Medication Reference Terminology (MED-RT) is the evolutionary successor to the NDF-RT.",
  "copyright" : "NDF-RT is released as part of UMLS. Therefore, each successive release has the date of the UMLS release as its version.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.209",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/ndfrt",
      "preferred" : true
    }
  ]
}

```
