# NCPDP Compound Code - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NCPDP Compound Code**

## NamingSystem: NCPDP Compound Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NCPDPCompoundCode | *Version*:1.0.1 | |
| Active as of 2021-03-10 | *Responsible:*National Council for Prescription Drug Programs | *Computable Name*:NCPDPCompoundCode |

 
Code indicating whether or not the prescription is a compound. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NCPDPCompoundCode |
| Version | 1.0.1 |
| Name | NCPDPCompoundCode |
| Title | NCPDP Compound Code |
| Status | active |
| Definition | Code indicating whether or not the prescription is a compound. |
| Publisher | National Council for Prescription Drug Programs |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/NCPDPCompoundCode
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NCPDPCompoundCode",
  "url" : "http://terminology.hl7.org/NamingSystem/NCPDPCompoundCode",
  "version" : "1.0.1",
  "name" : "NCPDPCompoundCode",
  "title" : "NCPDP Compound Code",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-03-10T00:00:00-04:00",
  "publisher" : "National Council for Prescription Drug Programs",
  "contact" : [
    {
      "name" : "National Council for Prescription Drug Programs",
      "telecom" : [
        {
          "system" : "phone",
          "value" : "480.477.1000"
        },
        {
          "system" : "email",
          "value" : "info@ncpdp.org"
        }
      ]
    }
  ],
  "responsible" : "National Council for Prescription Drug Programs",
  "description" : "Code indicating whether or not the prescription is a compound.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/NCPDPCompoundCode",
      "preferred" : true
    }
  ]
}

```
