# ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types**

## NamingSystem: ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ISBT128PropertyTypes | *Version*:1.1.0 | |
| Active as of 2025-10-30 | *Responsible:*[ICCBBA](https://www.isbt128.org/) | *Computable Name*:ISBT128PropertyTypes |
| **Copyright/Legal**: ISBT 128 is owned by ICCBBA and protected by copyright.The ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.ICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See[https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing). | | |

 
ISBT 128 Reference Table 042 provides data references for ISBT 128 Standard data structures used for the transfer of data pertaining to medical products of human origin within electronic messages. For more information, see[https://www.isbt128.org/uri](https://www.isbt128.org/uri). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ISBT128PropertyTypes |
| Version | 1.1.0 |
| Name | ISBT128PropertyTypes |
| Title | ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types |
| Status | active |
| Definition | ISBT 128 Reference Table 042 provides data references for ISBT 128 Standard data structures used for the transfer of data pertaining to medical products of human origin within electronic messages. For more information, see [https://www.isbt128.org/uri](https://www.isbt128.org/uri). |
| Publisher | ICCBBA |
| Copyright | ISBT 128 is owned by ICCBBA and protected by copyright.The ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.ICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See [https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing). |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.18
  * **Preferred**: true
  * **Period**: 2025-10-30 --> (ongoing)
  * **Comment**: 
* **Type**: URI
  * **Value**: https://www.isbt128.org/uri
  * **Preferred**: true
  * **Period**: 2025-10-30 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ISBT128PropertyTypes",
  "url" : "http://terminology.hl7.org/NamingSystem/ISBT128PropertyTypes",
  "version" : "1.1.0",
  "name" : "ISBT128PropertyTypes",
  "title" : "ISBT 128 Standard Terminology for Medical Products of Human Origin Property Types",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2025-10-30T00:00:00-00:00",
  "publisher" : "ICCBBA",
  "contact" : [
    {
      "name" : "ICCBBA; P.O. Box 11309, San Bernardino, CA 92374, United States",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.isbt128.org/"
        },
        {
          "system" : "email",
          "value" : "iccbba@iccbba.org"
        },
        {
          "system" : "phone",
          "value" : "+1 909 793 6516"
        }
      ]
    }
  ],
  "responsible" : "ICCBBA",
  "description" : "ISBT 128 Reference Table 042 provides data references for ISBT 128 Standard data structures used for the transfer of data pertaining to medical products of human origin within electronic messages. For more information, see [https://www.isbt128.org/uri](https://www.isbt128.org/uri).",
  "copyright" : "ISBT 128 is owned by ICCBBA and protected by copyright.\r\n\r\nThe ISBT 128 information standard and its accompanying databases, reference tables, documentation, and software tools are licensed and not sold. ISBT 128 is owned by ICCBBA and protected by copyright.\r\n\r\nICCBBA grants three types of licenses for the use of ISBT 128; Vendor, Limited Use Vendor, and Facility. Each license category has unique limitations as to how licensees can use ISBT 128. See [https://www.isbt128.org/registration-licensing](https://www.isbt128.org/registration-licensing).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.18",
      "preferred" : true,
      "period" : {
        "start" : "2025-10-30"
      }
    },
    {
      "type" : "uri",
      "value" : "https://www.isbt128.org/uri",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2025-10-30"
      }
    }
  ]
}

```
