# College of American Pathologists (CAP) eCC (electronic Cancer Checklists) - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **College of American Pathologists (CAP) eCC (electronic Cancer Checklists)**

## NamingSystem: College of American Pathologists (CAP) eCC (electronic Cancer Checklists) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CAPeCC | *Version*:1.0.0 | |
| Active as of 2022-07-05 | *Responsible:*[College of American Pathologists](https://www.cap.org/) | *Computable Name*:CAPeCC |
| **Copyright/Legal**: Copyright by College of American Pathologists. All rights reserved.Licensing is required. Contact the CAP at capecc@cap.org for more information about licensing and using the CAP eCC for cancer reporting. | | |

 
"The College of American Pathologists (CAP) eCC (electronic Cancer Checklists) enables pathologists to use the[CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols)directly within their laboratory information system (LIS) workflow and to ensure that each report is completed with the necessary required elements. Most anatomic pathology (AP)-LIS vendors offer a CAP eCC synoptic module for reporting on surgical cancer resections and selected biopsies." 
"The CAP eCC is based on the[CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols)and is produced under the guidance of the[CAP Pathology Electronic Reporting (PERT) Committee](https://www.cap.org/member-resources/councils-committees/pathology-electronic-reporting-pert-committee)along with close interaction and advisement of the[Cancer Committee](https://www.cap.org/member-resources/councils-committees/cancer-committee). 
The eCC is developed in collaboration with and partially underwritten by the Centers for Disease Control and Prevention (CDC). Additional collaborators include the American Joint Committee on Cancer (AJCC), Cancer Care Ontario (CCO), and the North American Association of Central Cancer Registries (NAACCR). 
The CAP currently is working with the[California Cancer Registry (CCR)](http://www.ccrcal.org/)to offer the benefits of the eCC to California laboratories. CCR and the CAP are seeking out laboratories interested in participating in an ongoing project using the eCC to directly transfer cancer data to the central registry." 
"The CAP releases eCC templates on a rolling basis, coordinating as much as possible with the posting of new and revised[Cancer Protocols and Cancer Biomarker Reporting Templates](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocol-templates). A few weeks prior to each Major or Agile release, email notifications are sent out to all licensed CAP eCC users." For more information, see page[here](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CAPeCC |
| Version | 1.0.0 |
| Name | CAPeCC |
| Title | College of American Pathologists (CAP) eCC (electronic Cancer Checklists) |
| Status | active |
| Definition | "The College of American Pathologists (CAP) eCC (electronic Cancer Checklists) enables pathologists to use the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) directly within their laboratory information system (LIS) workflow and to ensure that each report is completed with the necessary required elements. Most anatomic pathology (AP)-LIS vendors offer a CAP eCC synoptic module for reporting on surgical cancer resections and selected biopsies.""The CAP eCC is based on the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) and is produced under the guidance of the [CAP Pathology Electronic Reporting (PERT) Committee](https://www.cap.org/member-resources/councils-committees/pathology-electronic-reporting-pert-committee) along with close interaction and advisement of the [Cancer Committee](https://www.cap.org/member-resources/councils-committees/cancer-committee).The eCC is developed in collaboration with and partially underwritten by the Centers for Disease Control and Prevention (CDC). Additional collaborators include the American Joint Committee on Cancer (AJCC), Cancer Care Ontario (CCO), and the North American Association of Central Cancer Registries (NAACCR).The CAP currently is working with the [California Cancer Registry (CCR)](http://www.ccrcal.org/) to offer the benefits of the eCC to California laboratories. CCR and the CAP are seeking out laboratories interested in participating in an ongoing project using the eCC to directly transfer cancer data to the central registry.""The CAP releases eCC templates on a rolling basis, coordinating as much as possible with the posting of new and revised [Cancer Protocols and Cancer Biomarker Reporting Templates](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocol-templates). A few weeks prior to each Major or Agile release, email notifications are sent out to all licensed CAP eCC users." For more information, see page [here](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc) |
| Publisher | College of American Pathologists |
| Copyright | Copyright by College of American Pathologists. All rights reserved.Licensing is required. Contact the CAP at capecc@cap.org for more information about licensing and using the CAP eCC for cancer reporting. |

### Identifiers

* **Type**: URI
  * **Value**: http://cap.org/eCC
  * **Preferred**: true
  * **Period**: 2022-06-30 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CAPeCC",
  "url" : "http://terminology.hl7.org/NamingSystem/CAPeCC",
  "version" : "1.0.0",
  "name" : "CAPeCC",
  "title" : "College of American Pathologists (CAP) eCC (electronic Cancer Checklists)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-07-05T00:00:00-00:00",
  "publisher" : "College of American Pathologists",
  "contact" : [
    {
      "name" : "College of American Pathologists; 325 Waukegan Road, Northfield, IL 60093-2750",
      "telecom" : [
        {
          "system" : "email",
          "value" : "capecc@cap.org"
        },
        {
          "system" : "url",
          "value" : "https://www.cap.org/"
        },
        {
          "system" : "phone",
          "value" : "847-832-7700"
        }
      ]
    }
  ],
  "responsible" : "College of American Pathologists",
  "description" : "\"The College of American Pathologists (CAP) eCC (electronic Cancer Checklists) enables pathologists to use the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) directly within their laboratory information system (LIS) workflow and to ensure that each report is completed with the necessary required elements. Most anatomic pathology (AP)-LIS vendors offer a CAP eCC synoptic module for reporting on surgical cancer resections and selected biopsies.\"\r\n\r\n\"The CAP eCC is based on the [CAP Cancer Protocols](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocols) and is produced under the guidance of the [CAP Pathology Electronic Reporting (PERT) Committee](https://www.cap.org/member-resources/councils-committees/pathology-electronic-reporting-pert-committee) along with close interaction and advisement of the [Cancer Committee](https://www.cap.org/member-resources/councils-committees/cancer-committee).\r\n\r\nThe eCC is developed in collaboration with and partially underwritten by the Centers for Disease Control and Prevention (CDC). Additional collaborators include the American Joint Committee on Cancer (AJCC), Cancer Care Ontario (CCO), and the North American Association of Central Cancer Registries (NAACCR).\r\n\r\nThe CAP currently is working with the [California Cancer Registry (CCR)](http://www.ccrcal.org/) to offer the benefits of the eCC to California laboratories. CCR and the CAP are seeking out laboratories interested in participating in an ongoing project using the eCC to directly transfer cancer data to the central registry.\"\r\n\r\n\"The CAP releases eCC templates on a rolling basis, coordinating as much as possible with the posting of new and revised [Cancer Protocols and Cancer Biomarker Reporting Templates](https://www.cap.org/protocols-and-guidelines/cancer-reporting-tools/cancer-protocol-templates). A few weeks prior to each Major or Agile release, email notifications are sent out to all licensed CAP eCC users.\" For more information, see page [here](https://www.cap.org/laboratory-improvement/proficiency-testing/cap-ecc)",
  "copyright" : "Copyright by College of American Pathologists. All rights reserved.\r\n\r\nLicensing is required. Contact the CAP at capecc@cap.org for more information about licensing and using the CAP eCC for cancer reporting.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://cap.org/eCC",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-06-30"
      }
    }
  ]
}

```
