# ADA Universal Tooth Designation System - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ADA Universal Tooth Designation System**

## NamingSystem: ADA Universal Tooth Designation System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ADAUniversalToothDesignationSystem | *Version*:1.0.0 | |
| Active as of 2022-04-07 | *Responsible:*American Dental Association | *Computable Name*:ADAUniversalToothDesignationSystem |
| **Copyright/Legal**: No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf | | |

 
The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994. 
The universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. 
Teeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32). 
Supernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32). 
The Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. 
A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ADAUniversalToothDesignationSystem |
| Version | 1.0.0 |
| Name | ADAUniversalToothDesignationSystem |
| Title | ADA Universal Tooth Designation System |
| Status | active |
| Definition | The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994.The universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.Teeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32).Supernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32).The Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form.A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf |
| Publisher | American Dental Association |
| Copyright | No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ADAUniversalToothDesignationSystem
  * **Preferred**: true
  * **Period**: 2022-04-07 --> (ongoing)
  * **Comment**: This is the URL endorsed by the HTA and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ADAUniversalToothDesignationSystem",
  "url" : "http://terminology.hl7.org/NamingSystem/ADAUniversalToothDesignationSystem",
  "version" : "1.0.0",
  "name" : "ADAUniversalToothDesignationSystem",
  "title" : "ADA Universal Tooth Designation System",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-04-07T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994.\r\n\r\nThe universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nTeeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32).\r\n\r\nSupernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32).\r\n\r\nThe Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf",
  "copyright" : "No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ADAUniversalToothDesignationSystem",
      "preferred" : true,
      "comment" : "This is the URL endorsed by the HTA and is considered authoritative.",
      "period" : {
        "start" : "2022-04-07"
      }
    }
  ]
}

```
