# VerificationResult Communication Method - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **VerificationResult Communication Method**

## CodeSystem: VerificationResult Communication Method 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/verificationresult-communication-method | *Version*:1.0.0 | | |
| Active as of 2018-10-31 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Verificationresult_communication_method |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1402 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VerificationResult_communication_method](ValueSet-verificationresult-communication-method.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "verificationresult-communication-method",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/verificationresult-communication-method",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1402"
    }
  ],
  "version" : "1.0.0",
  "name" : "Verificationresult_communication_method",
  "title" : "VerificationResult Communication Method",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-10-31",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Attested information may be validated by process that are manual or automated. For automated processes it may accomplished by the system of record reaching out through another system's API or information may be sent to the system of record. This value set defines a set of codes to describing the process, the how, a resource or data element is validated.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/verificationresult-communication-method",
  "content" : "complete",
  "concept" : [
    {
      "code" : "manual",
      "display" : "Manual",
      "definition" : "The information is submitted/retrieved manually (e.g. by phone, fax, paper-based)"
    },
    {
      "code" : "portal",
      "display" : "Portal",
      "definition" : "The information is submitted/retrieved via a portal"
    },
    {
      "code" : "pull",
      "display" : "Pull",
      "definition" : "The information is retrieved (i.e. pulled) from a source (e.g. over an API)"
    },
    {
      "code" : "push",
      "display" : "Push",
      "definition" : "The information is sent (i.e. pushed) from a source (e.g. over an API, asynchronously, secure messaging)"
    }
  ]
}

```
