# sequenceStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **sequenceStatus**

## CodeSystem: sequenceStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/variant-state | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SequenceStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1085 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes providing the status of the variant test result. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SequenceStatus](ValueSet-variant-state.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "variant-state",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/variant-state",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1085"
    }
  ],
  "version" : "1.0.0",
  "name" : "SequenceStatus",
  "title" : "sequenceStatus",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes providing the status of the variant test result.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/variant-state",
  "content" : "complete",
  "concept" : [
    {
      "code" : "positive",
      "display" : "positive",
      "definition" : "the variant is detected."
    },
    {
      "code" : "negative",
      "display" : "negative",
      "definition" : "no variant is detected."
    },
    {
      "code" : "absent",
      "display" : "absent",
      "definition" : "result of the variant is missing."
    }
  ]
}

```
