# HL7VoteResolution - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7VoteResolution**

## CodeSystem: HL7VoteResolution 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-hl7VoteResolution | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Hl7VoteResolution |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1131 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**Based on concepts for resolutions from HL7 ballot spreadsheet according to HL7's Governance & Operations Manual (GOM). 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-hl7VoteResolution",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-hl7VoteResolution",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1131"
    }
  ],
  "version" : "3.0.0",
  "name" : "Hl7VoteResolution",
  "title" : "HL7VoteResolution",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:** Based on concepts for resolutions from HL7 ballot spreadsheet according to HL7's Governance & Operations Manual (GOM).",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "affirmativeResolution",
      "display" : "affirmative resolution",
      "definition" : "**Description:** An abstract concept grouping resolutions that can be applied to affirmative ballot comments.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23133"
        }
      ],
      "concept" : [
        {
          "code" : "affdef",
          "display" : "affirmative-deferred",
          "definition" : "**Description:** The recommended change has been deferred to consideration for a future release.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23136"
            }
          ]
        },
        {
          "code" : "affi",
          "display" : "affirmative-incorporated",
          "definition" : "**Description:** The recommended change has been incorporated or identified issue has been answered.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23134"
            }
          ]
        },
        {
          "code" : "affr",
          "display" : "affirmative-rejected",
          "definition" : "**Description:** The recommended change has been refused and is not expected to be incorporated.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23135"
            }
          ]
        }
      ]
    },
    {
      "code" : "negativeResolution",
      "display" : "negative resolution",
      "definition" : "**Description:** An abstract concept grouping resolutions that can be applied to negative ballot comments.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23137"
        }
      ],
      "concept" : [
        {
          "code" : "nonsubp",
          "display" : "non-substantive proposed",
          "definition" : "**Description:** Responsible group has recommended that the negative vote be considered non-substantive. (Issue raised does not provide sufficiently convincing reason to make changes to the item under ballot, or otherwise impede its adoption.)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23139"
            }
          ]
        },
        {
          "code" : "nonsubv",
          "display" : "non-substantive voted",
          "definition" : "**Description:** Ballot group has voted and declared the negative vote non-substantive.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23140"
            }
          ]
        },
        {
          "code" : "notrelp",
          "display" : "not related proposed",
          "definition" : "**Description:** Responsible group has recommended that the negative vote be considered not-related. (Issue raised is not related to the current scope of the item under ballot, or does not prevent the item under ballot for being used for its defined intent. Recommended changes may be considered as part of future versions.) (Perhaps after further reading or explanation).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23141"
            }
          ]
        },
        {
          "code" : "notrelv",
          "display" : "not related voted",
          "definition" : "**Description:** Ballot group has voted and declared the negative vote non-related.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23142"
            }
          ]
        },
        {
          "code" : "prevcons",
          "display" : "previously considered",
          "definition" : "**Description:** Committee identifies that the same issue has been raised as part of a previous ballot on the same element version and was found by the ballot group to be non-substantive or not related.)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23143"
            }
          ]
        },
        {
          "code" : "retract",
          "display" : "retracted",
          "definition" : "**Description:** Voter has formally withdrawn their vote or comment as having been in error. (Perhaps after further reading or explanation).",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23144"
            }
          ]
        },
        {
          "code" : "unresolved",
          "display" : "unresolved",
          "definition" : "**Description:** Vote has not yet gone through resolution.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23138"
            }
          ]
        },
        {
          "code" : "withdraw",
          "display" : "withdrawn",
          "definition" : "**Description:** Voter has formally withdrawn their vote or comment on the basis of agreed changes or proposed future changes.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23145"
            }
          ]
        }
      ]
    }
  ]
}

```
