# ResponseLevel - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResponseLevel**

## CodeSystem: ResponseLevel 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ResponseLevel | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResponseLevel |
| *Other Identifiers:*OID:2.16.840.1.113883.5.108 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Specifies whether a response is expected from the addressee of this interaction and what level of detail that response should include 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResponseLevel](ValueSet-v3-ResponseLevel.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ResponseLevel",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ResponseLevel",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.108"
    }
  ],
  "version" : "3.0.0",
  "name" : "ResponseLevel",
  "title" : "ResponseLevel",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Specifies whether a response is expected from the addressee of this interaction and what level of detail that response should include",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "completion",
      "definition" : "Respond with exceptions and a notification of completion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14763"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "detail",
      "definition" : "Respond with exceptions, completion, modifications and include more detail information (if applicable)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14765"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "exception",
      "definition" : "Respond with exceptions only",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14762"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "confirmation",
      "definition" : "Respond with exceptions, completion, and modification with detail (as above), and send positive confirmations even if no modifications are being made.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14766"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "message-control",
      "definition" : "Respond only with message level acknowledgements, i.e., only notify acceptance or rejection of the message, do not include any application-level detail",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14767"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "modification",
      "definition" : "Respond with exceptions, completions and modifications or revisions done before completion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14764"
        }
      ]
    },
    {
      "code" : "X",
      "display" : "none",
      "definition" : "Do not send any kind of response",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14768"
        }
      ]
    }
  ]
}

```
