# ObservationMethod - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ObservationMethod**

## CodeSystem: ObservationMethod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ObservationMethod | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.5.84 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A code that provides additional detail about the means or technique used to ascertain the observation. 
**Examples:**Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc. 
**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. Note that the Domain has a full discussion about use of the attribute and constraining that is not appropriate for the code system description. Needs to be improved. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AlgorithmicDecisionObservationMethod](ValueSet-v3-AlgorithmicDecisionObservationMethod.md)
* [DecisionObservationMethod](ValueSet-v3-DecisionObservationMethod.md)
* [GeneticObservationMethod](ValueSet-v3-GeneticObservationMethod.md)
* [ObservationMethod](ValueSet-v3-ObservationMethod.md)
* [ObservationMethodAggregate](ValueSet-v3-ObservationMethodAggregate.md)
* [SusceptibilityObservationMethodType](ValueSet-v3-SusceptibilityObservationMethodType.md)
* [VerificationMethod](ValueSet-v3-VerificationMethod.md)
* [Tst0272](ValueSet-v3-tst0272.md)
* [Tst0275a](ValueSet-v3-tst0275a.md)
* [Tst0280](ValueSet-v3-tst0280.md)
* [XAdverseEventCausalityAssessmentMethods](ValueSet-v3-xAdverseEventCausalityAssessmentMethods.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ObservationMethod",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ObservationMethod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.84"
    }
  ],
  "version" : "3.0.0",
  "name" : "ObservationMethod",
  "title" : "ObservationMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A code that provides additional detail about the means or technique used to ascertain the observation.\r\n\r\n*Examples:* Blood pressure measurement method: arterial puncture vs. sphygmomanometer (Riva-Rocci), sitting vs. supine position, etc.\r\n\r\n*OpenIssue:* Description copied from Concept Domain of same name. Must be verified. Note that the Domain has a full discussion about use of the attribute and constraining that is not appropriate for the code system description. Needs to be improved.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "howApplies",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-how-applies",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_DecisionObservationMethod",
      "display" : "DecisionObservationMethod",
      "definition" : "Provides codes for decision methods, initially for assessing the causality of events.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21094"
        }
      ],
      "concept" : [
        {
          "code" : "ALGM",
          "display" : "algorithm",
          "definition" : "Reaching a decision through the application of an algorithm designed to weigh the different factors involved.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19992"
            }
          ],
          "concept" : [
            {
              "code" : "BYCL",
              "display" : "bayesian calculation",
              "definition" : "Reaching a decision through the use of Bayesian statistical analysis.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19993"
                }
              ]
            }
          ]
        },
        {
          "code" : "GINT",
          "display" : "global introspection",
          "definition" : "Reaching a decision by consideration of the totality of factors involved in order to reach a judgement.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "19991"
            }
          ]
        }
      ]
    },
    {
      "code" : "_GeneticObservationMethod",
      "display" : "GeneticObservationMethod",
      "definition" : "A code that provides additional detail about the means or technique used to ascertain the genetic analysis. Example, PCR, Micro Array",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22644"
        }
      ],
      "concept" : [
        {
          "code" : "PCR",
          "display" : "PCR",
          "definition" : "**Description:** Polymerase Chain Reaction",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22645"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ObservationMethodAggregate",
      "display" : "observation method aggregate",
      "definition" : "Provides additional detail about the aggregation methods used to compute the aggregated values for an observation. This is an abstract code.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23444"
        }
      ],
      "concept" : [
        {
          "code" : "AVERAGE",
          "display" : "average",
          "definition" : "Average of non-null values in the referenced set of values",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23447"
            }
          ]
        },
        {
          "code" : "COUNT",
          "display" : "count",
          "definition" : "Count of non-null values in the referenced set of values",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23445"
            }
          ]
        },
        {
          "code" : "MAX",
          "display" : "maxima",
          "definition" : "Largest of all non-null values in the referenced set of values.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23453"
            }
          ]
        },
        {
          "code" : "MEDIAN",
          "display" : "median",
          "definition" : "The median of all non-null values in the referenced set of values.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23454"
            }
          ]
        },
        {
          "code" : "MIN",
          "display" : "minima",
          "definition" : "Smallest of all non-null values in the referenced set of values.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23452"
            }
          ]
        },
        {
          "code" : "MODE",
          "display" : "mode",
          "definition" : "The most common value of all non-null values in the referenced set of values.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23455"
            }
          ]
        },
        {
          "code" : "STDEV.P",
          "display" : "population standard deviation",
          "definition" : "Standard Deviation of the values in the referenced set of values, computed over the population.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23450"
            }
          ]
        },
        {
          "code" : "STDEV.S",
          "display" : "sample standard deviation",
          "definition" : "Standard Deviation of the values in the referenced set of values, computed over a sample of the population.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23448"
            }
          ]
        },
        {
          "code" : "SUM",
          "display" : "sum",
          "definition" : "Sum of non-null values in the referenced set of values",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23446"
            }
          ]
        },
        {
          "code" : "VARIANCE.P",
          "display" : "population variance",
          "definition" : "Variance of the values in the referenced set of values, computed over the population.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23451"
            }
          ]
        },
        {
          "code" : "VARIANCE.S",
          "display" : "sample variance",
          "definition" : "Variance of the values in the referenced set of values, computed over a sample of the population.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23449"
            }
          ]
        }
      ]
    },
    {
      "code" : "_VerificationMethod",
      "display" : "VerificationMethod",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21512"
        }
      ],
      "concept" : [
        {
          "code" : "VDOC",
          "display" : "document verification",
          "definition" : "Verification by means of document.\r\n\r\n*Example:* Fax, letter, attachment to e-mail.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21515"
            }
          ]
        },
        {
          "code" : "VREG",
          "display" : "registry verification",
          "definition" : "verification by means of a response to an electronic query\r\n\r\n*Example:* query message to a Covered Party registry application or Coverage Administrator.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21514"
            }
          ]
        },
        {
          "code" : "VTOKEN",
          "display" : "electronic token verification",
          "definition" : "Verification by means of electronic token.\r\n\r\n*Example:* smartcard, magnetic swipe card, RFID device.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21513"
            }
          ]
        },
        {
          "code" : "VVOICE",
          "display" : "voice-based verification",
          "definition" : "Verification by means of voice.\r\n\r\n*Example:* By speaking with or calling the Coverage Administrator or Covered Party",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21516"
            }
          ]
        }
      ]
    },
    {
      "code" : "0001",
      "display" : "Complement fixation",
      "definition" : "Complement fixation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14080"
        }
      ]
    },
    {
      "code" : "0002",
      "display" : "Computed axial tomography",
      "definition" : "Computed axial tomography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14081"
        }
      ]
    },
    {
      "code" : "0003",
      "display" : "HLAR agar test",
      "definition" : "Susceptibility, High Level Aminoglycoside Resistance agar test",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14082"
        }
      ]
    },
    {
      "code" : "0004",
      "display" : "Macroscopic observation",
      "definition" : "Visual, Macroscopic observation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14083"
        }
      ]
    },
    {
      "code" : "0005",
      "display" : "Magnetic resonance",
      "definition" : "Computed, Magnetic resonance",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14084"
        }
      ]
    },
    {
      "code" : "0006",
      "display" : "Morphometry",
      "definition" : "Computed, Morphometry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14085"
        }
      ]
    },
    {
      "code" : "0007",
      "display" : "Positron emission tomography",
      "definition" : "Computed, Positron emission tomography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14086"
        }
      ]
    },
    {
      "code" : "0008",
      "display" : "SAMHSA confirmation",
      "definition" : "SAMHSA drug assay confirmation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14087"
        }
      ]
    },
    {
      "code" : "0009",
      "display" : "SAMHSA screening",
      "definition" : "SAMHSA drug assay screening",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14088"
        }
      ]
    },
    {
      "code" : "0010",
      "display" : "Serum Neutralization",
      "definition" : "Serum Neutralization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14089"
        }
      ]
    },
    {
      "code" : "0011",
      "display" : "Titration",
      "definition" : "Titration",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14090"
        }
      ]
    },
    {
      "code" : "0012",
      "display" : "Ultrasound",
      "definition" : "Ultrasound",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14091"
        }
      ]
    },
    {
      "code" : "0013",
      "display" : "X-ray crystallography",
      "definition" : "X-ray crystallography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14092"
        }
      ]
    },
    {
      "code" : "0014",
      "display" : "Agglutination",
      "definition" : "Agglutination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14093"
        }
      ]
    },
    {
      "code" : "0015",
      "display" : "Buffered acidified plate agglutination",
      "definition" : "Agglutination, Buffered acidified plate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14094"
        }
      ]
    },
    {
      "code" : "0016",
      "display" : "Card agglutination",
      "definition" : "Agglutination, Card",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14095"
        }
      ]
    },
    {
      "code" : "0017",
      "display" : "Hemagglutination",
      "definition" : "Agglutination, Hemagglutination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14096"
        }
      ]
    },
    {
      "code" : "0018",
      "display" : "Hemagglutination inhibition",
      "definition" : "Agglutination, Hemagglutination inhibition",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14097"
        }
      ]
    },
    {
      "code" : "0019",
      "display" : "Latex agglutination",
      "definition" : "Agglutination, Latex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14098"
        }
      ]
    },
    {
      "code" : "0020",
      "display" : "Plate agglutination",
      "definition" : "Agglutination, Plate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14099"
        }
      ]
    },
    {
      "code" : "0021",
      "display" : "Rapid agglutination",
      "definition" : "Agglutination, Rapid Plate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14100"
        }
      ]
    },
    {
      "code" : "0022",
      "display" : "RBC agglutination",
      "definition" : "Agglutination, RBC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14101"
        }
      ]
    },
    {
      "code" : "0023",
      "display" : "Rivanol agglutination",
      "definition" : "Agglutination, Rivanol",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14102"
        }
      ]
    },
    {
      "code" : "0024",
      "display" : "Tube agglutination",
      "definition" : "Agglutination, Tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14103"
        }
      ]
    },
    {
      "code" : "0025",
      "display" : "Bioassay",
      "definition" : "Bioassay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14104"
        }
      ]
    },
    {
      "code" : "0026",
      "display" : "Animal Inoculation",
      "definition" : "Bioassay, Animal Inoculation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14105"
        }
      ]
    },
    {
      "code" : "0027",
      "display" : "Cytotoxicity",
      "definition" : "Bioassay, Cytotoxicity",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14106"
        }
      ]
    },
    {
      "code" : "0028",
      "display" : "Embryo infective dose 50",
      "definition" : "Bioassay, Embryo Infective Dose 50",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14107"
        }
      ]
    },
    {
      "code" : "0029",
      "display" : "Embryo lethal dose 50",
      "definition" : "Bioassay, Embryo Lethal Dose 50",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14108"
        }
      ]
    },
    {
      "code" : "0030",
      "display" : "Mouse intercerebral inoculation",
      "definition" : "Bioassay, Mouse intercerebral inoculation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14109"
        }
      ]
    },
    {
      "code" : "0031",
      "display" : "Bioassay, qualitative",
      "definition" : "Bioassay, qualitative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14110"
        }
      ]
    },
    {
      "code" : "0032",
      "display" : "Bioassay, quantitative",
      "definition" : "Bioassay, quantitative",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14111"
        }
      ]
    },
    {
      "code" : "0033",
      "display" : "Chemical method",
      "definition" : "Chemical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14112"
        }
      ]
    },
    {
      "code" : "0034",
      "display" : "Differential light absorption chemical test",
      "definition" : "Chemical, Differential light absorption",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14113"
        }
      ]
    },
    {
      "code" : "0035",
      "display" : "Dipstick",
      "definition" : "Chemical, Dipstick",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14114"
        }
      ]
    },
    {
      "code" : "0036",
      "display" : "Dipstick colorimetric laboratory test",
      "definition" : "Chemical, Dipstick colorimetric laboratory test",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14115"
        }
      ]
    },
    {
      "code" : "0037",
      "display" : "Test strip",
      "definition" : "Chemical, Test strip",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14116"
        }
      ]
    },
    {
      "code" : "0038",
      "display" : "Chromatography",
      "definition" : "Chromatography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14117"
        }
      ]
    },
    {
      "code" : "0039",
      "display" : "Affinity chromatography",
      "definition" : "Chromatography, Affinity",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14118"
        }
      ]
    },
    {
      "code" : "0040",
      "display" : "Gas liquid chromatography",
      "definition" : "Chromatography, Gas liquid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14119"
        }
      ]
    },
    {
      "code" : "0041",
      "display" : "High performance liquid chromatography",
      "definition" : "Chromatography, High performance liquid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14120"
        }
      ]
    },
    {
      "code" : "0042",
      "display" : "Liquid Chromatography",
      "definition" : "Chromatography, Liquid",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14121"
        }
      ]
    },
    {
      "code" : "0043",
      "display" : "Protein A affinity chromatography",
      "definition" : "Chromatography, Protein A affinity",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14122"
        }
      ]
    },
    {
      "code" : "0044",
      "display" : "Coagulation",
      "definition" : "Coagulation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14123"
        }
      ]
    },
    {
      "code" : "0045",
      "display" : "Tilt tube coagulation time",
      "definition" : "Coagulation, Tilt tube",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14124"
        }
      ]
    },
    {
      "code" : "0046",
      "display" : "Tilt tube reptilase induced coagulation",
      "definition" : "Coagulation, Tilt tube reptilase induced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14125"
        }
      ]
    },
    {
      "code" : "0047",
      "display" : "Automated count",
      "definition" : "Count, Automated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14126"
        }
      ]
    },
    {
      "code" : "0048",
      "display" : "Manual cell count",
      "definition" : "Count, Manual",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14127"
        }
      ]
    },
    {
      "code" : "0049",
      "display" : "Platelet count, Rees-Ecker",
      "definition" : "Count, Platelet, Rees-Ecker",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14128"
        }
      ]
    },
    {
      "code" : "0050",
      "display" : "Aerobic Culture",
      "definition" : "Culture, Aerobic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14129"
        }
      ]
    },
    {
      "code" : "0051",
      "display" : "Anaerobic Culture",
      "definition" : "Culture, Anaerobic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14130"
        }
      ]
    },
    {
      "code" : "0052",
      "display" : "Chicken embryo culture",
      "definition" : "Culture, Chicken Embryo",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14131"
        }
      ]
    },
    {
      "code" : "0053",
      "display" : "Delayed secondary enrichment",
      "definition" : "Culture, Delayed secondary enrichment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14132"
        }
      ]
    },
    {
      "code" : "0054",
      "display" : "Microaerophilic Culture",
      "definition" : "Culture, Microaerophilic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14133"
        }
      ]
    },
    {
      "code" : "0055",
      "display" : "Quantitative microbial culture, cup",
      "definition" : "Culture, Quantitative microbial, cup",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14134"
        }
      ]
    },
    {
      "code" : "0056",
      "display" : "Quantitative microbial culture, droplet",
      "definition" : "Culture, Quantitative microbial, droplet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14135"
        }
      ]
    },
    {
      "code" : "0057",
      "display" : "Quantitative microbial culture, filter paper",
      "definition" : "Culture, Quantitative microbial, filter paper",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14136"
        }
      ]
    },
    {
      "code" : "0058",
      "display" : "Quantitative microbial culture, pad culture",
      "definition" : "Culture, Quantitative microbial, pad",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14137"
        }
      ]
    },
    {
      "code" : "0059",
      "display" : "Quantitative microbial culture, pour plate",
      "definition" : "Culture, Quantitative microbial, pour plate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14138"
        }
      ]
    },
    {
      "code" : "0060",
      "display" : "Quantitative microbial culture, surface streak",
      "definition" : "Culture, Quantitative microbial, surface streak",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14139"
        }
      ]
    },
    {
      "code" : "0061",
      "display" : "Somatic Cell culture",
      "definition" : "Culture, Somatic Cell",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14140"
        }
      ]
    },
    {
      "code" : "0062",
      "display" : "Agar diffusion",
      "definition" : "Diffusion, Agar",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14141"
        }
      ]
    },
    {
      "code" : "0063",
      "display" : "Agar Gel Immunodiffusion",
      "definition" : "Diffusion, Agar Gel Immunodiffusion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14142"
        }
      ]
    },
    {
      "code" : "0064",
      "display" : "Electrophoresis",
      "definition" : "Electrophoresis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14143"
        }
      ]
    },
    {
      "code" : "0065",
      "display" : "Agaorse gel electrophoresis",
      "definition" : "Electrophoresis, Agaorse gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14144"
        }
      ]
    },
    {
      "code" : "0066",
      "display" : "Electrophoresis, citrate agar",
      "definition" : "Electrophoresis, citrate agar",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14145"
        }
      ]
    },
    {
      "code" : "0067",
      "display" : "Immunoelectrophoresis",
      "definition" : "Electrophoresis, Immuno",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14146"
        }
      ]
    },
    {
      "code" : "0068",
      "display" : "Polyacrylamide gel electrophoresis",
      "definition" : "Electrophoresis, Polyacrylamide gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14147"
        }
      ]
    },
    {
      "code" : "0069",
      "display" : "Starch gel electrophoresis",
      "definition" : "Electrophoresis, Starch gel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14148"
        }
      ]
    },
    {
      "code" : "0070",
      "display" : "ELISA",
      "definition" : "ELISA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14149"
        }
      ]
    },
    {
      "code" : "0071",
      "display" : "ELISA, antigen capture",
      "definition" : "ELISA, antigen capture",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14150"
        }
      ]
    },
    {
      "code" : "0072",
      "display" : "ELISA, avidin biotin peroxidase complex",
      "definition" : "ELISA, avidin biotin peroxidase complex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14151"
        }
      ]
    },
    {
      "code" : "0073",
      "display" : "Kinetic ELISA",
      "definition" : "ELISA, Kinetic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14152"
        }
      ]
    },
    {
      "code" : "0074",
      "display" : "ELISA, peroxidase-antiperoxidase",
      "definition" : "ELISA, peroxidase-antiperoxidase",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14153"
        }
      ]
    },
    {
      "code" : "0075",
      "display" : "API 20 Strep",
      "definition" : "Identification, API 20 Strep",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14154"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - streptococcis and enterococci"
        }
      ]
    },
    {
      "code" : "0076",
      "display" : "API 20A",
      "definition" : "Identification, API 20A",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14155"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - 24hr anaerobic ID"
        }
      ]
    },
    {
      "code" : "0077",
      "display" : "API 20C AUX",
      "definition" : "Identification, API 20C AUX",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14156"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - identification of yeast"
        }
      ]
    },
    {
      "code" : "0078",
      "display" : "API 20E",
      "definition" : "Identification, API 20E",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14157"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux -identification of Enterobacteriacae; non-fermenting GNB"
        }
      ]
    },
    {
      "code" : "0079",
      "display" : "API 20NE",
      "definition" : "Identification, API 20NE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14158"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - gram negative non-Enterobacteriaeciae"
        }
      ]
    },
    {
      "code" : "0080",
      "display" : "API 50 CH",
      "definition" : "Identification, API 50 CH",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14159"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0081",
      "display" : "API An-IDENT",
      "definition" : "Identification, API An-IDENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14160"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0082",
      "display" : "API Coryne",
      "definition" : "Identification, API Coryne",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14161"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0083",
      "display" : "API Rapid 20E",
      "definition" : "Identification, API Rapid 20E",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14162"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - 4 hour identification of Enterobacteriaciae"
        }
      ]
    },
    {
      "code" : "0084",
      "display" : "API Staph",
      "definition" : "Identification, API Staph",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14163"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0085",
      "display" : "API ZYM",
      "definition" : "Identification, API ZYM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14164"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0086",
      "display" : "Bacterial identification",
      "definition" : "Identification, Bacterial",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14165"
        }
      ]
    },
    {
      "code" : "0087",
      "display" : "mini VIDAS",
      "definition" : "Identification, mini VIDAS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14166"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0088",
      "display" : "Phage susceptibility typing",
      "definition" : "Identification, Phage susceptibility typing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14167"
        }
      ]
    },
    {
      "code" : "0089",
      "display" : "Quad-FERM+",
      "definition" : "Identification, Quad-FERM+",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14168"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux - 2-hour identification of Neisseria"
        }
      ]
    },
    {
      "code" : "0090",
      "display" : "RAPIDEC Staph",
      "definition" : "Identification, RAPIDEC Staph",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14169"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0091",
      "display" : "Staphaurex",
      "definition" : "Identification, Staphaurex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14170"
        }
      ]
    },
    {
      "code" : "0092",
      "display" : "VIDAS",
      "definition" : "Identification, VIDAS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14171"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0093",
      "display" : "Vitek",
      "definition" : "Identification, Vitek",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14172"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0094",
      "display" : "VITEK 2",
      "definition" : "Identification, VITEK 2",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14173"
        },
        {
          "code" : "howApplies",
          "valueString" : "bioMerieux"
        }
      ]
    },
    {
      "code" : "0095",
      "display" : "Immune stain",
      "definition" : "Immune stain",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14174"
        }
      ]
    },
    {
      "code" : "0096",
      "display" : "Immunofluorescent antibody, direct",
      "definition" : "Immune stain, Immunofluorescent antibody, direct",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14175"
        }
      ]
    },
    {
      "code" : "0097",
      "display" : "Immunofluorescent antibody, indirect",
      "definition" : "Immune stain, Immunofluorescent antibody, indirect",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14176"
        }
      ]
    },
    {
      "code" : "0098",
      "display" : "Immunoperoxidase, Avidin-Biotin Complex",
      "definition" : "Immune stain, Immunoperoxidase, Avidin-Biotin Complex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14177"
        }
      ]
    },
    {
      "code" : "0099",
      "display" : "Immunoperoxidase, Peroxidase anti-peroxidase complex",
      "definition" : "Immune stain, Immunoperoxidase, Peroxidase anti-peroxidase complex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14178"
        }
      ]
    },
    {
      "code" : "0100",
      "display" : "Immunoperoxidase, Protein A-peroxidase complex",
      "definition" : "Immune stain, Immunoperoxidase, Protein A-peroxidase complex",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14179"
        }
      ]
    },
    {
      "code" : "0101",
      "display" : "Immunoassay",
      "definition" : "Immunoassay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14180"
        }
      ]
    },
    {
      "code" : "0102",
      "display" : "Immunoassay, qualitative, multiple step",
      "definition" : "Immunoassay, qualitative, multiple step",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14181"
        }
      ]
    },
    {
      "code" : "0103",
      "display" : "Immunoassay, qualitative, single step",
      "definition" : "Immunoassay, qualitative, single step",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14182"
        }
      ]
    },
    {
      "code" : "0104",
      "display" : "Radioimmunoassay",
      "definition" : "Immunoassay, Radioimmunoassay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14183"
        }
      ]
    },
    {
      "code" : "0105",
      "display" : "Immunoassay, semi-quantitative, multiple step",
      "definition" : "Immunoassay, semi-quantitative, multiple step",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14184"
        }
      ]
    },
    {
      "code" : "0106",
      "display" : "Immunoassay, semi-quantitative, single step",
      "definition" : "Immunoassay, semi-quantitative, single step",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14185"
        }
      ]
    },
    {
      "code" : "0107",
      "display" : "Microscopy",
      "definition" : "Microscopy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14186"
        }
      ]
    },
    {
      "code" : "0108",
      "display" : "Darkfield microscopy",
      "definition" : "Microscopy, Darkfield",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14187"
        }
      ]
    },
    {
      "code" : "0109",
      "display" : "Electron microscopy",
      "definition" : "Microscopy, Electron",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14188"
        }
      ]
    },
    {
      "code" : "0110",
      "display" : "Electron microscopy tomography",
      "definition" : "Microscopy, Electron microscopy tomography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14189"
        }
      ]
    },
    {
      "code" : "0111",
      "display" : "Electron microscopy, negative stain",
      "definition" : "Microscopy, Electron, negative stain",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14190"
        }
      ]
    },
    {
      "code" : "0112",
      "display" : "Electron microscopy, thick section",
      "definition" : "Microscopy, Electron, thick section transmission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14191"
        }
      ]
    },
    {
      "code" : "0113",
      "display" : "Electron microscopy, thin section",
      "definition" : "Microscopy, Electron, thin section transmission",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14192"
        }
      ]
    },
    {
      "code" : "0114",
      "display" : "Microscopy, Light",
      "definition" : "Microscopy, Light",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14193"
        }
      ]
    },
    {
      "code" : "0115",
      "display" : "Polarizing light microscopy",
      "definition" : "Microscopy, Polarized light",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14194"
        }
      ]
    },
    {
      "code" : "0116",
      "display" : "Scanning electron microscopy",
      "definition" : "Microscopy, Scanning electron",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14195"
        }
      ]
    },
    {
      "code" : "0117",
      "display" : "Transmission electron microscopy",
      "definition" : "Microscopy, Transmission electron",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14196"
        }
      ]
    },
    {
      "code" : "0118",
      "display" : "Transparent tape direct examination",
      "definition" : "Microscopy, Transparent tape direct examination",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14197"
        }
      ]
    },
    {
      "code" : "0119",
      "display" : "3 Self-Sustaining Sequence Replication",
      "definition" : "Molecular, 3 Self-Sustaining Sequence Replication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14198"
        }
      ]
    },
    {
      "code" : "0120",
      "display" : "Branched Chain DNA",
      "definition" : "Molecular, Branched Chain DNA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14199"
        }
      ]
    },
    {
      "code" : "0121",
      "display" : "Hybridization Protection Assay",
      "definition" : "Molecular, Hybridization Protection Assay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14200"
        }
      ]
    },
    {
      "code" : "0122",
      "display" : "Immune blot",
      "definition" : "Molecular, Immune blot",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14201"
        }
      ]
    },
    {
      "code" : "0123",
      "display" : "In-situ hybridization",
      "definition" : "Molecular, In-situ hybridization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14202"
        }
      ]
    },
    {
      "code" : "0124",
      "display" : "Ligase Chain Reaction",
      "definition" : "Molecular, Ligase Chain Reaction",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14203"
        }
      ]
    },
    {
      "code" : "0125",
      "display" : "Ligation Activated Transcription",
      "definition" : "Molecular, Ligation Activated Transcription",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14204"
        }
      ]
    },
    {
      "code" : "0126",
      "display" : "Nucleic Acid Probe",
      "definition" : "Molecular, Nucleic Acid Probe",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14205"
        }
      ]
    },
    {
      "code" : "0128",
      "display" : "Nucleic acid probe with amplification",
      "definition" : "Molecular, Nucleic acid probe with amplification\r\n\r\n*Rationale:* Duplicate of code 0126. Use code 0126 instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14207"
        }
      ]
    },
    {
      "code" : "0129",
      "display" : "Nucleic acid probe with target amplification",
      "definition" : "Molecular, Nucleic acid probe with target amplification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14208"
        }
      ]
    },
    {
      "code" : "0130",
      "display" : "Nucleic acid reverse transcription",
      "definition" : "Molecular, Nucleic acid reverse transcription",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14209"
        }
      ]
    },
    {
      "code" : "0131",
      "display" : "Nucleic Acid Sequence Based Analysis",
      "definition" : "Molecular, Nucleic Acid Sequence Based Analysis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14210"
        }
      ]
    },
    {
      "code" : "0132",
      "display" : "Polymerase chain reaction",
      "definition" : "Molecular, Polymerase chain reaction",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14211"
        }
      ]
    },
    {
      "code" : "0133",
      "display" : "Q-Beta Replicase or probe amplification category method",
      "definition" : "Molecular, Q-Beta Replicase or probe amplification category method",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14212"
        }
      ]
    },
    {
      "code" : "0134",
      "display" : "Restriction Fragment Length Polymorphism",
      "definition" : "Molecular, Restriction Fragment Length Polymorphism",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14213"
        }
      ]
    },
    {
      "code" : "0135",
      "display" : "Southern Blot",
      "definition" : "Molecular, Southern Blot",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14214"
        }
      ]
    },
    {
      "code" : "0136",
      "display" : "Strand Displacement Amplification",
      "definition" : "Molecular, Strand Displacement Amplification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14215"
        }
      ]
    },
    {
      "code" : "0137",
      "display" : "Transcription Mediated Amplification",
      "definition" : "Molecular, Transcription Mediated Amplification",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14216"
        }
      ]
    },
    {
      "code" : "0138",
      "display" : "Western Blot",
      "definition" : "Molecular, Western Blot",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14217"
        }
      ]
    },
    {
      "code" : "0139",
      "display" : "Flocculation",
      "definition" : "Precipitation, Flocculation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14218"
        }
      ]
    },
    {
      "code" : "0140",
      "display" : "Immune precipitation",
      "definition" : "Precipitation, Immune precipitation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14219"
        }
      ]
    },
    {
      "code" : "0141",
      "display" : "Milk ring test",
      "definition" : "Precipitation, Milk ring test",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14220"
        }
      ]
    },
    {
      "code" : "0142",
      "display" : "Precipitin",
      "definition" : "Precipitation, Precipitin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14221"
        }
      ]
    },
    {
      "code" : "0143",
      "display" : "Acid fast stain",
      "definition" : "Stain, Acid fast",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14222"
        }
      ]
    },
    {
      "code" : "0144",
      "display" : "Acid fast stain, fluorochrome",
      "definition" : "Stain, Acid fast, fluorochrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14223"
        }
      ]
    },
    {
      "code" : "0145",
      "display" : "Acid fast stain, Kinyoun's cold carbolfuchsin",
      "definition" : "Stain, Acid fast, Kinyoun's cold carbolfuchsin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14224"
        }
      ]
    },
    {
      "code" : "0146",
      "display" : "Acid fast stain, Ziehl-Neelsen",
      "definition" : "Stain, Acid fast, Ziehl-Neelsen",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14225"
        }
      ]
    },
    {
      "code" : "0147",
      "display" : "Acid phosphatase stain",
      "definition" : "Stain, Acid phosphatase",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14226"
        }
      ]
    },
    {
      "code" : "0148",
      "display" : "Acridine orange stain",
      "definition" : "Stain, Acridine orange",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14227"
        }
      ]
    },
    {
      "code" : "0149",
      "display" : "Active brilliant orange KH stain",
      "definition" : "Stain, Active brilliant orange KH",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14228"
        }
      ]
    },
    {
      "code" : "0150",
      "display" : "Alazarin red S stain",
      "definition" : "Stain, Alazarin red S",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14229"
        }
      ]
    },
    {
      "code" : "0151",
      "display" : "Alcian blue stain",
      "definition" : "Stain, Alcian blue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14230"
        }
      ]
    },
    {
      "code" : "0152",
      "display" : "Alcian blue with Periodic acid Schiff stain",
      "definition" : "Stain, Alcian blue with Periodic acid Schiff",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14231"
        }
      ]
    },
    {
      "code" : "0153",
      "display" : "Argentaffin stain",
      "definition" : "Stain, Argentaffin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14232"
        }
      ]
    },
    {
      "code" : "0154",
      "display" : "Argentaffin silver stain",
      "definition" : "Stain, Argentaffin silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14233"
        }
      ]
    },
    {
      "code" : "0155",
      "display" : "Azure-eosin stain",
      "definition" : "Stain, Azure-eosin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14234"
        }
      ]
    },
    {
      "code" : "0156",
      "display" : "Basic Fuschin stain",
      "definition" : "Stain, Basic Fuschin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14235"
        }
      ]
    },
    {
      "code" : "0157",
      "display" : "Bennhold stain",
      "definition" : "Stain, Bennhold",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14236"
        }
      ]
    },
    {
      "code" : "0158",
      "display" : "Bennhold's Congo red stain",
      "definition" : "Stain, Bennhold's Congo red",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14237"
        }
      ]
    },
    {
      "code" : "0159",
      "display" : "Bielschowsky stain",
      "definition" : "Stain, Bielschowsky",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14238"
        }
      ]
    },
    {
      "code" : "0160",
      "display" : "Bielschowsky's silver stain",
      "definition" : "Stain, Bielschowsky's silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14239"
        }
      ]
    },
    {
      "code" : "0161",
      "display" : "Bleach stain",
      "definition" : "Stain, Bleach",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14240"
        }
      ]
    },
    {
      "code" : "0162",
      "display" : "Bodian stain",
      "definition" : "Stain, Bodian",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14241"
        }
      ]
    },
    {
      "code" : "0163",
      "display" : "Brown-Brenn stain",
      "definition" : "Stain, Brown-Brenn",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14242"
        }
      ]
    },
    {
      "code" : "0164",
      "display" : "Butyrate-esterase stain",
      "definition" : "Stain, Butyrate-esterase",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14243"
        }
      ]
    },
    {
      "code" : "0165",
      "display" : "Calcofluor white fluorescent stain",
      "definition" : "Stain, Calcofluor white fluorescent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14244"
        }
      ]
    },
    {
      "code" : "0166",
      "display" : "Carbol-fuchsin stain",
      "definition" : "Stain, Carbol-fuchsin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14245"
        }
      ]
    },
    {
      "code" : "0167",
      "display" : "Carmine stain",
      "definition" : "Stain, Carmine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14246"
        }
      ]
    },
    {
      "code" : "0168",
      "display" : "Churukian-Schenk stain",
      "definition" : "Stain, Churukian-Schenk",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14247"
        }
      ]
    },
    {
      "code" : "0169",
      "display" : "Congo red stain",
      "definition" : "Stain, Congo red",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14248"
        }
      ]
    },
    {
      "code" : "0170",
      "display" : "Cresyl echt violet stain",
      "definition" : "Stain, Cresyl echt violet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14249"
        }
      ]
    },
    {
      "code" : "0171",
      "display" : "Crystal violet stain",
      "definition" : "Stain, Crystal violet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14250"
        }
      ]
    },
    {
      "code" : "0172",
      "display" : "De Galantha stain",
      "definition" : "Stain, De Galantha",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14251"
        }
      ]
    },
    {
      "code" : "0173",
      "display" : "Dieterle silver impregnation stain",
      "definition" : "Stain, Dieterle silver impregnation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14252"
        }
      ]
    },
    {
      "code" : "0174",
      "display" : "Fite-Farco stain",
      "definition" : "Stain, Fite-Farco",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14253"
        }
      ]
    },
    {
      "code" : "0175",
      "display" : "Fontana-Masson silver stain",
      "definition" : "Stain, Fontana-Masson silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14254"
        }
      ]
    },
    {
      "code" : "0176",
      "display" : "Fouchet stain",
      "definition" : "Stain, Fouchet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14255"
        }
      ]
    },
    {
      "code" : "0177",
      "display" : "Gomori stain",
      "definition" : "Stain, Gomori",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14256"
        }
      ]
    },
    {
      "code" : "0178",
      "display" : "Gomori methenamine silver stain",
      "definition" : "Stain, Gomori methenamine silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14257"
        }
      ]
    },
    {
      "code" : "0179",
      "display" : "Gomori-Wheatly trichrome stain",
      "definition" : "Stain, Gomori-Wheatly trichrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14258"
        }
      ]
    },
    {
      "code" : "0180",
      "display" : "Gridley stain",
      "definition" : "Stain, Gridley",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14259"
        }
      ]
    },
    {
      "code" : "0181",
      "display" : "Grimelius silver stain",
      "definition" : "Stain, Grimelius silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14260"
        }
      ]
    },
    {
      "code" : "0182",
      "display" : "Grocott stain",
      "definition" : "Stain, Grocott",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14261"
        }
      ]
    },
    {
      "code" : "0183",
      "display" : "Grocott methenamine silver stain",
      "definition" : "Stain, Grocott methenamine silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14262"
        }
      ]
    },
    {
      "code" : "0184",
      "display" : "Hale's colloidal ferric oxide stain",
      "definition" : "Stain, Hale's colloidal ferric oxide",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14263"
        }
      ]
    },
    {
      "code" : "0185",
      "display" : "Hale's colloidal iron stain",
      "definition" : "Stain, Hale's colloidal iron",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14264"
        }
      ]
    },
    {
      "code" : "0186",
      "display" : "Hansel stain",
      "definition" : "Stain, Hansel",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14265"
        }
      ]
    },
    {
      "code" : "0187",
      "display" : "Harris regressive hematoxylin and eosin stain",
      "definition" : "Stain, Harris regressive hematoxylin and eosin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14266"
        }
      ]
    },
    {
      "code" : "0188",
      "display" : "Hematoxylin and eosin stain",
      "definition" : "Stain, Hematoxylin and eosin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14267"
        }
      ]
    },
    {
      "code" : "0189",
      "display" : "Highman stain",
      "definition" : "Stain, Highman",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14268"
        }
      ]
    },
    {
      "code" : "0190",
      "display" : "Holzer stain",
      "definition" : "Stain, Holzer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14269"
        }
      ]
    },
    {
      "code" : "0191",
      "display" : "Iron hematoxylin stain",
      "definition" : "Stain, Iron hematoxylin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14270"
        }
      ]
    },
    {
      "code" : "0192",
      "display" : "Jones stain",
      "definition" : "Stain, Jones",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14271"
        }
      ]
    },
    {
      "code" : "0193",
      "display" : "Jones methenamine silver stain",
      "definition" : "Stain, Jones methenamine silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14272"
        }
      ]
    },
    {
      "code" : "0194",
      "display" : "Kossa stain",
      "definition" : "Stain, Kossa",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14273"
        }
      ]
    },
    {
      "code" : "0195",
      "display" : "Lawson-Van Gieson stain",
      "definition" : "Stain, Lawson-Van Gieson",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14274"
        }
      ]
    },
    {
      "code" : "0196",
      "display" : "Loeffler methylene blue stain",
      "definition" : "Stain, Loeffler methylene blue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14275"
        }
      ]
    },
    {
      "code" : "0197",
      "display" : "Luxol fast blue with cresyl violet stain",
      "definition" : "Stain, Luxol fast blue with cresyl violet",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14276"
        }
      ]
    },
    {
      "code" : "0198",
      "display" : "Luxol fast blue with Periodic acid-Schiff stain",
      "definition" : "Stain, Luxol fast blue with Periodic acid-Schiff",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14277"
        }
      ]
    },
    {
      "code" : "0199",
      "display" : "MacNeal's tetrachrome blood stain",
      "definition" : "Stain, MacNeal's tetrachrome blood",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14278"
        }
      ]
    },
    {
      "code" : "0200",
      "display" : "Mallory-Heidenhain stain",
      "definition" : "Stain, Mallory-Heidenhain",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14279"
        }
      ]
    },
    {
      "code" : "0201",
      "display" : "Masson trichrome stain",
      "definition" : "Stain, Masson trichrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14280"
        }
      ]
    },
    {
      "code" : "0202",
      "display" : "Mayer mucicarmine stain",
      "definition" : "Stain, Mayer mucicarmine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14281"
        }
      ]
    },
    {
      "code" : "0203",
      "display" : "Mayers progressive hematoxylin and eosin stain",
      "definition" : "Stain, Mayers progressive hematoxylin and eosin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14282"
        }
      ]
    },
    {
      "code" : "0204",
      "display" : "May-Grunwald Giemsa stain",
      "definition" : "Stain, May-Grunwald Giemsa",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14283"
        }
      ]
    },
    {
      "code" : "0205",
      "display" : "Methyl green stain",
      "definition" : "Stain, Methyl green",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14284"
        }
      ]
    },
    {
      "code" : "0206",
      "display" : "Methyl green pyronin stain",
      "definition" : "Stain, Methyl green pyronin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14285"
        }
      ]
    },
    {
      "code" : "0207",
      "display" : "Modified Gomori-Wheatly trichrome stain",
      "definition" : "Stain, Modified Gomori-Wheatly trichrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14286"
        }
      ]
    },
    {
      "code" : "0208",
      "display" : "Modified Masson trichrome stain",
      "definition" : "Stain, Modified Masson trichrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14287"
        }
      ]
    },
    {
      "code" : "0209",
      "display" : "Modified trichrome stain",
      "definition" : "Stain, Modified trichrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14288"
        }
      ]
    },
    {
      "code" : "0210",
      "display" : "Movat pentachrome stain",
      "definition" : "Stain, Movat pentachrome",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14289"
        }
      ]
    },
    {
      "code" : "0211",
      "display" : "Mucicarmine stain",
      "definition" : "Stain, Mucicarmine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14290"
        }
      ]
    },
    {
      "code" : "0212",
      "display" : "Neutral red stain",
      "definition" : "Stain, Neutral red",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14291"
        }
      ]
    },
    {
      "code" : "0213",
      "display" : "Night blue stain",
      "definition" : "Stain, Night blue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14292"
        }
      ]
    },
    {
      "code" : "0214",
      "display" : "Non-specific esterase stain",
      "definition" : "Stain, Non-specific esterase",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14293"
        }
      ]
    },
    {
      "code" : "0215",
      "display" : "Oil red-O stain",
      "definition" : "Stain, Oil red-O",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14294"
        }
      ]
    },
    {
      "code" : "0216",
      "display" : "Orcein stain",
      "definition" : "Stain, Orcein",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14295"
        }
      ]
    },
    {
      "code" : "0217",
      "display" : "Perls' stain",
      "definition" : "Stain, Perls'",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14296"
        }
      ]
    },
    {
      "code" : "0218",
      "display" : "Phosphotungstic acid-hematoxylin stain",
      "definition" : "Stain, Phosphotungstic acid-hematoxylin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14297"
        }
      ]
    },
    {
      "code" : "0219",
      "display" : "Potassium ferrocyanide stain",
      "definition" : "Stain, Potassium ferrocyanide",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14298"
        }
      ]
    },
    {
      "code" : "0220",
      "display" : "Prussian blue stain",
      "definition" : "Stain, Prussian blue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14299"
        }
      ]
    },
    {
      "code" : "0221",
      "display" : "Putchler modified Bennhold stain",
      "definition" : "Stain, Putchler modified Bennhold",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14300"
        }
      ]
    },
    {
      "code" : "0222",
      "display" : "Quinacrine fluorescent stain",
      "definition" : "Stain, Quinacrine fluorescent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14301"
        }
      ]
    },
    {
      "code" : "0223",
      "display" : "Reticulin stain",
      "definition" : "Stain, Reticulin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14302"
        }
      ]
    },
    {
      "code" : "0224",
      "display" : "Rhodamine stain",
      "definition" : "Stain, Rhodamine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14303"
        }
      ]
    },
    {
      "code" : "0225",
      "display" : "Safranin stain",
      "definition" : "Stain, Safranin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14304"
        }
      ]
    },
    {
      "code" : "0226",
      "display" : "Schmorl stain",
      "definition" : "Stain, Schmorl",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14305"
        }
      ]
    },
    {
      "code" : "0227",
      "display" : "Seiver-Munger stain",
      "definition" : "Stain, Seiver-Munger",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14306"
        }
      ]
    },
    {
      "code" : "0228",
      "display" : "Silver stain",
      "definition" : "Stain, Silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14307"
        }
      ]
    },
    {
      "code" : "0229",
      "display" : "Specific esterase stain",
      "definition" : "Stain, Specific esterase",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14308"
        }
      ]
    },
    {
      "code" : "0230",
      "display" : "Steiner silver stain",
      "definition" : "Stain, Steiner silver",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14309"
        }
      ]
    },
    {
      "code" : "0231",
      "display" : "Sudan III stain",
      "definition" : "Stain, Sudan III",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14310"
        }
      ]
    },
    {
      "code" : "0232",
      "display" : "Sudan IVI stain",
      "definition" : "Stain, Sudan IVI",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14311"
        }
      ]
    },
    {
      "code" : "0233",
      "display" : "Sulfated alcian blue stain",
      "definition" : "Stain, Sulfated alcian blue",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14312"
        }
      ]
    },
    {
      "code" : "0234",
      "display" : "Supravital stain",
      "definition" : "Stain, Supravital",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14313"
        }
      ]
    },
    {
      "code" : "0235",
      "display" : "Thioflavine-S stain",
      "definition" : "Stain, Thioflavine-S",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14314"
        }
      ]
    },
    {
      "code" : "0236",
      "display" : "Three micron Giemsa stain",
      "definition" : "Stain, Three micron Giemsa",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14315"
        }
      ]
    },
    {
      "code" : "0237",
      "display" : "Vassar-Culling stain",
      "definition" : "Stain, Vassar-Culling",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14316"
        }
      ]
    },
    {
      "code" : "0238",
      "display" : "Vital Stain",
      "definition" : "Stain, Vital",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14317"
        }
      ]
    },
    {
      "code" : "0239",
      "display" : "von Kossa stain",
      "definition" : "Stain, von Kossa",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14318"
        }
      ]
    },
    {
      "code" : "0243",
      "display" : "Minimum bactericidal concentration test, macrodilution",
      "definition" : "Susceptibility, Minimum bactericidal concentration, macrodilution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14322"
        }
      ]
    },
    {
      "code" : "0244",
      "display" : "Minimum bactericidal concentration test, microdilution",
      "definition" : "Susceptibility, Minimum bactericidal concentration, microdilution",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14323"
        }
      ]
    },
    {
      "code" : "0247",
      "display" : "Turbidometric",
      "definition" : "Turbidometric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14326"
        }
      ]
    },
    {
      "code" : "0248",
      "display" : "Refractometric",
      "definition" : "Turbidometric, Refractometric",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14327"
        }
      ]
    },
    {
      "code" : "0249",
      "display" : "Thin layer chromatography (TLC)",
      "definition" : "Chromatography, Thin Layer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14328"
        }
      ]
    },
    {
      "code" : "0250",
      "display" : "EMIT",
      "definition" : "Immunoassay, enzyme-multiplied technique (EMIT)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14329"
        }
      ]
    },
    {
      "code" : "0251",
      "display" : "Flow cytometry (FC)",
      "definition" : "Flow Cytometry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14330"
        }
      ]
    },
    {
      "code" : "0252",
      "display" : "Radial immunodiffusion (RID)",
      "definition" : "Radial Immunodiffusion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14331"
        }
      ]
    },
    {
      "code" : "0253",
      "display" : "Fluorescence polarization immunoassay (FPIA)",
      "definition" : "Immunoassay, Fluorescence Polarization",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14332"
        }
      ]
    },
    {
      "code" : "0254",
      "display" : "Immunofixation electrophoresis (IFE)",
      "definition" : "Electrophoresis, Immunofixation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14333"
        }
      ]
    },
    {
      "code" : "0255",
      "display" : "Equilibrium dialysis",
      "definition" : "Dialysis, Direct Equilibrium",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14334"
        }
      ]
    },
    {
      "code" : "0256",
      "display" : "Kleihauer-Betke acid elution",
      "definition" : "Acid Elution, Kleihauer-Betke Method",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14335"
        }
      ]
    },
    {
      "code" : "0257",
      "display" : "Anti-complement immunofluorescence (ACIF)",
      "definition" : "Immunofluorescence, Anti-Complement",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14336"
        }
      ]
    },
    {
      "code" : "0258",
      "display" : "GC/MS",
      "definition" : "Gas Chromatography/Mass Spectroscopy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14337"
        }
      ]
    },
    {
      "code" : "0259",
      "display" : "Nephelometry",
      "definition" : "Light Scatter, Nephelometry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14338"
        }
      ]
    },
    {
      "code" : "0260",
      "display" : "IgE immunoassay antibody",
      "definition" : "Immunoassay, IgE Antibody Test",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14339"
        }
      ]
    },
    {
      "code" : "0261",
      "display" : "Lymphocyte Microcytotoxicity Assay",
      "definition" : "Lymphocyte Microcytotoxicity Assay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14340"
        }
      ]
    },
    {
      "code" : "0262",
      "display" : "Spectrophotometry",
      "definition" : "Spectrophotometry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14341"
        }
      ]
    },
    {
      "code" : "0263",
      "display" : "Atomic absorption spectrophotometry (AAS)",
      "definition" : "Spectrophotometry, Atomic Absorption",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14342"
        }
      ]
    },
    {
      "code" : "0264",
      "display" : "Ion selective electrode (ISE)",
      "definition" : "Electrochemical, Ion Selective Electrode",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14343"
        }
      ]
    },
    {
      "code" : "0265",
      "display" : "Gas chromatography (GC)",
      "definition" : "Chromatography, Gas",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14344"
        }
      ]
    },
    {
      "code" : "0266",
      "display" : "Isoelectric focusing (IEF)",
      "definition" : "Isoelectric Focusing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14345"
        }
      ]
    },
    {
      "code" : "0267",
      "display" : "Immunochemiluminescence",
      "definition" : "Immunoassay, Chemiluminescent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14346"
        }
      ]
    },
    {
      "code" : "0268",
      "display" : "Microparticle enzyme immunoassay (MEIA)",
      "definition" : "Immunoassay, Microparticle Enzyme",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14347"
        }
      ]
    },
    {
      "code" : "0269",
      "display" : "ICP/MS",
      "definition" : "Inductively-Coupled Plasma/Mass Spectrometry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14348"
        }
      ]
    },
    {
      "code" : "0270",
      "display" : "Immunoradiometric assay (IRMA)",
      "definition" : "Immunoassay, Immunoradiometric Assay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14349"
        }
      ]
    },
    {
      "code" : "0271",
      "display" : "Photo optical clot detection",
      "definition" : "Coagulation, Photo Optical Clot Detection",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14350"
        }
      ]
    },
    {
      "code" : "0280",
      "display" : "Susceptibility Testing",
      "definition" : "Test methods designed to determine a microorganismaTMs susceptibility to being killed by an antibiotic.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21454"
        }
      ],
      "concept" : [
        {
          "code" : "0240",
          "display" : "Antibiotic sensitivity, disk",
          "definition" : "Susceptibility, Antibiotic sensitivity, disk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14319"
            }
          ]
        },
        {
          "code" : "0241",
          "display" : "BACTEC susceptibility test",
          "definition" : "Susceptibility, BACTEC susceptibility test",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14320"
            }
          ]
        },
        {
          "code" : "0242",
          "display" : "Disk dilution",
          "definition" : "Susceptibility, Disk dilution",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "14321"
            }
          ]
        },
        {
          "code" : "0272",
          "display" : "Minimum Inhibitory Concentration",
          "definition" : "Testing to measure the minimum concentration of the antibacterial agent in a given culture medium below which bacterial growth is not inhibited.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21445"
            }
          ],
          "concept" : [
            {
              "code" : "0245",
              "display" : "Minimum Inhibitory Concentration, macrodilution",
              "definition" : "Susceptibility, Minimum Inhibitory concentration, macrodilution",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14324"
                }
              ]
            },
            {
              "code" : "0246",
              "display" : "Minimum Inhibitory Concentration, microdilution",
              "definition" : "Susceptibility, Minimum Inhibitory concentration, microdilution",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "14325"
                }
              ]
            }
          ]
        },
        {
          "code" : "0273",
          "display" : "Viral Genotype Susceptibility",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21446"
            }
          ]
        },
        {
          "code" : "0274",
          "display" : "Viral Phenotype Susceptibility",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21447"
            }
          ]
        },
        {
          "code" : "0275",
          "display" : "Gradient Strip",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21448"
            }
          ]
        },
        {
          "code" : "0275a",
          "display" : "Minimum Lethal Concentration (MLC)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21449"
            }
          ]
        },
        {
          "code" : "0276",
          "display" : "Slow Mycobacteria Susceptibility",
          "definition" : "Testing to measure the minimum concentration of the antibacterial agent in a given culture medium below which bacterial growth is not inhibited.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21450"
            }
          ]
        },
        {
          "code" : "0277",
          "display" : "Serum bactericidal titer",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21451"
            }
          ]
        },
        {
          "code" : "0278",
          "display" : "Agar screen",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21452"
            }
          ]
        },
        {
          "code" : "0279",
          "display" : "Disk induction",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21453"
            }
          ]
        }
      ]
    },
    {
      "code" : "_AllergyTestObservationMethod",
      "display" : "allergy test observation",
      "definition" : "**Description:**Provides additional methodology information not present in the associated AllergyTestCode term.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21943"
        }
      ]
    },
    {
      "code" : "_CommonClinicalObservationMethod",
      "display" : "common clinical observation",
      "definition" : "**Description:**Used in a patient care message to value simple clinical (non-lab) observation methods, such as found in SOAP (subjective, objective, assessment, plan) progress notes: subjective section (used for history from patient and other informants); objective section (used for physical exam, lab, and other common results), and assessment section (used for the clinicians assessment of the implications of subjective and objective sections).",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21944"
        }
      ]
    },
    {
      "code" : "0127",
      "display" : "Nucleic acid probe",
      "definition" : "Molecular, Nucleic acid probe",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "14206"
        }
      ]
    }
  ]
}

```
