# HL7UpdateMode - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7UpdateMode**

## CodeSystem: HL7UpdateMode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HL7UpdateMode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:HL7UpdateMode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.57 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The possible modes of updating that occur when an attribute is received by a system that already contains values for that attribute. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HL7UpdateMode](ValueSet-v3-HL7UpdateMode.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HL7UpdateMode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HL7UpdateMode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.57"
    }
  ],
  "version" : "3.0.0",
  "name" : "HL7UpdateMode",
  "title" : "HL7UpdateMode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The possible modes of updating that occur when an attribute is received by a system that already contains values for that attribute.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Add",
      "definition" : "**Description:**The item was (or is to be) added, having not been present immediately before. (If it is already present, this may be treated as an error condition.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22624"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Add or Replace",
      "definition" : "**Description:**The item was (or is to be) either added or replaced.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22654"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Remove",
      "definition" : "**Description:**The item was (or is to be) removed (sometimes referred to as deleted). If the item is part of a collection, delete any matching items.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10020"
        }
      ]
    },
    {
      "code" : "K",
      "display" : "Key",
      "definition" : "**Description:**This item is part of the identifying information for this object.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10022"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "No Change",
      "definition" : "**Description:**There was (or is to be) no change to the item. This is primarily used when this element has not changed, but other attributes in the instance have changed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22655"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Replace",
      "definition" : "**Description:**The item existed previously and has (or is to be) revised. (If an item does not already exist, this may be treated as an error condition.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10019"
        }
      ]
    },
    {
      "code" : "REF",
      "display" : "Reference",
      "definition" : "**Description:**This item provides enough information to allow a processing system to locate the full applicable record by identifying the object.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22623"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "**Description:**Description:</b>It is not specified whether or what kind of change has occurred to the item, or whether the item is present as a reference or identifying property.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22622"
        }
      ]
    },
    {
      "code" : "_SetUpdateMode",
      "display" : "SetUpdateMode",
      "definition" : "These concepts apply when the element and/or message is updating a set of items.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21082"
        }
      ],
      "concept" : [
        {
          "code" : "ESA",
          "display" : "Set Add",
          "definition" : "Add the message element to the collection of items on the receiving system that correspond to the message element.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10025"
            }
          ]
        },
        {
          "code" : "ESAC",
          "display" : "Set Add or Change",
          "definition" : "Change the item on the receiving system that corresponds to this message element; if a matching element does not exist, add a new one created with the values in the message.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10028"
            }
          ]
        },
        {
          "code" : "ESC",
          "display" : "Set Change",
          "definition" : "Change the item on the receiving system that corresponds to this message element; do not process if a matching element does not exist.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10027"
            }
          ]
        },
        {
          "code" : "ESD",
          "display" : "Set Delete",
          "definition" : "Delete the item on the receiving system that corresponds to this message element.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "internalId",
              "valueCode" : "10026"
            }
          ]
        }
      ]
    },
    {
      "code" : "AU",
      "display" : "Add or Update",
      "definition" : "**Description:** AU: If this item exists, update it with these values. If it does not exist, create it with these values. If the item is part of the collection, update each item that matches this item, and if no items match, add a new item to the collection.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22621"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Ignore",
      "definition" : "Ignore this role, it is not relevant to the update.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10021"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Verify",
      "definition" : "Verify - this message element must match a value already in the receiving systems database in order to process the message.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10023"
        }
      ]
    }
  ]
}

```
