# HL7ConformanceInclusion - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HL7ConformanceInclusion**

## CodeSystem: HL7ConformanceInclusion 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HL7ConformanceInclusion | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:HL7ConformanceInclusion |
| *Other Identifiers:*OID:2.16.840.1.113883.5.55 | | |

 
These concepts represent theconformance requirments defined for including or valuing an element of an HL7 message. The concepts apply equally to conformance profiles defined for Version 2.x messgaes as defined by the Conformance SIG, and to the conformance columns for Version 3 messages as specified in the HMD. 
**Deprecation Comment:**Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HL7ConformanceInclusion",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HL7ConformanceInclusion",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.55"
    }
  ],
  "version" : "2.0.1",
  "name" : "HL7ConformanceInclusion",
  "title" : "HL7ConformanceInclusion",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "These concepts represent theconformance requirments defined for including or valuing an element of an HL7 message. The concepts apply equally to conformance profiles defined for Version 2.x messgaes as defined by the Conformance SIG, and to the conformance columns for Version 3 messages as specified in the HMD.\r\n\r\n**Deprecation Comment:** Deprecated as per 11/2008 Harmonization cleanup; internal and obsolete HL7 usage, no longer used.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_InclusionNotMandatory",
      "display" : "InclusionNotMandatory",
      "definition" : "The message element is not mandatory, but its appearance may be constrained by one of the non-mandatory concepts.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21081"
        }
      ],
      "concept" : [
        {
          "code" : "NP",
          "display" : "Not permitted",
          "definition" : "This message element may not appear when the message is communicated.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10014"
            }
          ]
        },
        {
          "code" : "NR",
          "display" : "Not required",
          "definition" : "The message element may be populated or used by one system sponsor (or profile), but not by another. Each system sponsor or profile is required to state the ability to accept or send the message element as part of a conformance claim.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10015"
            }
          ],
          "concept" : [
            {
              "code" : "RE",
              "display" : "Required may be empty",
              "definition" : "Pursuant to a profile or vendor conformance claim, the message element must appear every time the message is communicated, but the value may be communicated as null.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10016"
                }
              ]
            },
            {
              "code" : "X",
              "display" : "Excluded",
              "definition" : "Pursuant to a profile or vendor conformance claim, this message element may not appear when the message is communicated.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10017"
                }
              ]
            }
          ]
        },
        {
          "code" : "RQ",
          "display" : "Required",
          "definition" : "The message element must appear every time the message is communicated, but the value may be communicated as null.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10013"
            }
          ]
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Mandatory",
      "definition" : "The message element must appear every time the message is communicated and its value must not be null. This condition is subject to the rules of multiplicity and conditionality. If a non-null default value is defined for the element, a null value may be communicated.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Required - V2.x"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "R"
        },
        {
          "code" : "internalId",
          "valueCode" : "10011"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Mandatory",
      "definition" : "The message element must appear every time the message is communicated and its value must not be null. This condition is subject to the rules of multiplicity and conditionality. If a non-null default value is defined for the element, a null value may be communicated.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Required - V2.x"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "M"
        },
        {
          "code" : "internalId",
          "valueCode" : "10011"
        }
      ]
    }
  ]
}

```
