# EntityNamePartQualifierR2 - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityNamePartQualifierR2**

## CodeSystem: EntityNamePartQualifierR2 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifierR2 | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityNamePartQualifierR2 |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1122 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**Description:**The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EntityNamePartQualifierR2](ValueSet-v3-EntityNamePartQualifierR2.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityNamePartQualifierR2",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityNamePartQualifierR2",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1122"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityNamePartQualifierR2",
  "title" : "EntityNamePartQualifierR2",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**Description:**The qualifier is a set of codes each of which specifies a certain subcategory of the name part in addition to the main name part type. For example, a given name may be flagged as a nickname, a family name may be a pseudonym or a name of public records.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "acquired",
      "definition" : "**Description:**A name part a person acquired. The name part may be acquired by adoption, or the person may have chosen to use the name part for some other reason.\r\n\r\n**Note:** this differs from an Other/Psuedonym/Alias in that an acquired name part is acquired on a formal basis rather than an informal one (e.g. registered as part of the official name).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22791"
        }
      ],
      "concept" : [
        {
          "code" : "SP",
          "display" : "spouse",
          "definition" : "**Description:**The name assumed from the partner in a marital relationship. Usually the spouse's family name. Note that no inference about gender can be made from the existence of spouse names.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22792"
            }
          ]
        }
      ]
    },
    {
      "code" : "BR",
      "display" : "birth",
      "definition" : "**Description:**A name that a person was given at birth or established as a consequence of adoption.\r\n\r\n**Note:** This is not used for temporary names assigned at birth such as \"Baby of Smith\" a\" which is just a name with a use code of \"TEMP\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22790"
        }
      ]
    },
    {
      "code" : "CL",
      "display" : "callme",
      "definition" : "**Description:**Used to indicate which of the various name parts is used when interacting with the person.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22794"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "initial",
      "definition" : "**Description:**Indicates that a name part is just an initial. Initials do not imply a trailing period since this would not work with non-Latin scripts. In some languages, initials may consist of more than one letter, e.g., \"Ph\" could stand for \"Philippe\" or \"Th\" For \"Thomas\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22795"
        }
      ]
    },
    {
      "code" : "LS",
      "display" : "legal status",
      "definition" : "**Description:**For organizations a suffix indicating the legal status, e.g., \"Inc.\", \"Co.\", \"AG\", \"GmbH\", \"B.V.\" \"S.A.\", \"Ltd.\" etc.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22789"
        }
      ]
    },
    {
      "code" : "MID",
      "display" : "middle name",
      "definition" : "**Description:**Indicates that the name part is a middle name.\r\n\r\n**Usage Notes:** In general, the english \"middle name\" concept is all of the given names after the first. This qualifier may be used to explicitly indicate which given names are considered to be middle names. The middle name qualifier may also be used with family names. This is a Scandinavian use case, matching the concept of \"mellomnavn\",\"mellannamn\". Note that there are specific rules that indicate what names may be taken as a mellannamn in different Scandinavian countries.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "In general, the english \"middle name\" concept is all of the given names after the first. This qualifier may be used to explicitly indicate which given names are considered to be middle names. The middle name qualifier may also be used with family names. This is a Scandinavian use case, matching the concept of \"mellomnavn\",\"mellannamn\". Note that there are specific rules that indicate what names may be taken as a mellannamn in different Scandinavian countries."
        },
        {
          "code" : "internalId",
          "valueCode" : "22793"
        }
      ]
    },
    {
      "code" : "PFX",
      "display" : "prefix",
      "definition" : "**Description:**A prefix has a strong association to the immediately following name part. A prefix has no implicit trailing white space (it has implicit leading white space though).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22796"
        }
      ]
    },
    {
      "code" : "PharmaceuticalEntityNamePartQualifiers",
      "display" : "PharmaceuticalEntityNamePartQualifiers",
      "definition" : "**Description:** Medication Name Parts are a means of specifying a range of acceptable \"official\" forms of the name of a product. They are used as patterns against which input name strings may be matched for automatic identification of products from input text reports. While they cover the concepts held under \"doseForm\" or \"route\" or \"strength\" the name parts are not the same and do not fit into a controlled vocabulary in the same way. By specifying up to 8 name parts a much larger range of possible names can be generated.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22988"
        }
      ],
      "concept" : [
        {
          "code" : "CON",
          "display" : "container name",
          "definition" : "**Description:** This refers to the container if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): pre-filled syringe",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22994"
            }
          ]
        },
        {
          "code" : "DEV",
          "display" : "device name",
          "definition" : "**Description:** This refers to the qualifiers in the name for devices and is at the moment mainly applicable to insulins and inhalation products.\r\n\r\nEXAMPLES:\r\n\r\n *  For the medicinal product Actrapid FlexPen 100 IU/ml Solution for injection Subcutaneous use: FlexPen.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22995"
            }
          ]
        },
        {
          "code" : "FLAV",
          "display" : "FlavorName",
          "definition" : "**Description:** This refers to a flavor of the medicinal product if present in the medicinal product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'CoughCure Linctus Orange Flavor', the flavor part is \"Orange\"\r\n *  For 'Wonderdrug Syrup Cherry Flavor', the flavor part is \"Cherry\"",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23318"
            }
          ]
        },
        {
          "code" : "FORMUL",
          "display" : "FormulationPartName",
          "definition" : "**Description:** This refers to the formulation of the medicinal product if present in the medicinal product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'SpecialMed Sugar Free Cough Syrup', the formulation name part is \"Sugar Free\"\r\n *  For 'QuickCure Gluten-free Bulk Fibre', the formulation name part is \"gluten-free\"",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23316"
            }
          ]
        },
        {
          "code" : "FRM",
          "display" : "form name",
          "definition" : "**Description:** This refers to the pharmaceutical form/ if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase 50 mg soft capsules: Soft Capsules\r\n *  For Ludiomil 25mg-Filmtabletten: Filmtabletten\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): suspension for injection",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22992"
            }
          ]
        },
        {
          "code" : "INV",
          "display" : "invented name",
          "definition" : "**Description:** This refers to the product name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name and, if appropriate, whether it is intended e.g. for babies, children or adults.\r\n\r\nEXAMPLES:\r\n\r\n *  Agenerase\r\n *  Optaflu\r\n *  Ludiomil",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22989"
            }
          ]
        },
        {
          "code" : "POPUL",
          "display" : "TargetPopulationName",
          "definition" : "**Description:** This refers to the target population for the medicinal product if present in the medicinal product name\r\n\r\n**Examples:**\r\n\r\n *  For 'Broncho-Drug 3.5 mg-capsules for children', the target population part is \"children\"\r\n *  For 'Adult Chesty Cough Syrup', the target population part is \"adult\"",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23315"
            }
          ]
        },
        {
          "code" : "SCI",
          "display" : "scientific name",
          "definition" : "**Description:** This refers to the product common or scientific name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase: N/A\r\n *  For Optaflu: Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season)\r\n *  For Ludiomil: N/A",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22990"
            }
          ]
        },
        {
          "code" : "STR",
          "display" : "strength name",
          "definition" : "**Description:** This refers to the strength if present in the medicinal product name. The use of decimal points should be accommodated if required.\r\n\r\nEXAMPLES:\r\n\r\n *  For Agenerase 50 mg soft capsules: 50mg\r\n *  For Ludiomil 25mg-Filmtabletten: 25 mg\r\n *  For Optaflu suspension for injection in pre-filled syringe Influenza vaccine (surface antigen, inactivated, prepared in cell culture) (2007/2008 season): N/A",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22991"
            }
          ]
        },
        {
          "code" : "TIME",
          "display" : "TimeOrPeriodName",
          "definition" : "**Description:** This refers to a time or time period that may be specified in the text of the medicinal product name\r\n\r\n**Example:**\r\n\r\n *  For an influenza vaccine 'Drug-FLU season 2008/2009', the time/period part is \"2008/2009 season\"",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "23317"
            }
          ]
        },
        {
          "code" : "TMK",
          "display" : "trademark name",
          "definition" : "**Description:** This refers to trademark/company element if present in the medicinal product name.\r\n\r\nEXAMPLES:\r\n\r\n *  for Insulin Human Winthrop Comb 15: Winthrop",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22996"
            }
          ]
        },
        {
          "code" : "USE",
          "display" : "intended use name",
          "definition" : "**Description:** This refers to the intended use if present in the medicinal product name without the trademark or the name of the marketing authorization holder or any other descriptor reflected in the product name.\r\n\r\n**Examples:**\r\n\r\n *  For 'Drug-BI Caplets - Heartburn Relief', the intended use part is: \"Heartburn Relief\"\r\n *  For 'Medicine Honey Syrup for Soothing Coughs' the intended use part is \"Soothing Coughs\"",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22993"
            }
          ]
        }
      ]
    },
    {
      "code" : "SFX",
      "display" : "suffix",
      "definition" : "**Description:**A suffix has a strong association to the immediately preceding name part. A suffix has no implicit leading white space (it has implicit trailing white space though).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22797"
        }
      ]
    },
    {
      "code" : "TitleStyles",
      "display" : "TitleStyles",
      "definition" : "**Description:**Extra information about the style of a title",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22798"
        }
      ],
      "concept" : [
        {
          "code" : "AC",
          "display" : "academic",
          "definition" : "**Description:**Indicates that a title like \"Dr.\", \"M.D.\" or \"Ph.D.\" is an academic title.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22799"
            }
          ]
        },
        {
          "code" : "HON",
          "display" : "honorific",
          "definition" : "**Description:**A honorific such as \"The Right Honourable\" or \"Weledelgeleerde Heer\".",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "synonymCode",
              "valueCode" : "HOM"
            },
            {
              "code" : "internalId",
              "valueCode" : "22802"
            }
          ]
        },
        {
          "code" : "HOM",
          "display" : "honorific",
          "definition" : "**Description:**A honorific such as \"The Right Honourable\" or \"Weledelgeleerde Heer\".",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "synonymCode",
              "valueCode" : "HON"
            },
            {
              "code" : "internalId",
              "valueCode" : "22802"
            }
          ]
        },
        {
          "code" : "NB",
          "display" : "nobility",
          "definition" : "**Description:**A nobility title such as Sir, Count, Grafin.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22801"
            }
          ]
        },
        {
          "code" : "PR",
          "display" : "professional",
          "definition" : "**Description:**Primarily in the British Imperial culture people tend to have an abbreviation of their professional organization as part of their credential titles.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22800"
            }
          ]
        }
      ]
    }
  ]
}

```
