# EditStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EditStatus**

## CodeSystem: EditStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EditStatus | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*Health Level 7 | *Computable Name*:EditStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.5.35 | | |

 
The status of an entry as it pertains to its review and incorporation into the HL7 domain specification database. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EditStatus",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EditStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.35"
    }
  ],
  "version" : "2.0.1",
  "name" : "EditStatus",
  "title" : "EditStatus",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level 7",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "The status of an entry as it pertains to its review and incorporation into the HL7 domain specification database.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Active",
      "definition" : "The item has been reviewed and approved and is now valid for use in HL7 standards and messages.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11042"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Inactive",
      "definition" : "A previously active item has been retired from use. The item may exist as previously stored data in a database, but no current or new HL7 standards or messges should use this item. The code for an inactive item will not be reused by HL7.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11044"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Obsolete",
      "definition" : "A previously active item that is scheduled to be retired from use, but for practical reasons can not be immediately inactivated. It is still legal to use an obsolete item in HL7 standards or messages, but those creating new messages should make every effort to use an active concept instead.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11045"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Proposed",
      "definition" : "The item has been suggested for incorporation but has not been officially approved. The item is not yet legal for use in HL7 standards and messages.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11041"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Rejected",
      "definition" : "The item has been reviewed and rejected. The item is not legal for use in HL7 standards and messages.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11043"
        }
      ]
    }
  ]
}

```
