# CommunicationFunctionType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CommunicationFunctionType**

## CodeSystem: CommunicationFunctionType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-CommunicationFunctionType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CommunicationFunctionType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1056 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Describes the type of communication function that the associated entity plays in the associated transmission. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CommunicationFunctionType](ValueSet-v3-CommunicationFunctionType.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-CommunicationFunctionType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-CommunicationFunctionType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1056"
    }
  ],
  "version" : "3.0.0",
  "name" : "CommunicationFunctionType",
  "title" : "CommunicationFunctionType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Describes the type of communication function that the associated entity plays in the associated transmission.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "RCV",
      "display" : "receiver",
      "definition" : "The entity is the receiver of the transmission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16033"
        }
      ]
    },
    {
      "code" : "RSP",
      "display" : "respond to",
      "definition" : "The entity is the one to which the response or reply to the transmission should be sent.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16034"
        }
      ]
    },
    {
      "code" : "SND",
      "display" : "sender",
      "definition" : "The entity is the sender of the transmission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "16032"
        }
      ]
    }
  ]
}

```
