# ActRelationshipType - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ActRelationshipType**

## CodeSystem: ActRelationshipType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType | *Version*:4.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ActRelationshipType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1002 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The source is an excerpt from the target. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ActRelationshipAccounting](ValueSet-v3-ActRelationshipAccounting.md)
* [ActRelationshipActProvenance](ValueSet-v3-ActRelationshipActProvenance.md)
* [ActRelationshipActiveImmunizationAgainst](ValueSet-v3-ActRelationshipActiveImmunizationAgainst.md)
* [ActRelationshipAdjunctCurativeIndication](ValueSet-v3-ActRelationshipAdjunctCurativeIndication.md)
* [ActRelationshipAdjunctMitigation](ValueSet-v3-ActRelationshipAdjunctMitigation.md)
* [ActRelationshipAdjunctiveTreatment](ValueSet-v3-ActRelationshipAdjunctiveTreatment.md)
* [ActRelationshipArrival](ValueSet-v3-ActRelationshipArrival.md)
* [ActRelationshipAssignsName](ValueSet-v3-ActRelationshipAssignsName.md)
* [ActRelationshipAuthorizedBy](ValueSet-v3-ActRelationshipAuthorizedBy.md)
* [ActRelationshipBlocks](ValueSet-v3-ActRelationshipBlocks.md)
* [ActRelationshipCompliesWith](ValueSet-v3-ActRelationshipCompliesWith.md)
* [ActRelationshipConcurrentWith](ValueSet-v3-ActRelationshipConcurrentWith.md)
* [ActRelationshipConditional](ValueSet-v3-ActRelationshipConditional.md)
* [ActRelationshipContainsEndOf](ValueSet-v3-ActRelationshipContainsEndOf.md)
* [ActRelationshipContainsStartOf](ValueSet-v3-ActRelationshipContainsStartOf.md)
* [ActRelationshipContainsStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipContainsStartOfEndsBeforeEndOf.md)
* [ActRelationshipContainsTimeOf](ValueSet-v3-ActRelationshipContainsTimeOf.md)
* [ActRelationshipCostTracking](ValueSet-v3-ActRelationshipCostTracking.md)
* [ActRelationshipCoveredBy](ValueSet-v3-ActRelationshipCoveredBy.md)
* [ActRelationshipCurativeIndication](ValueSet-v3-ActRelationshipCurativeIndication.md)
* [ActRelationshipDeparture](ValueSet-v3-ActRelationshipDeparture.md)
* [ActRelationshipDiagnosis](ValueSet-v3-ActRelationshipDiagnosis.md)
* [ActRelationshipDocumentHQMF](ValueSet-v3-ActRelationshipDocumentHQMF.md)
* [ActRelationshipDocumentProvenance](ValueSet-v3-ActRelationshipDocumentProvenance.md)
* [ActRelationshipDocuments](ValueSet-v3-ActRelationshipDocuments.md)
* [ActRelationshipDuring](ValueSet-v3-ActRelationshipDuring.md)
* [ActRelationshipEndsAfterEndOf](ValueSet-v3-ActRelationshipEndsAfterEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipEndsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipEndsAfterStartOf](ValueSet-v3-ActRelationshipEndsAfterStartOf.md)
* [ActRelationshipEndsBeforeEnd](ValueSet-v3-ActRelationshipEndsBeforeEnd.md)
* [ActRelationshipEndsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipEndsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipEndsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipEndsBeforeStartOf](ValueSet-v3-ActRelationshipEndsBeforeStartOf.md)
* [ActRelationshipEndsConcurrentWith](ValueSet-v3-ActRelationshipEndsConcurrentWith.md)
* [ActRelationshipEndsConcurrentWithStart](ValueSet-v3-ActRelationshipEndsConcurrentWithStart.md)
* [ActRelationshipEndsDuring](ValueSet-v3-ActRelationshipEndsDuring.md)
* [ActRelationshipEndsNearEnd](ValueSet-v3-ActRelationshipEndsNearEnd.md)
* [ActRelationshipEndsNearStarts](ValueSet-v3-ActRelationshipEndsNearStarts.md)
* [ActRelationshipEpisodelink](ValueSet-v3-ActRelationshipEpisodelink.md)
* [ActRelationshipEvaluatesGoal](ValueSet-v3-ActRelationshipEvaluatesGoal.md)
* [ActRelationshipExacerbatredBy](ValueSet-v3-ActRelationshipExacerbatredBy.md)
* [ActRelationshipExcerpt](ValueSet-v3-ActRelationshipExcerpt.md)
* [ActRelationshipExcerptVerbatim](ValueSet-v3-ActRelationshipExcerptVerbatim.md)
* [ActRelationshipFulfills](ValueSet-v3-ActRelationshipFulfills.md)
* [ActRelationshipHasBaseline](ValueSet-v3-ActRelationshipHasBaseline.md)
* [ActRelationshipHasBoundedSupport](ValueSet-v3-ActRelationshipHasBoundedSupport.md)
* [ActRelationshipHasCharge](ValueSet-v3-ActRelationshipHasCharge.md)
* [ActRelationshipHasComponent](ValueSet-v3-ActRelationshipHasComponent.md)
* [ActRelationshipHasContinuingObjective](ValueSet-v3-ActRelationshipHasContinuingObjective.md)
* [ActRelationshipHasContraIndication](ValueSet-v3-ActRelationshipHasContra-indication.md)
* [ActRelationshipHasControlVariable](ValueSet-v3-ActRelationshipHasControlVariable.md)
* [ActRelationshipHasCost](ValueSet-v3-ActRelationshipHasCost.md)
* [ActRelationshipHasCredit](ValueSet-v3-ActRelationshipHasCredit.md)
* [ActRelationshipHasDebit](ValueSet-v3-ActRelationshipHasDebit.md)
* [ActRelationshipHasExplanation](ValueSet-v3-ActRelationshipHasExplanation.md)
* [ActRelationshipHasFinalObjective](ValueSet-v3-ActRelationshipHasFinalObjective.md)
* [ActRelationshipHasGeneralization](ValueSet-v3-ActRelationshipHasGeneralization.md)
* [ActRelationshipHasGoal](ValueSet-v3-ActRelationshipHasGoal.md)
* [ActRelationshipHasMember](ValueSet-v3-ActRelationshipHasMember.md)
* [ActRelationshipHasMetadata](ValueSet-v3-ActRelationshipHasMetadata.md)
* [ActRelationshipHasOption](ValueSet-v3-ActRelationshipHasOption.md)
* [ActRelationshipHasPart](ValueSet-v3-ActRelationshipHasPart.md)
* [ActRelationshipHasPreCondition](ValueSet-v3-ActRelationshipHasPre-condition.md)
* [ActRelationshipHasPreviousInstance](ValueSet-v3-ActRelationshipHasPreviousInstance.md)
* [ActRelationshipHasQualifier](ValueSet-v3-ActRelationshipHasQualifier.md)
* [ActRelationshipHasReferenceValues](ValueSet-v3-ActRelationshipHasReferenceValues.md)
* [ActRelationshipHasRisk](ValueSet-v3-ActRelationshipHasRisk.md)
* [ActRelationshipHasStep](ValueSet-v3-ActRelationshipHasStep.md)
* [ActRelationshipHasSubject](ValueSet-v3-ActRelationshipHasSubject.md)
* [ActRelationshipHasSupport](ValueSet-v3-ActRelationshipHasSupport.md)
* [ActRelationshipHasTrigger](ValueSet-v3-ActRelationshipHasTrigger.md)
* [ActRelationshipHasValue](ValueSet-v3-ActRelationshipHasValue.md)
* [ActRelationshipICSRInvestigation](ValueSet-v3-ActRelationshipICSRInvestigation.md)
* [ActRelationshipImmunizationAgainst](ValueSet-v3-ActRelationshipImmunizationAgainst.md)
* [ActRelationshipIndependentOfTimeOf](ValueSet-v3-ActRelationshipIndependentOfTimeOf.md)
* [ActRelationshipInstantiatesMaster](ValueSet-v3-ActRelationshipInstantiatesMaster.md)
* [ActRelationshipInterferedBy](ValueSet-v3-ActRelationshipInterferedBy.md)
* [ActRelationshipIsAppendage](ValueSet-v3-ActRelationshipIsAppendage.md)
* [ActRelationshipIsDerivedFrom](ValueSet-v3-ActRelationshipIsDerivedFrom.md)
* [ActRelationshipIsEtiologyFor](ValueSet-v3-ActRelationshipIsEtiologyFor.md)
* [ActRelationshipIsManifestationOf](ValueSet-v3-ActRelationshipIsManifestationOf.md)
* [ActRelationshipItemsLocated](ValueSet-v3-ActRelationshipItemsLocated.md)
* [ActRelationshipLimitedBy](ValueSet-v3-ActRelationshipLimitedBy.md)
* [ActRelationshipMaintenanceTreatment](ValueSet-v3-ActRelationshipMaintenanceTreatment.md)
* [ActRelationshipMatchesTrigger](ValueSet-v3-ActRelationshipMatchesTrigger.md)
* [ActRelationshipMitigates](ValueSet-v3-ActRelationshipMitigates.md)
* [ActRelationshipModifies](ValueSet-v3-ActRelationshipModifies.md)
* [ActRelationshipObjective](ValueSet-v3-ActRelationshipObjective.md)
* [ActRelationshipOccurrence](ValueSet-v3-ActRelationshipOccurrence.md)
* [ActRelationshipOutcome](ValueSet-v3-ActRelationshipOutcome.md)
* [ActRelationshipOverlapsWith](ValueSet-v3-ActRelationshipOverlapsWith.md)
* [ActRelationshipPalliates](ValueSet-v3-ActRelationshipPalliates.md)
* [ActRelationshipPassiveImmunizationAgainst](ValueSet-v3-ActRelationshipPassiveImmunizationAgainst.md)
* [ActRelationshipPertains](ValueSet-v3-ActRelationshipPertains.md)
* [ActRelationshipPosting](ValueSet-v3-ActRelationshipPosting.md)
* [ActRelationshipProphylaxisOf](ValueSet-v3-ActRelationshipProphylaxisOf.md)
* [ActRelationshipProvidesEvidenceFor](ValueSet-v3-ActRelationshipProvidesEvidenceFor.md)
* [ActRelationshipReChallenge](ValueSet-v3-ActRelationshipRe-challenge.md)
* [ActRelationshipReason](ValueSet-v3-ActRelationshipReason.md)
* [ActRelationshipRecovery](ValueSet-v3-ActRelationshipRecovery.md)
* [ActRelationshipReferencesOrder](ValueSet-v3-ActRelationshipReferencesOrder.md)
* [ActRelationshipRefersTo](ValueSet-v3-ActRelationshipRefersTo.md)
* [ActRelationshipRelievedBy](ValueSet-v3-ActRelationshipRelievedBy.md)
* [ActRelationshipReplaces](ValueSet-v3-ActRelationshipReplaces.md)
* [ActRelationshipReverses](ValueSet-v3-ActRelationshipReverses.md)
* [ActRelationshipSchedulesRequest](ValueSet-v3-ActRelationshipSchedulesRequest.md)
* [ActRelationshipSequel](ValueSet-v3-ActRelationshipSequel.md)
* [ActRelationshipStartAfterStartOfContainsEndOf](ValueSet-v3-ActRelationshipStartAfterStartOfContainsEndOf.md)
* [ActRelationshipStartsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithEndOf.md)
* [ActRelationshipStartsAfterOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsAfterOrConcurrentWithStartOf.md)
* [ActRelationshipStartsAfterStartOf](ValueSet-v3-ActRelationshipStartsAfterStartOf.md)
* [ActRelationshipStartsAfterStartOfEndsWith](ValueSet-v3-ActRelationshipStartsAfterStartOfEndsWith.md)
* [ActRelationshipStartsAfterStartofEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsAfterStartofEndsAfterEndOf.md)
* [ActRelationshipStartsBeforeEnd](ValueSet-v3-ActRelationshipStartsBeforeEnd.md)
* [ActRelationshipStartsBeforeOrConcurrentWithEndOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithEndOf.md)
* [ActRelationshipStartsBeforeOrConcurrentWithStartOf](ValueSet-v3-ActRelationshipStartsBeforeOrConcurrentWithStartOf.md)
* [ActRelationshipStartsBeforeStartOf](ValueSet-v3-ActRelationshipStartsBeforeStartOf.md)
* [ActRelationshipStartsBeforeStartOfEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsBeforeEndOf.md)
* [ActRelationshipStartsBeforeStartOfEndsWith](ValueSet-v3-ActRelationshipStartsBeforeStartOfEndsWith.md)
* [ActRelationshipStartsConcurrentWith](ValueSet-v3-ActRelationshipStartsConcurrentWith.md)
* [ActRelationshipStartsConcurrentWithEnd](ValueSet-v3-ActRelationshipStartsConcurrentWithEnd.md)
* [ActRelationshipStartsDuring](ValueSet-v3-ActRelationshipStartsDuring.md)
* [ActRelationshipStartsNearEnd](ValueSet-v3-ActRelationshipStartsNearEnd.md)
* [ActRelationshipStartsNearStart](ValueSet-v3-ActRelationshipStartsNearStart.md)
* [ActRelationshipStartsWithEndsAfterEndOf](ValueSet-v3-ActRelationshipStartsWithEndsAfterEndOf.md)
* [ActRelationshipStartsWithEndsBeforeEndOf](ValueSet-v3-ActRelationshipStartsWithEndsBeforeEndOf.md)
* [ActRelationshipSucceeds](ValueSet-v3-ActRelationshipSucceeds.md)
* [ActRelationshipSummarizedBy](ValueSet-v3-ActRelationshipSummarizedBy.md)
* [ActRelationshipSymptomaticRelief](ValueSet-v3-ActRelationshipSymptomaticRelief.md)
* [ActRelationshipTemporallyPertains](ValueSet-v3-ActRelationshipTemporallyPertains.md)
* [ActRelationshipTemporallyPertainsApproximates](ValueSet-v3-ActRelationshipTemporallyPertainsApproximates.md)
* [ActRelationshipTemporallyPertainsEnd](ValueSet-v3-ActRelationshipTemporallyPertainsEnd.md)
* [ActRelationshipTemporallyPertainsStart](ValueSet-v3-ActRelationshipTemporallyPertainsStart.md)
* [ActRelationshipTransformation](ValueSet-v3-ActRelationshipTransformation.md)
* [ActRelationshipTreats](ValueSet-v3-ActRelationshipTreats.md)
* [ActRelationshipType](ValueSet-v3-ActRelationshipType.md)
* [ActRelationshipUpdate](ValueSet-v3-ActRelationshipUpdate.md)
* [ActRelationshipUpdatesCondition](ValueSet-v3-ActRelationshipUpdatesCondition.md)
* [ActRelationshipUses](ValueSet-v3-ActRelationshipUses.md)
* [XActRelationshipDocument](ValueSet-v3-xActRelationshipDocument.md)
* [XActRelationshipDocumentSPL](ValueSet-v3-xActRelationshipDocumentSPL.md)
* [XActRelationshipEntry](ValueSet-v3-xActRelationshipEntry.md)
* [XActRelationshipEntryRelationship](ValueSet-v3-xActRelationshipEntryRelationship.md)
* [XActRelationshipExternalReference](ValueSet-v3-xActRelationshipExternalReference.md)
* [XActRelationshipPatientTransport](ValueSet-v3-xActRelationshipPatientTransport.md)
* [XActRelationshipPertinentInfo](ValueSet-v3-xActRelationshipPertinentInfo.md)
* [XActRelationshipRelatedAuthorizations](ValueSet-v3-xActRelationshipRelatedAuthorizations.md)
* [XActReplaceOrRevise](ValueSet-v3-xActReplaceOrRevise.md)
* [XSUCCREPLPREV](ValueSet-v3-xSUCCREPLPREV.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ActRelationshipType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ActRelationshipType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1002"
    }
  ],
  "version" : "4.0.0",
  "name" : "ActRelationshipType",
  "title" : "ActRelationshipType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The source is an excerpt from the target.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "conductible",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-conductible",
      "description" : "If true, indicates that ActRelationships or Participations of the specified type (and any specializations thereof) will normally conduct. For more usage information, refer to the Core Principles specification.",
      "type" : "boolean"
    },
    {
      "code" : "isDocumentCharacteristic",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-document-characteristic",
      "description" : "If true, indicates that the Act attribute or association (as represented by a typeCode for eaither ActRelationship or Pareticipation is a descriptor of the document (record) represented by the act object. If false, indicates the property is a descriptor of the action itself, actual, intended, or potential.  Applies to interpretation of attributes and associations with respect to changes in the value of Act.actionNegationInd and Act.moodCode. (See descriptions of these attributes for further discussion.) For example, in an order, the id attribute [isDocumentCharacteristic = true] is an identifier of the record of the order, not an identifier of the intended event.  On the other hand, the code attribute [isDocumentCharacteristic = false] describes a characteristic of the intended event.",
      "type" : "boolean"
    },
    {
      "code" : "Name:Act:inboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-inbound-relationship",
      "description" : "Name of inboundRelationship from Act to ActReln",
      "type" : "code"
    },
    {
      "code" : "Name:Act:outboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-outbound-relationship",
      "description" : "Formal name of outboundRelationship from Act to ActReln",
      "type" : "code"
    },
    {
      "code" : "Sort:Act:inboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Act-inbound-sort",
      "description" : "Sort key for the inboundRelationship from Act to ActReln",
      "type" : "code"
    },
    {
      "code" : "Sort:Act:outboundRelationship:ActRelationship",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-act-outbound-sort",
      "description" : "Sort key for the outboundRelationship from Act to ActReln",
      "type" : "code"
    },
    {
      "code" : "appliesTo",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-applies-to",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "howApplies",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-how-applies",
      "description" : "Haven't a clue!",
      "type" : "string"
    },
    {
      "code" : "Name:ActRelationship:source:Act",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-ActRelationship-source",
      "description" : "The name of the assciation from ActRelationship to the source Act",
      "type" : "string"
    },
    {
      "code" : "Name:ActRelationship:target:Act",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-ActRelationship-target",
      "description" : "The name of the assciation from ActRelationship to the source Act",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    },
    {
      "code" : "subsumedBy",
      "uri" : "http://hl7.org/fhir/concept-properties#parent",
      "description" : "The concept code of a parent concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ART",
      "display" : "act relationship type",
      "definition" : "**Description:** A directed association between a source Act and a target Act.\r\n\r\n**Usage Note:** This code should never be transmitted in an instance as the value of ActRelationship.typeCode (attribute)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23252"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CURE",
      "display" : "curative indication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21642"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CURE.ADJ",
      "display" : "adjunct curative indication",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21643"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTGT.ADJ",
      "display" : "adjunct mitigation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21641"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RACT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "14892"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUGG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "10322"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsEnd",
      "display" : "ActRelationshipTemporallyPertainsEnd",
      "definition" : "A relationship that defines the relative time of the end source act based on the time of the target act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23077"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endTemporallyRelatedTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatedEndInformation"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsStart",
      "display" : "ActRelationshipTemporallyPertainsStart",
      "definition" : "A relationship that defines the relative time of the start source act based on the time of the target act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23075"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startTemporallyRelatedTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatedStartInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DNA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DNA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipCostTracking",
      "display" : "ActRelationshipCostTracking",
      "definition" : "Expresses values for describing the relationship relationship between an InvoiceElement or InvoiceElementGroup and a billable act.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21360"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "costTrackingOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "costTracking"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipPosting",
      "display" : "ActRelationshipPosting",
      "definition" : "Expresses values for describing the relationship between a FinancialTransaction and an Account.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21359"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "postingTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "posting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CIND",
      "display" : "has contra-indication",
      "definition" : "A contraindication is just a negation of a reason, i.e. it gives a condition under which the action is not to be done. Both, source and target can be any kind of service; target service is in criterion mood. How the strength of a contraindication is expressed (e.g., relative, absolute) is left as an open issue. The priorityNumber attribute could be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10323"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "contra-indication"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "contraindicationFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "contraindication"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "CC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "CC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PRCN",
      "display" : "has pre-condition",
      "definition" : "A requirement to be true before a service is performed. The target can be any service in criterion mood. For multiple pre-conditions a conjunction attribute (AND, OR, XOR) is applicable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10319"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "pre-condition"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "preconditionFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "precondition"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "CD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "CD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RSON",
      "display" : "has reason",
      "definition" : "**Description:** The reason or rationale for a service. A reason link is weaker than a trigger, it only suggests that some service may be or might have been a reason for some action, but not that this reason requires/required the action to be taken. Also, as opposed to the trigger, there is no strong timely relation between the reason and the action. As well as providing various types of information about the rationale for a service, the RSON act relationship is routinely used between a SBADM act and an OBS act to describe the indication for use of a medication. Child concepts may be used to describe types of indication.\r\n\r\n*Discussion:* In prior releases, the code \"SUGG\" (suggests) was expressed as \"an inversion of the reason link.\" That code has been retired in favor of the inversion indicator that is an attribute of ActRelationship.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10321"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "reason"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "reasonOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "reason"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "CA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "CA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TRIG",
      "display" : "has trigger",
      "definition" : "A pre-condition that if true should result in the source Act being executed. The target is in typically in criterion mood. When reported after the fact (i.e. the criterion has been met) it may be in Event mood. A delay between the trigger and the triggered action can be specified.\r\n\r\n*Discussion:* This includes the concept of a required act for a service or financial instrument such as an insurance plan or policy. In such cases, the trigger is the occurrence of a specific condition such as coverage limits being exceeded.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10320"
        },
        {
          "code" : "appliesTo",
          "valueString" : "action"
        },
        {
          "code" : "howApplies",
          "valueString" : "trigger"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "triggerFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "trigger"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "CB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "CB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipConditional"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CHRG",
      "display" : "has charge",
      "definition" : "A relationship that provides an ability to associate a financial transaction (target) as a charge to a clinical act (source). A clinical act may have a charge associated with the execution or delivery of the service.\r\n\r\nThe financial transaction will define the charge (bill) for delivery or performance of the service.\r\n\r\nCharges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14904"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "chargeFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "charge"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOBA_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOBA_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipCostTracking"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COST",
      "display" : "has cost",
      "definition" : "A relationship that provides an ability to associate a financial transaction (target) as a cost to a clinical act (source). A clinical act may have an inherit cost associated with the execution or delivery of the service.\r\n\r\nThe financial transaction will define the cost of delivery or performance of the service.\r\n\r\nCharges and costs are distinct terms. A charge defines what is charged or billed to another organization or entity within an organization. The cost defines what it costs an organization to perform or deliver a service or product.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14903"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "costOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "cost"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOBB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOBB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipCostTracking"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CREDIT",
      "display" : "has credit",
      "definition" : "A credit relationship ties a financial transaction (target) to an account (source). A credit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account credit will decrease the account balance. A non-asset account credit will decrease the account balance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14902"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "creditTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "credit"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOAA_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOAA_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosting"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DEBIT",
      "display" : "has debit",
      "definition" : "A debit relationship ties a financial transaction (target) to an account (source). A debit, once applied (posted), may have either a positive or negative effect on the account balance, depending on the type of account. An asset account debit will increase the account balance. A non-asset account debit will decrease the account balance.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14901"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "debitTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "debit"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DOAB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DOAB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipPosting"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertainsApproximates",
      "display" : "ActRelationshipTemporallyPertainsApproximates",
      "definition" : "Abstract collector for ActRelationship types that relate two acts by their approximate timing.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23637"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAS",
      "display" : "ends after start of",
      "definition" : "A relationship in which the source act ends after the target act starts.\r\n\r\n*UsageNote:* Inverse code is **SBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23079"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsAfterStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EASORECWS",
      "display" : "ends after or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time ends after or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EBSORECWS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23645"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INDEPENDENT",
      "display" : "independent of time of",
      "definition" : "The source Act is independent of the time of the target Act.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23582"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "independentOfTimeOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "independentOfTimeOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAEORSCWE",
      "display" : "starts after or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time starts after or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SBEORSCWE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23644"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASORSCW",
      "display" : "starts after or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time starts after or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SBSORSCW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23642"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBEORSCWE",
      "display" : "starts before or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time starts before or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SAEORSCWE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23643"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertains"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ENE",
      "display" : "ends near end",
      "definition" : "A relationship in which the source act's effective time ends near the end of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is ENS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23640"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsNearStart"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsNearEnd"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ENS",
      "display" : "ends near start",
      "definition" : "A relationship in which the source act's effective time ends near the start of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is ENE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23641"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsNearEnd"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsNearStart"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SNE",
      "display" : "starts near end",
      "definition" : "A relationship in which the source act's effective time starts near the end of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is SNS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23638"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsNearStart"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsNearEnd"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SNS",
      "display" : "starts near start",
      "definition" : "A relationship in which the source act's effective time starts near the start of the target act's effective time. Near is defined separately as a time interval.\r\n\r\n*Usage Note:* Inverse code is SNE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23639"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsNearEnd"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsNearStart"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationshipTemporallyPertainsApproximates"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OBJC",
      "display" : "has continuing objective",
      "definition" : "A desired state that a service action aims to maintain. E.g., keep systolic blood pressure between 90 and 110 mm Hg. Source is an intervention service. Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10327"
        },
        {
          "code" : "appliesTo",
          "valueString" : "service"
        },
        {
          "code" : "howApplies",
          "valueString" : "criterion"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "maintenanceGoalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "maintenanceGoal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "ACA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "ACA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationsipObjective"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OBJF",
      "display" : "has final objective",
      "definition" : "A desired outcome that a service action aims to meet finally. Source is any service (typically an intervention). Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10326"
        },
        {
          "code" : "appliesTo",
          "valueString" : "service"
        },
        {
          "code" : "howApplies",
          "valueString" : "criterion"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "finalGoalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "finalGoal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "ACB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "ACB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "_ActRelationsipObjective"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActClassTemporallyPertains",
      "display" : "ActClassTemporallyPertains",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "TemporallyPertains"
        },
        {
          "code" : "internalId",
          "valueCode" : "21307"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatesTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatedInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TemporallyPertains",
      "display" : "ActClassTemporallyPertains",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActClassTemporallyPertains"
        },
        {
          "code" : "internalId",
          "valueCode" : "21307"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatesTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "temporallyRelatedInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipAccounting",
      "display" : "ActRelationshipAccounting",
      "definition" : "Codes that describe the relationship between an Act and a financial instrument such as a financial transaction, account or invoice element.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActRelationshipPosts"
        },
        {
          "code" : "internalId",
          "valueCode" : "20946"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "accountingFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "accounting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipPosts",
      "display" : "ActRelationshipAccounting",
      "definition" : "Codes that describe the relationship between an Act and a financial instrument such as a financial transaction, account or invoice element.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "synonymCode",
          "valueCode" : "_ActRelationshipAccounting"
        },
        {
          "code" : "internalId",
          "valueCode" : "20946"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "accountingFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "accounting"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipConditional",
      "display" : "ActRelationshipConditional",
      "definition" : "Specifies under what circumstances (target Act) the source-Act may, must, must not or has occurred",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20945"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "conditionedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "conditions"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "C________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "C________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationshipTemporallyPertains",
      "display" : "ActRelationshipTemporallyPertains",
      "definition" : "Abstract collector for ActRelationhsip types that relate two acts by their timing.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23581"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "AUTH",
      "display" : "authorized by",
      "definition" : "A relationship in which the target act authorizes or certifies the source act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14019"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "authorizationOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "authorization"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DH_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DH_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CAUS",
      "display" : "is etiology for",
      "definition" : "**Description:** An assertion that an act was the cause of another act.This is stronger and more specific than the support link. The source (cause) is typically an observation, but may be any act, while the target may be any act.\r\n\r\n**Examples:**\r\n\r\n *  a growth of Staphylococcus aureus may be considered the cause of an abscess\r\n *  contamination of the infusion bag was deemed to be the cause of the infection that the patient experienced\r\n *  lack of staff on the shift was deemed to be a supporting factor (proximal factor) causing the patient safety incident where the patient fell out of bed because the bed-sides had not been put up which caused the night patient to fall out of bed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10332"
        },
        {
          "code" : "appliesTo",
          "valueString" : "cause"
        },
        {
          "code" : "howApplies",
          "valueString" : "effect"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "cause"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "causeOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COMP",
      "display" : "has component",
      "definition" : "The target act is a component of the source act, with no semantics regarding composition or aggregation implied.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10318"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "componentOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "component"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "E________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "E________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COVBY",
      "display" : "covered by",
      "definition" : "A relationship in which the source act is covered by or is under the authority of a target act. A financial instrument such as an Invoice Element is covered by one or more specific instances of an Insurance Policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14894"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "coverageOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "coverage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DP_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DP_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DRIV",
      "display" : "is derived from",
      "definition" : "Associates a derived Act with its input parameters. E.G., an anion-gap observation can be associated as being derived from given sodium-, (potassium-,), chloride-, and bicarbonate-observations. The narrative content (Act.text) of a source act is wholly machine-derived from the collection of target acts.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10334"
        },
        {
          "code" : "appliesTo",
          "valueString" : "output parameter"
        },
        {
          "code" : "howApplies",
          "valueString" : "input parameter"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "derivation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "derivedFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DF_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DF_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ELNK",
      "display" : "episodeLink",
      "definition" : "Expresses an association that links two instances of the same act over time, indicating that the instance are part of the same episode, e.g. linking two condition nodes for episode of illness; linking two encounters for episode of encounter.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18865"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "linkedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "links"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BG_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BG_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EVID",
      "display" : "provides evidence for",
      "definition" : "Indicates that the target Act provides evidence in support of the action represented by the source Act. The target is not a 'reason' for the source act, but rather gives supporting information on why the source act is an appropriate course of action. Possible targets might be clinical trial results, journal articles, similar successful therapies, etc.\r\n\r\n*Rationale:* Provides a mechanism for conveying clinical justification for non-approved or otherwise non-traditional therapies.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21572"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EXACBY",
      "display" : "exacerbated by",
      "definition" : "**Description:**The source act is aggravated by the target act. (Example \"chest pain\" EXACBY \"exercise\")",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22827"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EXPL",
      "display" : "has explanation",
      "definition" : "This is the inversion of support. Used to indicate that a given observation is explained by another observation or condition.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10331"
        },
        {
          "code" : "howApplies",
          "valueString" : "explaining observation or condition"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "explanationFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "explanation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DI_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DI_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INTF",
      "display" : "interfered by",
      "definition" : "the target act documents a set of circumstances (events, risks) which prevent successful completion, or degradation of quality of, the source Act.\r\n\r\n*UsageNote:* This provides the semantics to document barriers to care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23597"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "interferesWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "interferedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "G________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "G________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ITEMSLOC",
      "display" : "items located",
      "definition" : "Items located",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "20841"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "itemStorageFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "itemStorage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DR_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DR_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "LIMIT",
      "display" : "limited by",
      "definition" : "A relationship that limits or restricts the source act by the elements of the target act. For example, an authorization may be limited by a financial amount (up to $500). Target Act must be in EVN.CRIT mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14896"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "limitationOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "limitation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DQ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DQ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "META",
      "display" : "has metadata",
      "definition" : "**Definition:** Indicates that the attributes and associations of the target act provide metadata (for example, identifiers, authorship, etc.) for the source act.\r\n\r\n**Constraint:**  Source act must have either a mood code that is not \"EVN\" (event) or its \"isCriterion\" attribute must set to \"true\". Target act must be an Act with a mood code of EVN and with isCriterionInd attribute set to \"true\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23111"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "metadataFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "metadata"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DZ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "AA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MFST",
      "display" : "is manifestation of",
      "definition" : "An assertion that a new observation may be the manifestation of another existing observation or action. This assumption is attributed to the same actor who asserts the manifestation. This is stronger and more specific than an inverted support link. For example, an agitated appearance can be asserted to be the manifestation (effect) of a known hyperthyroxia. This expresses that one might not have realized a symptom if it would not be a common manifestation of a known condition. The target (cause) may be any service, while the source (manifestation) must be an observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10333"
        },
        {
          "code" : "appliesTo",
          "valueString" : "manifestation"
        },
        {
          "code" : "howApplies",
          "valueString" : "cause"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "manifestation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "manifestationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DE_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DE_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NAME",
      "display" : "assigns name",
      "definition" : "Used to assign a \"name\" to a condition thread. Source is a condition node, target can be any service.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10336"
        },
        {
          "code" : "appliesTo",
          "valueString" : "condition thread"
        },
        {
          "code" : "howApplies",
          "valueString" : "name"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "assignedConditionName"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "conditionNamed"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DJ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DJ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OUTC",
      "display" : "has outcome",
      "definition" : "An observation that should follow or does actually follow as a result or consequence of a condition or action (sometimes called \"post-conditional\".) Target must be an observation as a goal, risk or any criterion. For complex outcomes a conjunction attribute (AND, OR, XOR) can be used. An outcome link is often inverted to describe an outcome assessment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10324"
        },
        {
          "code" : "appliesTo",
          "valueString" : "condition or action"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "howApplies",
          "valueString" : "outcome"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "outcomeOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "outcome"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "A________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "A________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PERT",
      "display" : "has pertinent information",
      "definition" : "This is a very unspecific relationship from one item of clinical information to another. It does not judge about the role the pertinent information plays.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10329"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any service"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "howApplies",
          "valueString" : "any service"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "pertainsTo"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "pertinentInformation"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "D________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "D________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PREV",
      "display" : "has previous instance",
      "definition" : "A relationship in which the target act is a predecessor instance to the source act. Generally each of these instances is similar, but no identical. In healthcare coverage it is used to link a claim item to a previous claim item that might have claimed for the same set of services.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Previous instance"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14018"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "successor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "predecessor"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REFR",
      "display" : "refers to",
      "definition" : "A relationship in which the target act is referred to by the source act. This permits a simple reference relationship that distinguishes between the referent and the referee.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14020"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "referencedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "reference"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DK_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DK_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REFV",
      "display" : "has reference values",
      "definition" : "Reference ranges are essentially descriptors of a class of result values assumed to be \"normal\", \"abnormal\", or \"critical.\" Those can vary by sex, age, or any other criterion. Source and target are observations, the target is in criterion mood. This link type can act as a trigger in case of alarms being triggered by critical results.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10335"
        },
        {
          "code" : "howApplies",
          "valueString" : "range"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "referenceRangeFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "referenceRange"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DL_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DL_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RELVBY",
      "display" : "relieved by",
      "definition" : "**Description:**The source act is wholly or partially alleviated by the target act. (Example \"chest pain\" RELVBY \"sublingual nitroglycerin administration\")",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22828"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SEQL",
      "display" : "is sequel",
      "definition" : "An act relationship indicating that the source act follows the target act. The source act should in principle represent the same kind of act as the target. Source and target need not have the same mood code (mood will often differ). The target of a sequel is called antecedent. Examples for sequel relationships are: revision, transformation, derivation from a prototype (as a specialization is a derivation of a generalization), followup, realization, instantiation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10337"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "sequel"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "sequelTo"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "B________"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "B________"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SPRT",
      "display" : "has support",
      "definition" : "Used to indicate that an existing service is suggesting evidence for a new observation. The assumption of support is attributed to the same actor who asserts the observation. Source must be an observation, target may be any service (e.g., to indicate a status post).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10330"
        },
        {
          "code" : "howApplies",
          "valueString" : "supporting evidence"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "supportOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "support"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUBJ",
      "display" : "has subject",
      "definition" : "Relates an Act to its subject Act that the first Act is primarily concerned with.\r\n\r\nExamples\r\n\r\n1.  The first Act may be a ControlAct manipulating the subject Act\r\n2.  The first act is a region of interest (ROI) that defines a region within the subject Act.\r\n3.  The first act is a reporting or notification Act, that echos the subject Act for a specific new purpose.\r\n\r\nConstraints\r\n\r\nAn Act may have multiple subject acts.\r\n\r\nRationale\r\n\r\nThe ActRelationshipType \"has subject\" is similar to the ParticipationType \"subject\", Acts that primarily operate on physical subjects use the Participation, those Acts that primarily operate on other Acts (other information) use the ActRelationship.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13971"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "subjectOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "subject"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUMM",
      "display" : "summarized by",
      "definition" : "An act that contains summary values for a list or set of subordinate acts. For example, a summary of transactions for a particular accounting period.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "15988"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "summaryOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "summary"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DM_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DM_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "VALUE",
      "display" : "has value",
      "definition" : "**Description:**Indicates that the target Act represents the result of the source observation Act.\r\n\r\n**FormalConstraint:** Source Act must be an Observation or specialization there-of. Source Act must not have the value attribute specified\r\n\r\n**UsageNote:** This relationship allows the result of an observation to be fully expressed as RIM acts as opposed to being embedded in the value attribute. For example, sending a Document act as the result of an imaging observation, sending a list of Procedures and/or other acts as the result of a medical history observation.\r\n\r\nThe valueNegationInd attribute on the source Act has the same semantics of \"negated finding\" when it applies to the target of a VALUE ActRelationship as it does to the value attribute. On the other hand, if the ActRelationship.negationInd is true for a VALUE ActRelationship, that means the specified observation does not have the indicated value but does not imply a negated finding. Because the semantics are extremely close, it is recommended that Observation.valueNegationInd be used, not ActRelationship.negationInd.\r\n\r\n**OpenIssue:** The implications of negationInd on ActRelationship and the valueNegationind on Observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23319"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ART"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CTRLV",
      "display" : "has control variable",
      "definition" : "A relationship from an Act to a Control Variable. For example, if a Device makes an Observation, this relates the Observation to its Control Variables documenting the device's settings that influenced the observation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17902"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "controlVariableFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "controlVariable"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MBR",
      "display" : "has member",
      "definition" : "The target Acts are aggregated by the source Act. Target Acts may have independent existence, participate in multiple ActRelationships, and do not contribute to the meaning of the source.\r\n\r\n**UsageNotes:** This explicitly represents the conventional notion of aggregation. The target Act is part of a collection of Acts (no implication is made of cardinality, a source of Acts may contain zero, one, or more member target Acts).\r\n\r\nIt is expected that this will be primarily used with \\_ActClassRecordOrganizer, BATTERY, and LIST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "This explicitly represents the conventional notion of aggregation.  The target Act is part of a collection of Acts (no implication is made of cardinality, a source of Acts may contain zero, one, or more member target Acts). It is expected that this will be primarily used with _ActClassRecordOrganizer, BATTERY, and LIST"
        },
        {
          "code" : "internalId",
          "valueCode" : "23594"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "memberOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "hasMember"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PART",
      "display" : "has part",
      "definition" : "The source Act is a composite of the target Acts. The target Acts do not have an existence independent of the source Act.\r\n\r\n*UsageNote:* In UML 1.1, this is a \"composition\" defined as:  \r\n*\"A form of aggregation with strong ownership and coincident lifetime as part of the whole. Parts with non-fixed multiplicity may be created after the composite itself, but once created they live and die with it (i.e., they share lifetimes). Such parts can also be explicitly removed before the death of the composite. Composition may be recursive.\"*",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23596"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "isPartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "hasPart"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "COMP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASEAE",
      "display" : "starts after start of, ends after end of",
      "definition" : "The source Act starts after start of the target Act and ends after end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSEBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23583"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOfEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOfEndsAfterAndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAE",
      "display" : "ends after end of",
      "definition" : "A relationship in which the source act ends after the target act ends.\r\n\r\n*UsageNote:* Inverse code is **EBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23081"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ECW",
      "display" : "ends concurrent with",
      "definition" : "A relationship in which the source act's effective time ends with the end of the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23033"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsConcurrentlyWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsConcurrentlyWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ENE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAS",
      "display" : "starts after start of",
      "definition" : "The source Act starts after the start of the target Act (i.e. if we say \"ActOne SAS ActTwo\", it means that ActOne starts after the start of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SBS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21308"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EAS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASORSCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EAEORECW",
      "display" : "ends after or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time ends after or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EBEORECW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23646"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ECWS",
      "display" : "ends concurrent with start of",
      "definition" : "The source Act ends when the target act starts (i.e. if we say \"ActOne ECWS ActTwo\", it means that ActOne ends when ActTwo starts, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SCWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23463"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EASORECWS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBSORECWS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ENS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEBE",
      "display" : "starts before start of, ends before end of",
      "definition" : "The source Act starts before the start of the target Act, and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23590"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOfEndsAfterAndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOfEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBE",
      "display" : "ends before end of",
      "definition" : "The source Act ends before the end of the target Act (i.e. if we say \"ActOne EBE ActTwo\", it means that ActOne ends before the end of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **EAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23461"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBEORECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBS",
      "display" : "ends before start of",
      "definition" : "A relationship in which the source act ends before the target act starts.\r\n\r\n*UsageNote:* Inverse code is **SAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23078"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EBSORECWS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CONCURRENT",
      "display" : "concurrent with",
      "definition" : "A relationship in which the source act's effective time is the same as the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23032"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "isConcurrentWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "isConcurrentWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSECWE",
      "display" : "starts before start of, ends with",
      "definition" : "The source Act starts before the start of the target Act, and ends with the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASECWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23591"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOfEndsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOfEndsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "ECW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEASEBE",
      "display" : "contains start of, ends before end of",
      "definition" : "The source Act contains the start of the target Act, and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SASSBEEAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23589"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startAfterStartOfContainsEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "containsStartOfEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EDU"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWSEBE",
      "display" : "starts with. ends before end of",
      "definition" : "The source Act starts with.the target Act and ends before the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SCWSEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23593"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsWithEndsAfterEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsWithEndsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "EDU"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OCCR",
      "display" : "occurrence",
      "definition" : "The source act is a single occurrence of a repeatable target act. The source and target act can be in any mood on the \"completion track\" but the source act must be as far as or further along the track than the target act (i.e., the occurrence of an intent can be an event but not vice versa).",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "is occurrence of"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11614"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "occurrence"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "occurrenceOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OREF",
      "display" : "references order",
      "definition" : "Relates either an appointment request or an appointment to the order for the service being scheduled.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11628"
        },
        {
          "code" : "appliesTo",
          "valueString" : "ActMood = ARQ or APT and ActMood = ORD"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "referencedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "referencedOrder"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BAB______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BAB______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCH",
      "display" : "schedules request",
      "definition" : "Associates a specific time (and associated resources) with a scheduling request or other intent.",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "schedules"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11627"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "requestedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "scheduleRequest"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BAC______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BAC______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "FLFS"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ACTIMM",
      "display" : "active immunization against",
      "definition" : "**Description:** The source act is intended to provide active immunity against the effects of the target act (the target act describes an infectious disease)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23305"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "activelyImmunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IMM"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PASSIMM",
      "display" : "passive immunization against",
      "definition" : "**Description:** The source act is intended to provide passive immunity against the effects of the target act (the target act describes an infectious disease).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23306"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "passivelyImmunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "IMM"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "STEP",
      "display" : "has step",
      "definition" : "A collection of sub-services as steps or subtasks performed for the source service. Services may be performed sequentially or concurrently.\r\n\r\n*UsageNotes:* Sequence of steps may be indicated by use of \\_ActRelationshipTemporallyPertains, as well as via ActRelationship.sequenceNumber, ActRelationship.pauseQuantity, Target.priorityCode.\r\n\r\n*OpenIssue:* Need Additional guidelines on when each approach should be used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Sequence of steps may be indicated by use of _ActRelationshipTemporallyPertains, as well as via  ActRelationship.sequenceNumber, ActRelationship.pauseQuantity, Target.priorityCode."
        },
        {
          "code" : "internalId",
          "valueCode" : "23595"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any _ActMoodCompletionTrack"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "isStepOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "hasStep"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "MBR"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RCVY",
      "display" : "recovers",
      "definition" : "**Definition:** The source act is performed to recover from the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22189"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "recoveredFrom"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "recovers"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "MITGT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "_ActRelationsipObjective",
      "display" : "Act Relationsip Objective",
      "definition" : "The target act is a desired outcome of the source act. Source is any act (typically an intervention). Target must be an observation in criterion mood.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21384"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "goalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "goal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "AC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "AC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GOAL",
      "display" : "has goal",
      "definition" : "A goal that one defines given a patient's health condition. Subsequently planned actions aim to meet that goal. Source is an observation or condition node, target must be an observation in goal mood.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10325"
        },
        {
          "code" : "appliesTo",
          "valueString" : "observation, condition"
        },
        {
          "code" : "howApplies",
          "valueString" : "goal"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "goalOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "goal"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "AB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "AB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RISK",
      "display" : "has risk",
      "definition" : "A noteworthy undesired outcome of a patient's condition that is either likely enough to become an issue or is less likely but dangerous enough to be addressed.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10328"
        },
        {
          "code" : "appliesTo",
          "valueString" : "observation, condition"
        },
        {
          "code" : "howApplies",
          "valueString" : "risk"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "riskOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "risk"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "AA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "AA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OUTC"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EDU",
      "display" : "ends during",
      "definition" : "A relationship in which the source act ends within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBEEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23080"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "encompassesEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBEEAE",
      "display" : "contains end of",
      "definition" : "The source Act contains the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **EDU**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23587"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "containsEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASEAE"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEAS",
      "display" : "contains start of",
      "definition" : "The source Act contains the start of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SDU**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23586"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "containsStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCW",
      "display" : "starts concurrent with",
      "definition" : "A relationship in which the source act's effective time starts with the start of the target act's effective time.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23036"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsConcurrentlyWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsConcurrentlyWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASORSCW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSORSCW"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SNS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWE",
      "display" : "starts concurrent with end of",
      "definition" : "The source Act starts when the target act ends (i.e. if we say \"ActOne SCWE ActTwo\", it means that ActOne starts when ActTwo ends, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **SBSECWS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23462"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAEORSCWE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SNE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SDU",
      "display" : "starts during",
      "definition" : "A relationship in which the source act starts within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBSEAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23082"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "encompassesStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "OVERLAP"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "USE",
      "display" : "uses",
      "definition" : "Indicates that the source act makes use of (or will make use of) the information content of the target act.\r\n\r\n*UsageNotes:* A usage relationship only makes sense if the target act is authored and occurs independently of the source act. Otherwise a simpler relationship such as COMP would be appropriate.\r\n\r\n*Rationale:* There is a need when defining a clinical trial protocol to indicate that the protocol makes use of other protocol or treatment specifications. This is stronger than the assertion of \"references\". References may exist without usage, and in a clinical trial protocol is common to assert both: what other specifications does this trial use and what other specifications does it merely reference.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "A usage relationship only makes sense if the target act is authored and occurs independently of the source act.  Otherwise a simpler relationship such as COMP would be appropriate."
        },
        {
          "code" : "internalId",
          "valueCode" : "23102"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "usedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "uses"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DKA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DKA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "REFR"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "BLOCK",
      "display" : "blocks",
      "definition" : "**Definition:** The source act is performed to block the effects of the target act. This act relationship should be used when describing near miss type incidents where potential harm could have occurred, but the action described in the source act blocked the potential harmful effects of the incident actually occurring.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22188"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "blockedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "blocks"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DIAG",
      "display" : "diagnoses",
      "definition" : "**Description:** The source act is intended to help establish the presence of a (an adverse) situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21644"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "diagnosedBy"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "IMM",
      "display" : "immunization against",
      "definition" : "**Description:** The source act is intented to provide immunity against the effects of the target act (the target act describes an infectious disease)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23304"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "immunizedAgainst"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MITGT",
      "display" : "mitigates",
      "definition" : "The source act removes or lessens the occurrence or effect of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "19986"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "mitigatedBy"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "mitigates"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "CAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "CAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PRYLX",
      "display" : "prophylaxis of",
      "definition" : "**Description:** The source act is intended to reduce the risk of of an adverse situation to emerge as described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23303"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "prophylaxisOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "TREAT",
      "display" : "treats",
      "definition" : "**Description:** The source act is intended to improve a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23307"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "treatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "RSON"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SAE",
      "display" : "starts after end of",
      "definition" : "A relationship in which the source act starts after the target act ends.\r\n\r\n*UsageNote:* Inverse code is **EBS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22043"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeStartof"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAEORSCWE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DURING",
      "display" : "occurs during",
      "definition" : "A relationship in which the source act's effective time is wholly within the target act's effective time (including end points, as defined in the act's effective times)\r\n\r\n*UsageNote:* Inverse code is **SBSEAE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23034"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "spansOccurrenceOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "occursDuring"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASECWE",
      "display" : "starts after start of, ends with",
      "definition" : "The source Act starts after start of the target Act, and ends with the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSECWE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23584"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOfEndsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOfEndsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SASSBEEAS",
      "display" : "start after start of, contains end of",
      "definition" : "The source Act start after the start of the target Act, and contains the end of the target Act.\r\n\r\n*UsageNote:* Inverse code is **SBSEASEBE**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23585"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "containsStartOfEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startAfterStartOfContainsEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SASEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SDU"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBEORECW",
      "display" : "ends before or concurrent with end of",
      "definition" : "A relationship in which the source act's effective time ends before or concurrent with the end of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EAEORECW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23648"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsAfterOrConcurrentWithEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeOrConcurrentWithEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSORSCW",
      "display" : "starts before or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time starts before or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is SASORSCW",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23647"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBSEAE",
      "display" : "contains time of",
      "definition" : "The source Act contains the time of the target Act.\r\n\r\n*UsageNote:* Inverse code is **DURING**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23588"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "occursDuring"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "containsTimeOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEAS"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SCWSEAE",
      "display" : "starts with, ends after end of",
      "definition" : "The source Act starts with the target Act, and ends after the end of the target Act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23592"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsWithEndsBeforeEndOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsWithEndsAfterEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEEAE"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SCW"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OVERLAP",
      "display" : "overlaps with",
      "definition" : "A relationship in which the source act's effective time overlaps the target act's effective time in any way.\r\n\r\n*UsageNote:* This code is reflexive. Therefore its inverse code is itself.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23035"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "overlapsWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "overlapsWith"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEORSCWE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBE",
      "display" : "starts before end of",
      "definition" : "The source Act starts before the end of the target Act (i.e. if we say \"ActOne SBE ActTwo\", it means that ActOne starts before the end of ActTwo, therefore ActOne is the source and ActTwo is the target).\r\n\r\n*UsageNote:* Inverse code is **EAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23460"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsAfterStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeEndOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBEORSCWE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "EBSORECWS",
      "display" : "ends before or concurrent with start of",
      "definition" : "A relationship in which the source act's effective time ends before or concurrent with the start of the target act's effective time.\r\n\r\n*Usage Note:* Inverse code is EASORECWS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23649"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "endsAfterOrConcurrentWithStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "endsBeforeOrConcurrentWithStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSEBE"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SBS",
      "display" : "starts before start of",
      "definition" : "A relationship in which the source act begins before the target act begins.\r\n\r\n*UsageNote:* Inverse code is **SAS**",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23076"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "startsAfterStartOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "startsBeforeStartOf"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SBSORSCW"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "APND",
      "display" : "is appendage",
      "definition" : "An addendum (source) to an existing service object (target), containing supplemental information. The addendum is itself an original service object linked to the supplemented service object. The supplemented service object remains in place and its content and status are unaltered.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10339"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "appendageOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "appendage"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BJ_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BJ_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "BSLN",
      "display" : "has baseline",
      "definition" : "Indicates that the target observation(s) provide an initial reference for the source observation or observation group.\r\n\r\n*UsageConstraints:* Both source and target must be Observations or specializations thereof.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23101"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "baselineFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "baseline"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BG_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BG_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "COMPLY",
      "display" : "complies with",
      "definition" : "**Description:**The source act complies with, adheres to, conforms to, or is permissible under (in whole or in part) the policy, contract, agreement, law, conformance criteria, certification guidelines or requirement conveyed by the target act.\r\n\r\nExamples for compliance relationships are: audits of adherence with a security policy, certificate of conformance to system certification requirements, or consent directive in compliance with or permissible under a privacy policy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22626"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "compliesWith"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "compliance"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BO_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BO_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DOC",
      "display" : "documents",
      "definition" : "The source act documents the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11609"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "documentation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "documentationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BH_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BH_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "FLFS",
      "display" : "fulfills",
      "definition" : "The source act fulfills (in whole or in part) the target act. Source act must be in a mood equal or more actual than the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10342"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "fulfillment"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "inFulfillmentOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BA_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BA_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GEN",
      "display" : "has generalization",
      "definition" : "The generalization relationship can be used to express categorical knowledge about services (e.g., amilorid, triamterene, and spironolactone have the common generalization potassium sparing diuretic).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10348"
        },
        {
          "code" : "appliesTo",
          "valueString" : "specialization"
        },
        {
          "code" : "howApplies",
          "valueString" : "generalization"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "specialization"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "generalization"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BC_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BC_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "GEVL",
      "display" : "evaluates (goal)",
      "definition" : "A goal-evaluation links an observation (intent or actual) to a goal to indicate that the observation evaluates the goal. Given the goal and the observation, a \"goal distance\" (e.g., goal to observation) can be \"calculated\" and need not be sent explicitly.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10346"
        },
        {
          "code" : "appliesTo",
          "valueString" : "evaluation"
        },
        {
          "code" : "howApplies",
          "valueString" : "goal"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "evaluation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "evaluationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BD_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BD_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "INST",
      "display" : "instantiates (master)",
      "definition" : "Used to capture the link between a potential service (\"master\" or plan) and an actual service, where the actual service instantiates the potential service. The instantiation may override the master's defaults.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10341"
        },
        {
          "code" : "appliesTo",
          "valueString" : "instance"
        },
        {
          "code" : "howApplies",
          "valueString" : "master"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "instantiation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "definition"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BB_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BB_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MOD",
      "display" : "modifies",
      "definition" : "Definition: Used to link a newer version or 'snapshot' of a business object (source) to an older version or 'snapshot' of the same business object (target).\r\n\r\n*Usage:*The identifier of the Act should be the same for both source and target. If the identifiers are distinct, RPLC should be used instead.\r\n\r\nName from source to target = \"modifiesPrior\"\r\n\r\nName from target to source = \"modifiesByNew\"",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21638"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTCH",
      "display" : "matches (trigger)",
      "definition" : "A trigger-match links an actual service (e.g., an observation or procedure that took place) with a service in criterion mood. For example if the trigger is \"observation of pain\" and pain is actually observed, and if that pain-observation caused the trigger to fire, that pain-observation can be linked with the trigger.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10345"
        },
        {
          "code" : "appliesTo",
          "valueString" : "matching service"
        },
        {
          "code" : "howApplies",
          "valueString" : "trigger"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "match"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "matchOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BF_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BF_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "OPTN",
      "display" : "has option",
      "definition" : "A relationship between a source Act that provides more detailed properties to the target Act.\r\n\r\nThe source act thus is a specialization of the target act, but instead of mentioning all the inherited properties it only mentions new property bindings or refinements.\r\n\r\nThe typical use case is to specify certain alternative variants of one kind of Act. The priorityNumber attribute is used to weigh refinements as preferred over other alternative refinements.\r\n\r\nExample: several routing options for a drug are specified as one SubstanceAdministration for the general treatment with attached refinements for the various routing options.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10347"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "optionFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "option"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BN_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BN_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RCHAL",
      "display" : "re-challenge",
      "definition" : "**Description:**A relationship in which the target act is carried out to determine whether an effect attributed to the source act can be recreated.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22044"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "REV",
      "display" : "reverses",
      "definition" : "A relationship between a source Act that seeks to reverse or undo the action of the prior target Act.\r\n\r\nExample: A posted financial transaction (e.g., a debit transaction) was applied in error and must be reversed (e.g., by a credit transaction) the credit transaction is identified as an undo (or reversal) of the prior target transaction.\r\n\r\nConstraints: the \"completion track\" mood of the target Act must be equally or more \"actual\" than the source act. I.e., when the target act is EVN the source act can be EVN, or any INT. If the target act is INT, the source act can be INT.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "14898"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "reversal"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "reversalOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BK_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BK_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "RPLC",
      "display" : "replaces",
      "definition" : "A replacement source act replaces an existing target act. The state of the target act being replaced becomes obselete, but the act is typically still retained in the system for historical reference. The source and target must be of the same type.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10338"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "replacement"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "replacementOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BI_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BI_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SUCC",
      "display" : "succeeds",
      "definition" : "**Definition:** A new act that carries forward the intention of the original act, but does not completely replace it. The status of the predecessor act must be 'completed'. The original act is the target act and the successor is the source act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11616"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "successor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "predecessor"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BIA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BIA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "UPDT",
      "display" : "updates (condition)",
      "definition" : "A condition thread relationship specifically links condition nodes together to form a condition thread. The source is the new condition node and the target links to the most recent node of the existing condition thread.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10340"
        },
        {
          "code" : "appliesTo",
          "valueString" : "new head of thread"
        },
        {
          "code" : "howApplies",
          "valueString" : "old head of thread"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "update"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "updateOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BE_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BE_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "XCRPT",
      "display" : "Excerpts",
      "definition" : "The source is an excerpt from the target.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18660"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "excerpt"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "excerptFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BM_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BM_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "XFRM",
      "display" : "transformation",
      "definition" : "Used when the target Act is a transformation of the source Act. (For instance, used to show that a CDA document is a transformation of a DICOM SR document.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "11624"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "transformation"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "transformationOf"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BL_______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BL_______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SEQL"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SPRTBND",
      "display" : "has bounded support",
      "definition" : "A specialization of \"has support\" (SPRT), used to relate a secondary observation to a Region of Interest on a multidimensional observation, if the ROI specifies the true boundaries of the secondary observation as opposed to only marking the approximate area. For example, if the start and end of an ST elevation episode is visible in an EKG, this relation would indicate the ROI bounds the \"ST elevation\" observation -- the ROI defines the true beginning and ending of the episode. Conversely, if a ROI simply contains ST elevation, but it does not define the bounds (start and end) of the episode, the more general \"has support\" relation is used. Likewise, if a ROI on an image defines the true bounds of a \"1st degree burn\", the relation \"has bounded support\" is used; but if the ROI only points to the approximate area of the burn, the general \"has support\" relation is used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17899"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "boundedSupportOf"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "boundedSupport"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DAA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DAA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SPRT"
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ARR",
      "display" : "arrival",
      "definition" : "The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act entered into the source Act by means of the target Transportation act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17911"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "arrivalFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "arrivedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EAAB_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EAAB_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "STEP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "DEP",
      "display" : "departure",
      "definition" : "The relationship that links to a Transportation Act (target) from another Act (source) indicating that the subject of the source Act departed from the source Act by means of the target Transportation act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "17912"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : false
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "departureFor"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "departedBy"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "EAAC_____"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "EAAC_____"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "STEP"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "QUALF",
      "display" : "has qualifier",
      "definition" : "The target observation qualifies (refines) the semantics of the source observation.\r\n\r\n*UsageNote:* This is not intended to replace concept refinement and qualification via vocabulary. It is used when there are multiple components which together provide the complete understanding of the source Act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23598"
        },
        {
          "code" : "appliesTo",
          "valueString" : "any Act"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "qualifies"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "hasQualifier"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "DBA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "DBA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "SUBJ"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "ADJUNCT",
      "display" : "adjunctive treatment",
      "definition" : "**Description:** The source act is intended to offer an additional treatment for the management or cure of a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature. It is not a requirement that the non-adjunctive treatment is explicitly specified.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23310"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "adjunctiveTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "MTREAT",
      "display" : "maintenance treatment",
      "definition" : "**Description:** The source act is intended to provide long term maintenance improvement or management of a pre-existing adverse situation described by the target act. This is not limited to diseases but can apply to any adverse situation or condition of medical or technical nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23308"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "maintenanceTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PALLTREAT",
      "display" : "palliates",
      "definition" : "**Description:** The source act is intended to provide palliation for the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "23309"
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "palliativeTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "SYMP",
      "display" : "symptomatic relief",
      "definition" : "**Description:** The source act is intented to provide symptomatic relief for the effects of the target act.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21645"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "symptomaticTreatmentFor"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "TREAT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : true
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "VRXCRPT",
      "display" : "Excerpt verbatim",
      "definition" : "The source is a direct quote from the target.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "18661"
        },
        {
          "code" : "isDocumentCharacteristic",
          "valueBoolean" : true
        },
        {
          "code" : "Name:Act:inboundRelationship:ActRelationship",
          "valueCode" : "verbatimExcerpt"
        },
        {
          "code" : "Name:Act:outboundRelationship:ActRelationship",
          "valueCode" : "verbatimExcerptFrom"
        },
        {
          "code" : "Sort:Act:inboundRelationship:ActRelationship",
          "valueCode" : "BMA______"
        },
        {
          "code" : "Sort:Act:outboundRelationship:ActRelationship",
          "valueCode" : "BMA______"
        },
        {
          "code" : "subsumedBy",
          "valueCode" : "XCRPT"
        },
        {
          "code" : "conductible",
          "valueBoolean" : false
        },
        {
          "code" : "Name:ActRelationship:source:Act",
          "valueString" : "&"
        },
        {
          "code" : "Name:ActRelationship:target:Act",
          "valueString" : "&"
        }
      ]
    }
  ]
}

```
