# equipmentStateIndicator - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **equipmentStateIndicator**

## CodeSystem: equipmentStateIndicator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0942 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EquipmentStateIndicator |
| *Other Identifiers:*OID:2.16.840.1.113883.18.444 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated laboratory instrument. Used in HL7 Version 2.x messaging in the INV segment. 

 
Underlying Master Code System for V2 table 0942 (Equipment State Indicator Type Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [V2Table0942VersionMaster](ValueSet-v2-0942.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0942",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0942",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.444"
    }
  ],
  "version" : "2.0.0",
  "name" : "EquipmentStateIndicator",
  "title" : "equipmentStateIndicator",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code sytem of cocepts that specify the type of measurement of the state of an automated laboratory instrument. Used in HL7 Version 2.x messaging in the INV segment.",
  "purpose" : "Underlying Master Code System for V2 table 0942 (Equipment State Indicator Type Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0942",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6749",
      "code" : "EB",
      "display" : "Emergency input buffer current capacity",
      "definition" : "Current capacity of an emergency input specimen buffer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6750",
      "code" : "IB",
      "display" : "Input buffer current capacity",
      "definition" : "Current capacity of a regular input specimen buffer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6751",
      "code" : "IC",
      "display" : "Instrument current processing capacity",
      "definition" : "Current processing capacity of the instrument",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6752",
      "code" : "OB",
      "display" : "Output buffer current capacity",
      "definition" : "Current capacity of an output specimen buffer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6753",
      "code" : "TA",
      "display" : "Current test availability",
      "definition" : "Current test availability",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
