# limitationTypeCode - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **limitationTypeCode**

## CodeSystem: limitationTypeCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0940 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:LimitationTypeCode |
| *Other Identifiers:*OID:2.16.840.1.113883.18.443 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the type of limitation. Used in HL7 Version 2.x messaging in the DPS segment. 

 
Underlying Master Code System for V2 table 0940 (Limitation Type Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSVSLimitationTypeCode](ValueSet-v2-0940.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0940",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0940",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.443"
    }
  ],
  "version" : "2.0.0",
  "name" : "LimitationTypeCode",
  "title" : "limitationTypeCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the type of limitation.  Used in HL7 Version 2.x messaging in the DPS segment.",
  "purpose" : "Underlying Master Code System for V2 table 0940 (Limitation Type Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0940",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6745",
      "code" : "LCP",
      "display" : "Limited Coverage Policy",
      "definition" : "Limited Coverage Policy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6746",
      "code" : "NFDA",
      "display" : "Non-FDA Approved Diagnositic Procedure",
      "definition" : "Non-FDA Approved Diagnositic Procedure",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6747",
      "code" : "FLDP",
      "display" : "Frequency Limited Diagnostics Procedure",
      "definition" : "Frequency Limited Diagnostics Procedure",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6748",
      "code" : "NT",
      "display" : "New Test - Limited Diagnostic History",
      "definition" : "New Test - Limited Diagnostic History",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
