# rootCause - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **rootCause**

## CodeSystem: rootCause 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0914 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RootCause |
| *Other Identifiers:*OID:2.16.840.1.113883.18.421 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the root cause. Used in HL7 Version 2.x messaging in the OBX segment. 

 
Underlying Master Code System for V2 table 0914 (Root Cause) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSRootCause](ValueSet-v2-0914.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0914",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0914",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.421"
    }
  ],
  "version" : "2.0.0",
  "name" : "RootCause",
  "title" : "rootCause",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the root cause.  Used in HL7 Version 2.x messaging in the OBX segment.",
  "purpose" : "Underlying Master Code System for V2 table 0914 (Root Cause)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0914",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6619",
      "code" : "AP",
      "display" : "Analysis Process",
      "definition" : "Analysis Process",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Enter (AP) when ANALYSIS PROCESS is the reason due to:\r\n• Product or supply failure (reagents, calibrators, QC material)\r\n• Equipment or instrumentation failure"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Enter (AP) when ANALYSIS PROCESS is the reason due to:\r\n• Product or supply failure (reagents, calibrators, QC material)\r\n• Equipment or instrumentation failure"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Enter (AP) when ANALYSIS PROCESS is the reason due to:\r\n• Product or supply failure (reagents, calibrators, QC material)\r\n• Equipment or instrumentation failure"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6620",
      "code" : "IM",
      "display" : "Information Management",
      "definition" : "Information Management",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Enter (IM) when INFORMATION MANAGEMENT is the reason due to:\r\n• Database or Programming issues\r\n• Overriding of test results\r\n• Inaccurate calculations\r\n• Inaccurate flagging, reference ranges, units of measure\r\n• Incomplete/inaccurate transmission of test results\r\n• Other"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Enter (IM) when INFORMATION MANAGEMENT is the reason due to:\r\n• Database or Programming issues\r\n• Overriding of test results\r\n• Inaccurate calculations\r\n• Inaccurate flagging, reference ranges, units of measure\r\n• Incomplete/inaccurate transmission of test results\r\n• Other"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Enter (IM) when INFORMATION MANAGEMENT is the reason due to:\r\n• Database or Programming issues\r\n• Overriding of test results\r\n• Inaccurate calculations\r\n• Inaccurate flagging, reference ranges, units of measure\r\n• Incomplete/inaccurate transmission of test results\r\n• Other"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6621",
      "code" : "L",
      "display" : "Laboratory",
      "definition" : "Laboratory",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Enter (L) when LABORATORY is the reason due to:<p>• Data Entry error<p>• Testing/Technical error<p>• Repeat testing causing change to test result"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Enter (L) when LABORATORY is the reason due to:<p>â¢ Data Entry error<p>â¢ Testing/Technical error<p>â¢ Repeat testing causing change to test result"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Enter (L) when LABORATORY is the reason due to:\r\n• Data Entry error\r\n• Testing/Technical error\r\n• Repeat testing causing change to test result"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6622",
      "code" : "NA",
      "display" : "Not Applicable",
      "definition" : "Not Applicable",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Enter (NA) when NOT-APPLICABLE is the reason due to:\r\n• If no revisions performed or \r\n• unable to determine reason for revision\r\nNote:  Do not use NA if result code status is not corrected (revised) or if a preliminary release of results with a correction (revision)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Enter (NA) when NOT-APPLICABLE is the reason due to:\r\n• If no revisions performed or \r\n• unable to determine reason for revision\r\nNote:  Do not use NA if result code status is not corrected (revised) or if a preliminary release of results with a correction (revision)"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Enter (NA) when NOT-APPLICABLE is the reason due to:\r\n• If no revisions performed or\r\n• unable to determine reason for revision\r\nNote: Do not use NA if result code status is not corrected (revised) or if a preliminary release of results with a correction (revision)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6623",
      "code" : "PD",
      "display" : "Placer Data",
      "definition" : "Placer Data",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Enter (PD) when new or changed PLACER DATA information is the reason due to:\r\n• Changed patient demographics or\r\n• Result code data provided by the client on the requisition or specimen manifest that will be entered during order entry (i.e. Previous Biopsy Date, Clinical Information, Source, etc...)"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Enter (PD) when new or changed PLACER DATA information is the reason due to:\r\n• Changed patient demographics or\r\n• Result code data provided by the client on the requisition or specimen manifest that will be entered during order entry (i.e. Previous Biopsy Date, Clinical Information, Source, etc...)"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Enter (PD) when new or changed PLACER DATA information is the reason due to:\r\n• Changed patient demographics or\r\n• Result code data provided by the client on the requisition or specimen manifest that will be entered during order entry (i.e. Previous Biopsy Date, Clinical Information, Source, etc...)"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
