# confidentiality - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **confidentiality**

## CodeSystem: confidentiality 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0907 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Confidentiality |
| *Other Identifiers:*OID:2.16.840.1.113883.18.418 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying the confidentiality for the shipment. Used in HL7 Version 2.x messaging in the SHP segment. 

 
Underlying Master Code System for V2 table 0907 (Confidentiality) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSConfidentiality](ValueSet-v2-0907.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0907",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0907",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.418"
    }
  ],
  "version" : "2.0.0",
  "name" : "Confidentiality",
  "title" : "confidentiality",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the confidentiality for the shipment.  Used in HL7 Version 2.x messaging in the SHP segment.",
  "purpose" : "Underlying Master Code System for V2 table 0907 (Confidentiality)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0907",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6545",
      "code" : "B",
      "display" : "Business - Since the service class can represent knowledge structures that may be considered a trade or business secret, there is sometimes (though rarely) the need to flag those items as of business level confidentiality.  However, no patient related inf",
      "definition" : "Business – Since the service class can represent knowledge structures that may be considered a trade or business secret, there is sometimes (though rarely) the need to flag those items as of business level confidentiality.  However, no patient related information may ever be of this confidentiality level.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6546",
      "code" : "D",
      "display" : "Clinician - Only clinicians may see this item, billing and administration persons can not access this item without special permission.",
      "definition" : "Clinician - Only clinicians may see this item, billing and administration persons can not access this item without special permission.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6547",
      "code" : "I",
      "display" : "Individual - Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor typed code).",
      "definition" : "Individual - Access only to individual persons who are mentioned explicitly as actors of this service and whose actor type warrants that access (cf. to actor typed code).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6548",
      "code" : "L",
      "display" : "Low - No patient record item can be of low confidentiality.  However, some service objects are not patient related and therefore may have low confidentiality.",
      "definition" : "Low - No patient record item can be of low confidentiality.  However, some service objects are not patient related and therefore may have low confidentiality.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6549",
      "code" : "N",
      "display" : "Normal - Normal confidentiality rules (according to good health care practice) apply, that is, only authorized individuals with a legitimate medical or business need may access this item.",
      "definition" : "Normal - Normal confidentiality rules (according to good health care practice) apply, that is, only authorized individuals with a legitimate medical or business need may access this item.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6550",
      "code" : "R",
      "display" : "Restricted - Restricted access, e.g. only to providers having a current care relationship to the patient.",
      "definition" : "Restricted - Restricted access, e.g. only to providers having a current care relationship to the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6551",
      "code" : "V",
      "display" : "Very restricted - Very restricted access as declared by the Privacy Officer of the record holder.",
      "definition" : "Very restricted - Very restricted access as declared by the Privacy Officer of the record holder.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6552",
      "code" : "ETH",
      "display" : "Substance abuse related - Alcohol/drug-abuse related item",
      "definition" : "Substance abuse related - Alcohol/drug-abuse related item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6553",
      "code" : "HIV",
      "display" : "HIV Related - HIV and AIDS related item",
      "definition" : "HIV Related - HIV and AIDS related item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6554",
      "code" : "PSY",
      "display" : "Psychiatry related - Psychiatry related item",
      "definition" : "Psychiatry related - Psychiatry related item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6555",
      "code" : "SDV",
      "display" : "Sexual and domestic violence related - Sexual assault / domestic violence related item",
      "definition" : "Sexual and domestic violence related - Sexual assault / domestic violence related item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6556",
      "code" : "C",
      "display" : "Celebrity - Celebrities are people of public interest (VIP) including employees, whose information require special protection.",
      "definition" : "Celebrity - Celebrities are people of public interest (VIP) including employees, whose information require special protection.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6557",
      "code" : "S",
      "display" : "Sensitive - Information for which the patient seeks heightened confidentiality.  Sensitive information is not to be shared with family members.  Information reported by the patient about family members is sensitive by default.  Flag can be set or cleared",
      "definition" : "Sensitive – Information for which the patient seeks heightened confidentiality.  Sensitive information is not to be shared with family members.  Information reported by the patient about family members is sensitive by default.  Flag can be set or cleared on patient's request.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6558",
      "code" : "T",
      "display" : "Taboo - Information not to be disclosed or discussed with patient except through physician assigned to patient in this case.  This is usually a temporary constraint only; example use is a new fatal diagnosis or finding, such as malignancy or HIV.",
      "definition" : "Taboo - Information not to be disclosed or discussed with patient except through physician assigned to patient in this case.  This is usually a temporary constraint only; example use is a new fatal diagnosis or finding, such as malignancy or HIV.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
