# processingConsideration - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **processingConsideration**

## CodeSystem: processingConsideration 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0562 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProcessingConsideration |
| *Other Identifiers:*OID:2.16.840.1.113883.18.365 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer). Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0562 (Processing Consideration Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProcessingConsiderationCodes](ValueSet-v2-0562.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0562",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0562",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.365"
    }
  ],
  "version" : "2.0.0",
  "name" : "ProcessingConsideration",
  "title" : "processingConsideration",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify special processing requested of Payer for this Product/Service Line Item (e.g., hold until paper supporting documentation is received by Payer).  Used in the Product/Service Line Item (PSL) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0562 (Processing Consideration Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0562",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6201",
      "code" : "PAPER",
      "display" : "Paper documentation to follow",
      "definition" : "Paper documentation to follow",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6202",
      "code" : "EFORM",
      "display" : "Electronic form to follow",
      "definition" : "Electronic form to follow",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "E30 transaction to follow"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "E30 transaction to follow"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6203",
      "code" : "FAX",
      "display" : "Fax to follow",
      "definition" : "Fax to follow",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6204",
      "code" : "RTADJ",
      "display" : "Real Time Adjudication Processing",
      "definition" : "Real Time Adjudication Processing",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6205",
      "code" : "DFADJ",
      "display" : "Deferred Adjudication Processing",
      "definition" : "Deferred Adjudication Processing",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "If permitted by Payer"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "6206",
      "code" : "PYRDELAY",
      "display" : "Delayed by a Previous Payer",
      "definition" : "Delayed by a Previous Payer",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Allows Provider to explain lateness of Invoice to a subsequent Payer"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Allows Provider to explain lateness of Invoice to a subsequent Payer"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
