# containerCondition - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **containerCondition**

## CodeSystem: containerCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0544 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ContainerCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.353 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab. If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons. Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0544 (Container Condition) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSContainerCondition](ValueSet-v2-0544.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0544",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0544",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.353"
    }
  ],
  "version" : "2.0.0",
  "name" : "ContainerCondition",
  "title" : "containerCondition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts used to specify at each receipt the status of the container in which the specimen is shipped in chain of custody cases where specimens are moved from lab to lab.  If the container is compromised in any way (seal broken, container cracked or leaking, etc.), then this status needs to be recorded for legal reasons.  Used in the Specimen (SPM), Shipment (SHP) and Shipment Package (PAC) segments in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0544 (Container Condition)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0544",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5668",
      "code" : "...",
      "display" : "No suggested values",
      "definition" : "No suggested values",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "keine Werte vorgeschlagen"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "5669",
      "code" : "XC37",
      "display" : "Not Body temperature",
      "definition" : "Not Body temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep at body temperature: 36 - 38 degrees C."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep at body temperature: 36 - 38 degrees C."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5670",
      "code" : "XAMB",
      "display" : "Not Ambient temperature",
      "definition" : "Not Ambient temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep at ambient (room) temperature, approximately 22 +/- 2 degrees C. Accidental refrigeration or freezing is of little consequence"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep at ambient (room) temperature, approximately 22 +/- 2 degrees C. Accidental refrigeration or freezing is of little consequence"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5671",
      "code" : "XCAMB",
      "display" : "Not Critical ambient temperature",
      "definition" : "Not Critical ambient temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep critical ambient."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep critical ambient."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5672",
      "code" : "XREF",
      "display" : "Not Refrigerated temperature",
      "definition" : "Not Refrigerated temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep at refrigerated temperature: 4-8 degrees C."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep at refrigerated temperature: 4-8 degrees C."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5673",
      "code" : "XCREF",
      "display" : "Not Critical refrigerated temperature",
      "definition" : "Not Critical refrigerated temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep critical refrigerated."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep critical refrigerated."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5674",
      "code" : "XFRZ",
      "display" : "Not Frozen temperature",
      "definition" : "Not Frozen temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep at frozen temperature: -4 degrees C."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep at frozen temperature: -4 degrees C."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5675",
      "code" : "XCFRZ",
      "display" : "Not Critical frozen temperature",
      "definition" : "Not Critical frozen temperature",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep critical frozen"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep critical frozen"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5676",
      "code" : "XDFRZ",
      "display" : "Not Deep frozen",
      "definition" : "Not Deep frozen",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep deep frozen: -16 to -20 degree C."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep deep frozen: -16 to -20 degree C."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5677",
      "code" : "XUFRZ",
      "display" : "Not Ultra frozen",
      "definition" : "Not Ultra frozen",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep ultra cold frozen: ~ -75 to -85 degree C. (ultra cold freezer is typically at temperature of dry ice)."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep ultra cold frozen: ~ -75 to -85 degree C. (ultra cold freezer is typically at temperature of dry ice)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5678",
      "code" : "XNTR",
      "display" : "Not Liquid nitrogen",
      "definition" : "Not Liquid nitrogen",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep in liquid nitrogen."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep in liquid nitrogen."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5679",
      "code" : "XPRTL",
      "display" : "Not Protected from light",
      "definition" : "Not Protected from light",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to protect from light."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to protect from light."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5680",
      "code" : "XCATM",
      "display" : "Exposed to Air",
      "definition" : "Exposed to Air",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Exposed to atmosphere."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Exposed to atmosphere."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5681",
      "code" : "XDRY",
      "display" : "Not Dry",
      "definition" : "Not Dry",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep in a dry environment."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep in a dry environment."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5682",
      "code" : "XPSO",
      "display" : "Exposed to shock",
      "definition" : "Exposed to shock",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to protect from shock."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to protect from shock."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5683",
      "code" : "XPSA",
      "display" : "Shaken",
      "definition" : "Shaken",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Shaken."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Shaken."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5684",
      "code" : "XUPR",
      "display" : "Not Upright",
      "definition" : "Not Upright",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep upright."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep upright."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5685",
      "code" : "XMTLF",
      "display" : "Metal Exposed",
      "definition" : "Metal Exposed",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Failed to keep container is free of heavy metals."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Failed to keep container is free of heavy metals."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5686",
      "code" : "SB",
      "display" : "Seal Broken",
      "definition" : "Seal Broken",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Container seal is broken."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Container seal is broken."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5687",
      "code" : "CC",
      "display" : "Container Cracked",
      "definition" : "Container Cracked",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Container is cracked."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Container is cracked."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5688",
      "code" : "CT",
      "display" : "Container Torn",
      "definition" : "Container Torn",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Container is torn"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Container is torn"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "5689",
      "code" : "CL",
      "display" : "Container Leaking",
      "definition" : "Container Leaking",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Container is leaking"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Container is leaking"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
