# formularyStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **formularyStatus**

## CodeSystem: formularyStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0478 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:FormularyStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.305 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary. Used in HL7 Version 2.x messaging in the RXE segment. 

 
Underlying Master Code System for V2 table 0478 (Formulary Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSFormularyStatus](ValueSet-v2-0478.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0478",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0478",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.305"
    }
  ],
  "version" : "2.0.0",
  "name" : "FormularyStatus",
  "title" : "formularyStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying whether or not the pharmaceutical substance is part of the local formulary.  Used in HL7 Version 2.x messaging in the RXE segment.",
  "purpose" : "Underlying Master Code System for V2 table 0478 (Formulary Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0478",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4894",
      "code" : "Y",
      "display" : "Pharmaceutical substance is in the formulary",
      "definition" : "Pharmaceutical substance is in the formulary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4895",
      "code" : "N",
      "display" : "Pharmaceutical substance is NOT in the formulary",
      "definition" : "Pharmaceutical substance is NOT in the formulary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4896",
      "code" : "R",
      "display" : "Pharmaceutical substance is in the formulary, but restrictions apply",
      "definition" : "Pharmaceutical substance is in the formulary, but restrictions apply",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "4897",
      "code" : "G",
      "display" : "Pharmaceutical substance is in the formulary, but guidelines apply",
      "definition" : "Pharmaceutical substance is in the formulary, but guidelines apply",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
