# specimenComponent - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **specimenComponent**

## CodeSystem: specimenComponent 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0372 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SpecimenComponent |
| *Other Identifiers:*OID:2.16.840.1.113883.18.230 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc. Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0372 (Specimen Component) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSpecimenComponent](ValueSet-v2-0372.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0372",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0372",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.230"
    }
  ],
  "version" : "2.0.0",
  "name" : "SpecimenComponent",
  "title" : "specimenComponent",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts that identify the specimen component, e.g., supernatant, sediment, etc.  Used in the Interaction Specimen Container Detail (SAC) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0372 (Specimen Component)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0372",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "3792",
      "code" : "SUP",
      "display" : "Supernatant",
      "definition" : "Supernatant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3793",
      "code" : "SED",
      "display" : "Sediment",
      "definition" : "Sediment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3794",
      "code" : "BLD",
      "display" : "Whole blood, homogeneous",
      "definition" : "Whole blood, homogeneous",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3795",
      "code" : "BSEP",
      "display" : "Whole blood, separated",
      "definition" : "Whole blood, separated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3796",
      "code" : "PRP",
      "display" : "Platelet rich plasma",
      "definition" : "Platelet rich plasma",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3797",
      "code" : "PPP",
      "display" : "Platelet poor plasma",
      "definition" : "Platelet poor plasma",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3798",
      "code" : "SER",
      "display" : "Serum, NOS (not otherwise specified)",
      "definition" : "Serum, NOS (not otherwise specified)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3799",
      "code" : "PLAS",
      "display" : "Plasma, NOS (not otherwise specified)",
      "definition" : "Plasma, NOS (not otherwise specified)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
