# alertLevel - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **alertLevel**

## CodeSystem: alertLevel 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0367 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AlertLevel |
| *Other Identifiers:*OID:2.16.840.1.113883.18.225 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event). Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0367 (Alert Level) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAlertLevel](ValueSet-v2-0367.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0367",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0367",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.225"
    }
  ],
  "version" : "2.0.0",
  "name" : "AlertLevel",
  "title" : "alertLevel",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify the highest level of the alert state (e.g.,highest alert severity) that is associated with the indicated equipment (e.g. processing event, inventory event, QC event).  Used in the Equipment Detail (EQU) and Notification Detail (NDS) segments in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0367 (Alert Level)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0367",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "3687",
      "code" : "N",
      "display" : "Normal",
      "definition" : "Normal",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "No Corrective Action Needed"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "No Corrective Action Needed"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3688",
      "code" : "W",
      "display" : "Warning",
      "definition" : "Warning",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Corrective Action Anticipated"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Corrective Action Anticipated"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3689",
      "code" : "S",
      "display" : "Serious",
      "definition" : "Serious",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Corrective Action Required"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Corrective Action Required"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3690",
      "code" : "C",
      "display" : "Critical",
      "definition" : "Critical",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Shut Down, Fix Problem and Re-init"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Shut Down, Fix Problem and Re-init"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "3691",
      "code" : "...",
      "display" : "(null) No level change",
      "definition" : "(null) No level change",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "3692",
      "code" : "…",
      "display" : "(null) No level change",
      "definition" : "(null) No level change",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    }
  ]
}

```
