# queryResponseStatus - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **queryResponseStatus**

## CodeSystem: queryResponseStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0208 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:QueryResponseStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.113 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging. It is commonly used to indicate no data is found that matches the query parameters, but no error. Used in HL7 Version 2.x messaging in the QAK segment. 

 
Underlying Master Code System for V2 table 0208 (Query Response Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSQueryResponseStatus](ValueSet-v2-0208.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0208",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0208",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.113"
    }
  ],
  "version" : "2.0.0",
  "name" : "QueryResponseStatus",
  "title" : "queryResponseStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging.  It is commonly used to indicate no data is found that matches the query parameters, but no error.   Used in HL7 Version 2.x messaging in the QAK segment.",
  "purpose" : "Underlying Master Code System for V2 table 0208 (Query Response Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0208",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2126",
      "code" : "OK",
      "display" : "Data found, no errors (this is the default)",
      "definition" : "Data found, no errors (this is the default)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2127",
      "code" : "NF",
      "display" : "No data found, no errors",
      "definition" : "No data found, no errors",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2128",
      "code" : "AE",
      "display" : "Application error",
      "definition" : "Application error",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2129",
      "code" : "AR",
      "display" : "Application reject",
      "definition" : "Application reject",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2130",
      "code" : "TM",
      "display" : "Too much data found",
      "definition" : "The response would exceed the maximum length designated in RCP-2 of the query message.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "2131",
      "code" : "PD",
      "display" : "Protected data",
      "definition" : "Data matching the query parameters was found but could not be shared with the querying system for reasons including local policy or legal restrictions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    }
  ]
}

```
