# segmentAction - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **segmentAction**

## CodeSystem: segmentAction 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0206 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SegmentAction |
| *Other Identifiers:*OID:2.16.840.1.113883.18.111 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments. 

 
Underlying Master Code System for V2 table 0206 (Segment Action Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSegmentActionCode](ValueSet-v2-0206.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0206",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0206",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.111"
    }
  ],
  "version" : "2.0.0",
  "name" : "SegmentAction",
  "title" : "segmentAction",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in \"action code mode\" (a kind of update mode in the Standard).  Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments.",
  "purpose" : "Underlying Master Code System for V2 table 0206 (Segment Action Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0206",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "2115",
      "code" : "A",
      "display" : "Add/Insert",
      "definition" : "Add/Insert",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Einfügen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2116",
      "code" : "D",
      "display" : "Delete",
      "definition" : "Delete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Löschen/Stornieren"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2117",
      "code" : "S",
      "display" : "Used in Snapshot mode",
      "definition" : "Declares when segment falls under snapshot  mode handling, i.e. all elements that were previously sent will be sent, not just any changes",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Snapshot mode is the expected default; use this code to explicitly state that."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "2118",
      "code" : "U",
      "display" : "Update",
      "definition" : "Update",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ändern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "2119",
      "code" : "X",
      "display" : "No Change",
      "definition" : "No Change",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
