# orderControlCodes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **orderControlCodes**

## CodeSystem: orderControlCodes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0119 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OrderControlCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.48 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. 

 
Underlying Master Code System for V2 table 0119 (Order Control Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSOrderControl](ValueSet-v2-0119.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0119",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0119",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.48"
    }
  ],
  "version" : "2.0.0",
  "name" : "OrderControlCodes",
  "title" : "orderControlCodes",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are used to determine the function of the order segment.  Depending on the message, the action specified by one of these control codes may refer to an order or an individual service.  Used in Version 2.x messaging of orders in the ORC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0119 (Order Control Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0119",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "1359",
      "code" : "AF",
      "display" : "Order/service refill request approval",
      "definition" : "AF is a response to RF where the placer authorizing a refill or quantity of refills.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications ."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.<p>AF is a response to RF where the placer authorizing a refill or quantity of refills."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1360",
      "code" : "CA",
      "display" : "Cancel order/service request",
      "definition" : "Cancel order/service request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag stornieren"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nA cancellation is a request by the placer for the filler, or the filler to the placer, not to do a previously ordered service. Confirmation of the cancellation request is provided by the filler or placer, e.g., a message with an ORC-1-order control value of CR.\r\nTypical responses include, but are not limited to, CR – Cancelled as requested, UC – Unable to Cancel."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1361",
      "code" : "CH",
      "display" : "Child order/service",
      "definition" : "Child order/service",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "nachgeordneter Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.<p>Used in conjunction with the PA - Parent order control code. Refer to PA order control code for discussion."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Used in conjunction with the PA - Parent order control code. Refer to PA order control code for discussion."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1362",
      "code" : "CN",
      "display" : "Combined result",
      "definition" : "Combined result",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kumulatives Ergebnis (zu mehreren Aufträgen)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nThe combined result code provides a mechanism to transmit results that are associated with two or more orders. This situation occurs commonly in radiology reports when the radiologist dictates a single report for two or more exams represented as two or more orders. For example, knee and hand films for a rheumatoid arthritis patient might generate a single dictation on the part of the radiologist.\r\nWhen such results are reported the CN code replaces the RE code in all but the last ORC, and the results follow the last ORC and its OBR. An example follows of a single report following three ORCs:\r\nMSH|...<cr>\r\nPID|...<cr>\r\nORC|CN|...<cr>\r\nOBR|1|A4461XA^HIS|81641^RAD|73666^Bilateral Feet|...<cr>\r\nORC|CN|...<cr>\r\nOBR|2|A4461XB^HIS|81642^RAD|73642^Bilateral Hand PA|...<cr>\r\nORC|RE|...<cr>\r\nOBR|3|A4461XC^HIS|81643^RAD|73916^Bilateral Knees|...<cr>\r\nOBX|1|CE|73916&IMP|1|Radiologist’s Impression|...<cr>\r\nOBX|2|CE|73642&IMP|1|Radiologist’s Impression|...<cr>\r\nOBX|3|FT|73642&GDT|1|Description|...<cr>"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1363",
      "code" : "CP",
      "display" : "Cancel process step",
      "definition" : "Cancel process step",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nThe control code CP – Cancel process step should be used in the ORC-1 for communication Filler-to-Filler, e.g., LIS-to-Analyzer, to differentiate from code CA (Placer-to-Filler).\r\nThe Filler should response with an acceptance of the cancellation using ORC-1 = CR and ORC-5 = CA."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1364",
      "code" : "CR",
      "display" : "Canceled as requested",
      "definition" : "Canceled as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag anweisungsgemäß storniert"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler or Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler or Placer Applications.<p>A response by the filler or placer application that a request to cancel (CA by the placer application) was performed successfully."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "A response by the filler or placer application that a request to cancel (CA by the placer application) was performed successfully."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1365",
      "code" : "DC",
      "display" : "Discontinue order/service request",
      "definition" : "Discontinue order/service request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsausführung abbrechen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nA request by the placer for the filler, or the filler to the placer,  to discontinue a previously requested service. The differentiation between discontinue and cancel is that discontinue effects the order/service and all future occurrences, cancel refers to just the present action. \r\nTypical responses include, but are not limited to, CR – Cancelled as requested, UC – Unable to Cancel."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1366",
      "code" : "DE",
      "display" : "Data errors",
      "definition" : "Data errors",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Datenfehler"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1367",
      "code" : "DF",
      "display" : "Order/service refill request denied",
      "definition" : "Order/service refill request denied",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.\r\nIn response to a Filler application requesting refill authorization (RF), DF indicates that the placer does not authorize refills for the order. ORC-16 Order Control Code reason may be used to indicate the reason for the request denial. Some suggested values include:\r\nAA\tPatient unknown to the provider\r\nAB\tPatient never under provider care\r\nAC\tPatient no longer under provider care\r\nAD\tPatient has requested refill too soon\r\nAE\tMedication never prescribed for the patient\r\nAF\tPatient should contact provider first\r\nAG\tRefill not appropriate\r\nNote that these values originate from the NCPDP SCRIPT Response Segment Code List Qualifiers. Materials Reproduced with the consent of ©National Council for Prescription Drug Programs, Inc. 1988, 1992, 2002 NCPDP."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1368",
      "code" : "DR",
      "display" : "Discontinued as requested",
      "definition" : "Discontinued as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsausführung anweisungsgemäß abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler or Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler or Placer Applications.<p>The filler or placer, in response to a request to discontinue (DC from the placer or filler application), has discontinued the order/service."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "The filler or placer, in response to a request to discontinue (DC from the placer or filler application), has discontinued the order/service."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1369",
      "code" : "FU",
      "display" : "Order/service refilled, unsolicited",
      "definition" : "Order/service refilled, unsolicited",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.<p>FU notifies the placer that the filler issued a refill for the order at the patient's request."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "FU notifies the placer that the filler issued a refill for the order at the patient's request."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1370",
      "code" : "HD",
      "display" : "Hold order request",
      "definition" : "Hold order request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsbearbeitung aussetzen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.<p>Typical responses include, but are not limited to, CR - Cancelled as requested, UC - Unable to Cancel."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Typical responses include, but are not limited to, CR - Cancelled as requested, UC - Unable to Cancel."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1371",
      "code" : "HR",
      "display" : "On hold as requested",
      "definition" : "On hold as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsbearbeitung anweisungsgemäß ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1372",
      "code" : "LI",
      "display" : "Link order/service to patient care problem or goal",
      "definition" : "Link order/service to patient care problem or goal",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.<p>Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1373",
      "code" : "MC",
      "display" : "Miscellaneous Charge - not associated with an order",
      "definition" : "Miscellaneous Charge - not associated with an order",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "applies to DFT^P03^DFT_P03 and DFT^P11^DFT_P11"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "applies to DFT^P03^DFT_P03 and DFT^P11^DFT_P11"
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "applies to DFT^P03^DFT_P03 and DFT^P11^DFT_P11"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1374",
      "code" : "NA",
      "display" : "Number assigned",
      "definition" : "Number assigned",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Nummer zugewiesen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.\r\nThere are three circumstances that involve requesting an order number (ORC-2-placer order number or ORC-3-filler order number): \r\n\r\n(1) When the filler application needs to request an ORC-3-filler order number from a centralized application (e.g., HIS).\r\nSN – The send order number code provides a mechanism for the filler to request an ORC-3-filler order number from some centralized application (called “other” in the table below), such as a central HIS, by sending an ORM message containing an ORC-1-order control value of SN. This ORC has a null ORC-3-filler order number and an ORC-2-placer order number created by the filler application when the filler originates the order.\r\n\r\nThe order (SN type) message can be acknowledged by either one of two methods:\r\na) By an order application acknowledgement message containing an ORC-1-order control value of OK. Then an unsolicited order message can be sent at a future time, containing an ORC with ORC-1-order control value of NA to provide the actual number assigned.\r\n\r\nb) By an order acknowledgement message containing an ORC-1-order control value of NA as described below.\r\n\r\nNA – The number assigned code allows the “other” application to notify the filler application of the newly-assigned filler order number. ORC-1-order control contains value of NA, ORC-2-placer order number (from the ORC with the SN value), and the newly-assigned filler order number. \r\nCode\tFrom\tORC-2-Placer Order Number\tORC-3-Filler Order Number\r\nSN\tfiller application\tplacer order number^filler application ID\tNull\r\nNA\tother application\tplacer order number^filler application ID\tfiller order number^filler application ID\r\nNote: Both the placer order number and the filler order number have the filler’s application ID\r\n\r\n(2) When the filler application needs to request an ORC-2-placer order number from some other application (e.g., Order Entry).\r\n\r\nSN – The send order number code provides a mechanism for the filler application to request an ORC-2-placer order number from another application (called “other” in the table below) by sending an order message containing an ORC-1-order control value of SN. This ORC has a null ORC-2-placer order number and an ORC-3-filler order number created by the filler application when the filler originates the order. \r\n\r\nThe order (SN type) message can be acknowledged by two methods:\r\na) By an order application acknowledgement message containing an ORC-1-order control value of OK. Then an unsolicited order message can be sent at a future time, containing an ORC-1-order control value of NA to provide the actual number assigned.\r\n \r\nb) By an order acknowledgement message containing an ORC-1-order control value of NA as described below.\r\nNA – The number assigned code allows the “other” application to notify the filler application of the newly-assigned ORC-2-placer order number. The ORC contains an ORC-1-order control value of NA, the newly-assigned ORC-2-placer order number, and the ORC-3-filler order number (from the ORC with the SN value).\r\nCode\tFrom\tORC-2-Placer Order Number\tORC-3-Filler Order Number\r\nSN\tfiller application\tnull\tfiller order number^filler application ID\r\nNA\tother application\tplacer order number^placer application ID\tfiller order number^filler application ID\r\nNote: The new ORC-2-placer order number has the placer’s application ID\r\n\r\n(3) When an application (not the filler application) wants to assign an ORC-3-filler order number for a new order.\r\nNW – When the application creating an order (not the filler application) wants to assign a filler order number for a new order.\r\nor \r\nRO – (RO following an RP). In this case, the “other” application completes ORC-3-filler order number, using the filler application ID as the second component of the filler order number.\r\nCode\tFrom\tORC-2-Placer Order Number\tORC-3-Filler Order Number\r\nNW or RO\tOther application to filler application\tplacer order number^placer application ID\tfiller order number^filler application ID"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1375",
      "code" : "NR",
      "display" : "Notification Received",
      "definition" : "Notifies the Filler that the Placer received a cancellation, discontinuance, or other state change notice",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1376",
      "code" : "NW",
      "display" : "New order/service",
      "definition" : "New order/service",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Neuer Auftrag"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "See comments for NA - Number Assigned."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1377",
      "code" : "OC",
      "display" : "Order/service canceled",
      "definition" : "Order/service canceled",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1378",
      "code" : "OD",
      "display" : "Order/service discontinued",
      "definition" : "Order/service discontinued",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsausführung abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1379",
      "code" : "OE",
      "display" : "Order/service released",
      "definition" : "Order/service released",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1380",
      "code" : "OF",
      "display" : "Order/service refilled as requested",
      "definition" : "Order/service refilled as requested",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.<p>OF directly responds to the placer system's request for a refill."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "OF directly responds to the placer system's request for a refill."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1381",
      "code" : "OH",
      "display" : "Order/service held",
      "definition" : "Order/service held",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsbearbeitung ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1382",
      "code" : "OK",
      "display" : "Order/service accepted & OK",
      "definition" : "Order/service accepted & OK",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag akzeptiert"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "See comments for NA - Number Assigned."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1383",
      "code" : "OP",
      "display" : "Notification of order for outside dispense",
      "definition" : "Notification of order for outside dispense",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.\r\nThese order control codes are used to communicate an order between systems where the order is intended for informational purposes. For example, an order that will be performed by a vendor outside the enterprise of communicating systems. The communicating systems may need to maintain information relative to the order for clinical continuity, but no actions to perform the ordered service are intended.\r\nOP represents an informational version of NW, PY represents the informational-only version of RO. NW and RO table notes also apply to OP and PY, respectively."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1384",
      "code" : "OR",
      "display" : "Released as requested",
      "definition" : "Released as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsbearbeitung anweisungsgemäß wiederaufgenommen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1385",
      "code" : "PA",
      "display" : "Parent order/service",
      "definition" : "Parent order/service",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Hauptauftrag"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nThe parent (PA) and child (CH) order control codes allow the spawning of “child” orders from a “parent” order without changing the parent (original order). One or more ORC segments with an ORC-1-order control value of PA are followed by one or more ORC segments with an ORC-1-order control value of CH. Whether OBR segments must be present is determined by the value of ORC-6-response flag. \r\n\r\nFor example, suppose that a microbiology culture produced two organisms and corresponding susceptibility reports. Then the sequence of segments would be as follows: (see figure 4-4)\r\n\r\nThe assignment of placer order numbers in the parent-child paradigm depends on whether the placer or filler creates the child order and in the latter case, on whether the placer supports the SN/NA transaction. If the placer creates the child orders it will assign their placer order numbers according to its usual procedures. If the filler creates the child orders there are two possibilities: each child will inherit the placer order number of its parent, or the filler will use the SN/NA transaction to request that the placer assign a placer order number. In either case, the filler application creates the filler order numbers of the children according to its usual procedures.\r\n\r\nWhenever a child order is transmitted in a message the ORC segment’s ORC-8-parent is valued with the parent’s filler order number (if originating from the filler) and with the parent’s placer order number (if originating from the filler or if originating from the placer). \r\n\r\nThe parent child mechanism can be used to “expand” a parent order (e.g., an order for three EKGs on successive mornings)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1386",
      "code" : "PR",
      "display" : "Previous Results with new order/service",
      "definition" : "Previous Results with new order/service",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.\r\nPR indicates that this ORC is part of an ORU structure containing previous observation, which is embedded in the order.\r\n\r\nAt least two main use cases require that the complete results of the previous observations be transmitted with the order. \r\n\r\n•\tDiagnostic laboratories referring tests to another lab for either confirmation of results (HIV, etc.) or due to not being equipped to do the tests (genetic testing, etc.). \r\n\r\n•\tDiagnostic laboratories sending test results to Knowledge Bases for the automated generation of diagnostic comments for inclusion into the lab report."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1387",
      "code" : "PY",
      "display" : "Notification of replacement order for outside dispense",
      "definition" : "Notification of replacement order for outside dispense",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.<p>See comments for OP - Notification of order for outside dispense."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "See comments for OP - Notification of order for outside dispense."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1388",
      "code" : "RA",
      "display" : "Recommendation Accepted",
      "definition" : "Identifies that this previously recommended replacement order has been accepted",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications: \nUsed in the Recommendation Accepted message; includes the assigned placer order number for the accepted replacement order\nFiller Applications: \nUsed in the acknowledgment response message to the Recommendation Accepted message"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "1389",
      "code" : "RC",
      "display" : "Recommended Change",
      "definition" : "Identifies that this OBR represents a recommended replacement order",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications.\nUsed in the recommendation message sent to the placer"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "1390",
      "code" : "RD",
      "display" : "Recommendation Declined",
      "definition" : "Identifies that this previously sent recommended replacement order has been declined",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications:\nUsed in the Recommendation Declined message \nFiller Applications: \nUsed in the acknowledgment response message to the Recommendation Declined message"
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "1391",
      "code" : "RE",
      "display" : "Observations/Performed Service to follow",
      "definition" : "Observations/Performed Service to follow",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Untersuchungsergebnisse folgen (in späteren Segmenten dieser Nachricht)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nThe observations-to-follow code is used to transmit patient-specific information with an order. An order detail segment (e.g., OBR) can be followed by one or more observation segments (OBX). Any observation that can be transmitted in an ORU message can be transmitted with this mechanism. When results are transmitted with an order, the results should immediately follow the order or orders that they support.\r\n\r\nThe following example shows the sequence of segments for three Pharmacy orders. It illustrates the use of the RE code:\r\nSegment\tOrder Control\tComment\r\nMSH\t\t\r\nPID\t\t\r\nORC\tNW\tFirst new order\r\nRXO\t\tFirst order segment\r\n\t\t\r\nORC\tNW\t2nd new order\r\nRXO\t\t2nd order segment\r\n[ORC\tRE\tPatient-specific observation, optional in V 2.2\r\n OBR]\t\tObservation OBR, optional in V 2.2\r\nOBX\t\tAn observation segment\r\nOBX\t\tAnother observation segment\r\nOBX\t\tAnother observation segment\r\nOBX\t\tAnother observation segment\r\n\t\t\r\nORC\tNW\t3rd order\r\nRXO\t\t3rd order segment\r\n\r\nIn this version of HL7, results can be transmitted with an order as one or more OBX segments without the necessity of including the ORC and OBR segments.\r\n\r\nObservations can be transmitted in an ORU message without using an ORC. There are times when it is necessary to transmit information not included in the OBR segments of the ORU message. In this case, it is recommended that the ORC be included in the ORU message.\r\n\r\nThe order control value of RE is required only in ORM messages to indicate that an order is followed by observation results (OBX). The RE code is not necessary in the ORU message because it is expected that the OBR segments can be followed by observation results (OBX)."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1392",
      "code" : "RF",
      "display" : "Refill order/service request",
      "definition" : "Refill order/service request",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nRF accommodates requests by either the filler or the placer. The filler may be requesting refill authorization from the placer. A placer system may be requesting a refill to be done by the filler system.\r\n\r\nTypical responses include, but are not limited to: For a Filler request AF – Order/service refill request approval, DF – Order/service refill request denied; for a Placer request RE – Observations/Performed Service to follow, UF – Unable to refill."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1393",
      "code" : "RL",
      "display" : "Release previous hold",
      "definition" : "Release previous hold",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsberabeitung wiederaufnehmen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1394",
      "code" : "RO",
      "display" : "Replacement order",
      "definition" : "Replacement order",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ersatzauftrag"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nA replacement is the substitution of one or more orders for one or more previously ordered services.\r\n\r\nThe replaced orders are treated as though they were canceled. If and when an ordered service can be replaced are local site-specific determinations.\r\n\r\nUse the parent/child order control codes if the site specifies that the original order must remain intact. Do not use the replacement codes under this circumstance. \r\n\r\nFor each order to be replaced, use an ORC-1-order control value of RP (request for a replacement going to a filler) or RU (an unsolicited replacement created by the filler) used by the filler to notify the placer and/or other systems). By local agreement, the ORC segment (with RP or RU) may be followed by its original order detail segment. The ORC segments (with RP or RU) must be followed by an ORC segment with an ORC-1-order control value of RO (indicating the replacement order). By local agreement, the ORC with the RO value may be followed by an order detail segment. \r\n\r\nFor example, suppose that an ancillary application were replacing two OBR orders with three different orders. The sequence of segments would be as follows:\r\n\r\nSeg\tOrder Control\tComment\r\nORC\tRU\t1st replaced ORC\r\nOBR\t\t1st replaced order’s detail segment\r\n\t\t\r\nORC\tRU\t2nd replaced ORC\r\nOBR\t\t2nd replaced order’s detail segment\r\n\t\t\r\nORC\tRO\t1st replacement ORC\r\nOBR\t\t1st replacement order’s detail segment\r\n\t\t\r\nORC\tRO\t2nd replacement ORC\r\nOBR\t\t2nd replacement order’s detail segment\r\n\t\t\r\nORC\tRO\t3rd replacement ORC\r\nOBR\t\t3rd replacement order’s detail segment\r\n\r\nWhether the OBR segments must be present is determined by the value of ORC-6-response flag.\r\n\r\nThe described replacement method will handle all possible cases of replacement: one into one, many into one, one into many, and many into many. If the placer sent this request to the filler with two RPs, and this was a response back from the filler to the placer, the two RUs (replaced unsolicited) would be two RQs (replaced as requested). (see figure 4-3)\r\n\r\nSeg\tOrder Control\tComment\r\nORC\tRQ\t1st replaced ORC\r\nOBR\t\t1st replaced order’s detail segment\r\n\t\t\r\nORC\tRQ\t2nd replaced ORC\r\nOBR\t\t2nd replaced order’s detail segment\r\n\t\t\r\nORC\tRO\t1st replacement ORC\r\nOBR\t\t1st replacement order’s detail segment\r\n\t\t\r\nORC\tRO\t2nd replacement ORC\r\nOBR\t\t2nd replacement order’s detail segment\r\n\t\t\r\nORC\tRO\t3rd replacement ORC\r\nOBR\t\t3rd replacement order’s detail segment\r\n\r\nThe replacement order code is sent by the filler application to another application indicating the exact replacement ordered service. It is used with the RP and RU order control codes as described above.\r\n\r\nThe rules for the order numbers in ORC segments with an order control value of RO are determined by the replacement type (RP or RU).\r\n\r\nIn the case of the RU type (i.e., unsolicited replacement by the filler), the filler order number is generated as usual by the filler application. The placer order number is identical to the placer order number of the first transmitted ORC with an order control value of RU.\r\n\r\nIn the case of the RP type (i.e., a replacement request from another application to the filler), the placer order number is generated by the placer application using the procedure for new orders. The filler order number is generated by the filler application using the procedure identical for new orders.\r\n\r\nIf a replacement sequence is used in an ORU message (i.e., during results reporting), the following are the recommended segments to be used for the replacement orders:\r\n\r\nORC with an order control value of RO.\r\n\r\nAny OBR segments (can be replaced by any order detail segments).\r\n\r\nOptionally followed by observation result segments (OBX)\r\nNTE segments can appear after the OBR (or any order detail segment) or after an OBX segment as in a regular ORU message."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1395",
      "code" : "RP",
      "display" : "Order/service replace request",
      "definition" : "Order/service replace request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag ersetzen"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.\r\nA replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO – Replacement Order for further discussion.\r\n\r\nThe order replace request code permits the order filler to replace one or more new orders with one or more new orders, at the request of the placer application.\r\n\r\nThe rules for the order numbers in ORC segments with an order control value of RO are determined by the replacement type (RP or RU).\r\n\r\nIn the case of the RU type (i.e., unsolicited replacement by the filler), the filler order number is generated as usual by the filler application. The placer order number is identical to the placer order number of the first transmitted ORC with an order control value of RU.\r\n\r\nIn the case of the RP type (i.e., a replacement request from another application to the filler), the placer order number is generated by the placer application using the procedure for new orders. The filler order number is generated by the filler application using the procedure identical for new orders.\r\n\r\nIf a replacement sequence is used in an ORU message (i.e., during results reporting), the following are the recommended segments to be used for the replacement orders:\r\n\r\na) ORC with an order control value of RO\r\n\r\nb) Any OBR segments (can be replaced by any order detail segments)\r\n\r\nc) Optionally followed by observation result segments (OBX)\r\n\r\nd) NTE segments can appear after the OBR (or any order detail segment) or after an OBX segment as in a regular ORU message"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1396",
      "code" : "RQ",
      "display" : "Replaced as requested",
      "definition" : "Replaced as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag anweisungsgemäß ersetzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nA replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO – Replacement Order for further discussion.\r\n\r\nThe order replace request code permits the order filler to replace one or more new orders with one or more new orders, at the request of the placer application.\r\n\r\nThe replacement order code is sent by the filler application to another application indicating the exact replacement ordered service. It is used with the RP and RU order control codes as described above.\r\n\r\nThe rules for the order numbers in ORC segments with an order control value of RO are determined by the replacement type (RP or RU).\r\n\r\nIn the case of the RU type (i.e., unsolicited replacement by the filler), the filler order number is generated as usual by the filler application. The placer order number is identical to the placer order number of the first transmitted ORC with an order control value of RU.\r\n\r\nIn the case of the RP type (i.e., a replacement request from another application to the filler), the placer order number is generated by the placer application using the procedure for new orders. The filler order number is generated by the filler application using the procedure identical for new orders.\r\n\r\nIf a replacement sequence is used in an ORU message (i.e., during results reporting), the following are the recommended segments to be used for the replacement orders:\r\n\r\na) ORC with an order control value of RO\r\n\r\nb) Any OBR segments (can be replaced by any order detail segments)\r\n\r\nc) Optionally followed by observation result segments (OBX)\r\n\r\nd) NTE segments can appear after the OBR (or any order detail segment) or after an OBX segment as in a regular ORU message"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1397",
      "code" : "RR",
      "display" : "Request received",
      "definition" : "Request received",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Anforderung erhalten"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.\r\nLeft in for backward compatibility. In the current version it is equivalent to an accept acknowledgment. The request-received code indicates that an order message has been received and will be processed later. The order has not yet undergone the processing that would permit a more exact response."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1398",
      "code" : "RU",
      "display" : "Replaced unsolicited",
      "definition" : "Replaced unsolicited",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag ersetzt (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nA replacement is the substitution of one or more orders for one or more previously ordered services. See comment 1 on RO – Replacement Order for further discussion.\r\n\r\nThe unsolicited replacement code permits the filler application to notify another application without being requested from the placer application.\r\n\r\nThe rules for the order numbers in ORC segments with an order control value of RO are determined by the replacement type (RP or RU).\r\n\r\nIn the case of the RU type (i.e., unsolicited replacement by the filler), the filler order number is generated as usual by the filler application. The placer order number is identical to the placer order number of the first transmitted ORC with an order control value of RU.\r\n\r\nIn the case of the RP type (i.e., a replacement request from another application to the filler), the placer order number is generated by the placer application using the procedure for new orders. The filler order number is generated by the filler application using the procedure identical for new orders.\r\n\r\nIf a replacement sequence is used in an ORU message (i.e., during results reporting), the following are the recommended segments to be used for the replacement orders:\r\n\r\na) ORC with an order control value of RO\r\n\r\nb) Any OBR segments (can be replaced by any order detail segments)\r\n\r\nc) Optionally followed by observation result segments (OBX)\r\n\r\nd) NTE segments can appear after the OBR (or any order detail segment) or after an OBX segment as in a regular ORU message"
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1399",
      "code" : "SC",
      "display" : "Status changed",
      "definition" : "Status changed",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Statusänderung"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1400",
      "code" : "SN",
      "display" : "Send order/service number",
      "definition" : "Send order/service number",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrags- bzw. Bearbeitungsnummer zuweisen / übermitteln"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications.<p>See comments for NA - Number Assigned."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "See comments for NA - Number Assigned."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1401",
      "code" : "SQ",
      "display" : "Supplemented as requested",
      "definition" : "Supplementation confirmation message indicating that an order was supplemented as requested.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "This code is used in the acknowledgment  response to the request messages."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "1402",
      "code" : "SR",
      "display" : "Response to send order/service status request",
      "definition" : "Response to send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsstatus (Antwort)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1403",
      "code" : "SS",
      "display" : "Send order/service status request",
      "definition" : "Send order/service status request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsstatus senden"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1404",
      "code" : "SU",
      "display" : "Supplement this order",
      "definition" : "Identifies existing orders to be supplemented in Supplementation Recommendation (filler to placer) and Supplementation Request (placer to filler) messages.",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "For example this code is used in the filler’s order message to identify an order that is missing a recommended order based on organizational protocol for example as described in the IHE Laboratory Communication (LCC) profile (LAB-6)."
        },
        {
          "code" : "status",
          "valueCode" : "N"
        }
      ]
    },
    {
      "id" : "1405",
      "code" : "UA",
      "display" : "Unable to accept order/service",
      "definition" : "Unable to accept order/service",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsannahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.\r\nAn unable to accept code is used when a new order cannot be accepted by the filler. Possible reasons include requesting a prescription for a drug which the patient is allergic to or for an order which requires certain equipment resources which are not available such that the order cannot be filled. Note that this is different from the communication level acceptance as defined within the MSA segment."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1406",
      "code" : "UC",
      "display" : "Unable to cancel",
      "definition" : "Unable to cancel",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftragsstornierung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler or Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler or Placer Applications.\r\nAn unable-to-cancel code is used when the ordered service is at a point that it cannot be canceled by the placer or filler or when local rules prevent cancellation by the filler. The use of this code is dependent on the value of ORC-6-response flag.\r\nIf the filler initiated the request to cancel and the placer is unable to cancel while the filler cannot proceed with the fulfillment of that order, then the necessary communication to resolve the conflict is outside the scope of these messages."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1407",
      "code" : "UD",
      "display" : "Unable to discontinue",
      "definition" : "Unable to discontinue",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Abbrechen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler or Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler or Placer Applications.\r\nAn unable-to-discontinue code is used when the ordered service is at a point that it cannot be discontinued by the placer or filler or when local rules prevent discontinuance by the filler. The use of this code is dependent on the value of ORC-6-response flag.\r\nIf the filler initiated the request to discontinue and the placer is unable to discontinue while the filler cannot proceed with the fulfillment of that order, then the necessary communication to resolve the conflict is outside the scope of these messages."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1408",
      "code" : "UF",
      "display" : "Unable to refill",
      "definition" : "Unable to refill",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications.<p>Negative response to RF Refill order/service request, indicating that the receiving application was not able to complete the refill request."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Negative response to RF Refill order/service request, indicating that the receiving application was not able to complete the refill request."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1409",
      "code" : "UH",
      "display" : "Unable to put on hold",
      "definition" : "Unable to put on hold",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aussetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1410",
      "code" : "UM",
      "display" : "Unable to replace",
      "definition" : "Unable to replace",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ersetzen nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1411",
      "code" : "UN",
      "display" : "Unlink order/service from patient care problem or goal",
      "definition" : "Unlink order/service from patient care problem or goal",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer or Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer or Filler Applications.<p>Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "HL7usageNotes",
          "valueString" : "Refer to Chapter 12 Patient Care for complete discussion."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1412",
      "code" : "UR",
      "display" : "Unable to release",
      "definition" : "Unable to release",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Wiederaufnahme nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1413",
      "code" : "UX",
      "display" : "Unable to change",
      "definition" : "Unable to change",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Änderung nicht möglich"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1414",
      "code" : "XO",
      "display" : "Change order/service request",
      "definition" : "Change order/service request",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag ändern"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Placer Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1415",
      "code" : "XR",
      "display" : "Changed as requested",
      "definition" : "Changed as requested",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag anweisungsgemäß geändert"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    },
    {
      "id" : "1416",
      "code" : "XX",
      "display" : "Order/service changed, unsol.",
      "definition" : "Order/service changed, unsol.",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag geändert (ohne Anweisung)"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Filler Applications."
        },
        {
          "code" : "status",
          "valueCode" : "active"
        }
      ]
    }
  ]
}

```
