# PH_RaceAndEthnicity_CDC - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PH_RaceAndEthnicity_CDC**

## CodeSystem: PH_RaceAndEthnicity_CDC 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0005 | *Version*:3.0.0 | |
| Retired as of 2021-09-01 | *Responsible:*[The US Centers For Disease Control and Prevention (CDC)](http://www.hl7.org/) | *Computable Name*:PHRaceAndEthnicityCDC |
| *Other Identifiers:*OID:2.16.840.1.113883.6.238 | | |
| **Copyright/Legal**: Copyright HL7. Licensed under creative commons public domain | | |

 
Code system of concepts specifying the patient's race. Used in HL7 Version 2.x messages in the PID segment. 
This code system includes codes used decades ago are are maintained here for historical purposes such as searching in past history records. These codes were formally deprecated in V2.9 and retired in THO in 2021. Please reference http://build.fhir.org/ig/HL7/UTG/CodeSystem-CDCREC for the current CDC Race and Ethnicity code system. 

 
Underlying Master Code System for V2 table 0005 (Race) 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Properties**

**This code system defines the following properties for its concepts**

**Concepts**

This case-sensitive code system `http://terminology.hl7.org/CodeSystem/v2-0005` provides **a fragment** that includes following codes in a Is-A hierarchy:

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0005",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0005",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.6.238"
    }
  ],
  "version" : "3.0.0",
  "name" : "PHRaceAndEthnicityCDC",
  "title" : "PH_RaceAndEthnicity_CDC",
  "status" : "retired",
  "experimental" : false,
  "date" : "2021-09-01",
  "publisher" : "The US Centers For Disease Control and Prevention (CDC)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the patient's race.  Used in HL7 Version 2.x messages in the PID segment.\r\n\r\nThis code system includes codes used decades ago are are maintained here for historical purposes such as searching in past history records. These codes were formally deprecated in V2.9 and retired in THO in 2021. Please reference http://build.fhir.org/ig/HL7/UTG/CodeSystem-CDCREC for the current CDC Race and Ethnicity code system.",
  "purpose" : "Underlying Master Code System for V2 table 0005 (Race)",
  "copyright" : "Copyright HL7. Licensed under creative commons public domain",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "fragment",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "516",
      "code" : "B",
      "display" : "Black",
      "definition" : "Black",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Schwarzer"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "517",
      "code" : "C",
      "display" : "Caucasian",
      "definition" : "Caucasian",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kaukasier"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "518",
      "code" : "H",
      "display" : "Hispanic",
      "definition" : "Hispanic",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Hispanier"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "519",
      "code" : "R",
      "display" : "Oriental",
      "definition" : "Oriental",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Orientale"
        }
      ],
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    },
    {
      "id" : "521",
      "code" : "...",
      "display" : "see chapter 3",
      "definition" : "see chapter 3",
      "property" : [
        {
          "code" : "v2-table-deprecated",
          "valueCode" : "2.9"
        },
        {
          "code" : "status",
          "valueCode" : "deprecated"
        }
      ]
    }
  ]
}

```
