# Subscription Error Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subscription Error Codes**

## CodeSystem: Subscription Error Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/subscription-error | *Version*:1.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubscriptionErrorCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1438 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes to represent subscription error details 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SubscriptionErrorCodes](ValueSet-subscription-error.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subscription-error",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fhir"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/subscription-error",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1438"
    }
  ],
  "version" : "1.0.1",
  "name" : "SubscriptionErrorCodes",
  "title" : "Subscription Error Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes to represent subscription error details",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/subscription-error",
  "content" : "complete",
  "concept" : [
    {
      "code" : "dns-resolution-error",
      "display" : "DNS resolution error",
      "definition" : "DNS resolution error for client rest-hook endpoint."
    },
    {
      "code" : "no-response",
      "display" : "No response",
      "definition" : "No response for client rest-hook endpoint."
    },
    {
      "code" : "error-response",
      "display" : "Error response",
      "definition" : "Error response from client rest-hook endpoint. Recommended practice: convey the actual HTTP error in an adjacent Coding or in text"
    }
  ]
}

```
