# Research Study Status - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Research Study Status**

## CodeSystem: Research Study Status 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-status | *Version*:1.0.0 | | |
| Active as of 2021-01-05 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.4.820 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Codes that convey the current status of the research study. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyStatus](ValueSet-research-study-status.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-status",
  "meta" : {
    "lastUpdated" : "2025-11-15T01:54:02+05:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.4.820"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyStatus",
  "title" : "Research Study Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-01-05T10:01:24+11:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes that convey the current status of the research study.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "overall-study",
      "display" : "Overall study",
      "definition" : "Used for documenting the start and end of the overall study, distinct from progress      states."
    },
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "Study is opened for accrual."
    },
    {
      "code" : "active-but-not-recruiting",
      "display" : "Active, not recruiting",
      "definition" : "The study is ongoing, and participants are receiving an intervention or being examined,      but potential participants are not currently being recruited or enrolled."
    },
    {
      "code" : "administratively-completed",
      "display" : "Administratively Completed",
      "definition" : "Study is completed prematurely and will not resume; patients are no longer examined      nor treated."
    },
    {
      "code" : "approved",
      "display" : "Approved",
      "definition" : "Protocol is approved by the review board."
    },
    {
      "code" : "closed-to-accrual",
      "display" : "Closed to Accrual",
      "definition" : "Study is closed for accrual; patients can be examined and treated."
    },
    {
      "code" : "closed-to-accrual-and-intervention",
      "display" : "Closed to Accrual and Intervention",
      "definition" : "Study is closed to accrual and intervention, i.e. the study is closed to enrollment,      all study subjects have completed treatment or intervention but are still being      followed according to the primary objective of the study."
    },
    {
      "code" : "completed",
      "display" : "Completed",
      "definition" : "The study closed according to the study plan. There will be no further treatments,      interventions or data collection."
    },
    {
      "code" : "disapproved",
      "display" : "Disapproved",
      "definition" : "Protocol was disapproved by the review board."
    },
    {
      "code" : "enrolling-by-invitation",
      "display" : "Enrolling by invitation",
      "definition" : "The study is selecting its participants from a population, or group of people,      decided on by the researchers in advance. These studies are not open to everyone      who meets the eligibility criteria but only to people in that particular population,      who are specifically invited to participate."
    },
    {
      "code" : "in-review",
      "display" : "In Review",
      "definition" : "Protocol is submitted to the review board for approval."
    },
    {
      "code" : "not-yet-recruiting",
      "display" : "Not yet recruiting",
      "definition" : "The study has not started recruiting participants."
    },
    {
      "code" : "recruiting",
      "display" : "Recruiting",
      "definition" : "The study is currently recruiting participants."
    },
    {
      "code" : "temporarily-closed-to-accrual",
      "display" : "Temporarily Closed to Accrual",
      "definition" : "Study is temporarily closed for accrual; can be potentially resumed in the future;      patients can be examined and treated."
    },
    {
      "code" : "temporarily-closed-to-accrual-and-intervention",
      "display" : "Temporarily Closed to Accrual and Intervention",
      "definition" : "Study is temporarily closed for accrual and intervention and potentially can be      resumed in the future."
    },
    {
      "code" : "terminated",
      "display" : "Terminated",
      "definition" : "The study has stopped early and will not start again. Participants are no longer      being examined or treated."
    },
    {
      "code" : "withdrawn",
      "display" : "Withdrawn",
      "definition" : "Protocol was withdrawn by the lead organization."
    }
  ]
}

```
