# MedicationKnowledge Status Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationKnowledge Status Codes**

## CodeSystem: MedicationKnowledge Status Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationknowledge-status | *Version*:1.0.0 | | |
| Draft as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationKnowledgeStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1336 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
MedicationKnowledge Status Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationKnowledgeStatusCodes](ValueSet-medicationknowledge-status.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationknowledge-status",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationknowledge-status",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1336"
    }
  ],
  "version" : "1.0.0",
  "name" : "MedicationKnowledgeStatusCodes",
  "title" : "MedicationKnowledge Status Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationKnowledge Status Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationknowledge-status",
  "content" : "complete",
  "concept" : [
    {
      "code" : "active",
      "display" : "Active",
      "definition" : "The medication is available for use."
    },
    {
      "code" : "inactive",
      "display" : "Inactive",
      "definition" : "The medication is not available for use."
    },
    {
      "code" : "entered-in-error",
      "display" : "Entered in Error",
      "definition" : "The medication was entered in error."
    }
  ]
}

```
