# MedicationDispense Performer Function Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationDispense Performer Function Codes**

## CodeSystem: MedicationDispense Performer Function Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medicationdispense-performer-function | *Version*:1.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationDispensePerformerFunctionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1319 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
MedicationDispense Performer Function Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationDispensePerformerFunctionCodes](ValueSet-medicationdispense-performer-function.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medicationdispense-performer-function",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medicationdispense-performer-function",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1319"
    }
  ],
  "version" : "1.0.1",
  "name" : "MedicationDispensePerformerFunctionCodes",
  "title" : "MedicationDispense Performer Function Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationDispense Performer Function Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medicationdispense-performer-function",
  "content" : "complete",
  "concept" : [
    {
      "code" : "dataenterer",
      "display" : "Data Enterer",
      "definition" : "Recorded the details of the request"
    },
    {
      "code" : "packager",
      "display" : "Packager",
      "definition" : "Prepared the medication."
    },
    {
      "code" : "checker",
      "display" : "Checker",
      "definition" : "Performed initial quality assurance on the prepared medication"
    },
    {
      "code" : "finalchecker",
      "display" : "Final Checker",
      "definition" : "Performed the final quality assurance on the prepared medication against the request. Typically, this is a pharmacist function."
    },
    {
      "code" : "counsellor",
      "display" : "Counsellor",
      "definition" : "Provided the drug information to the patient at the time of dispensing."
    }
  ]
}

```
