# Implant Status - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Implant Status**

## CodeSystem: Implant Status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/implantStatus | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ImplantStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1283 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
A set codes that define the functional status of an implanted device. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ImplantStatus](ValueSet-implantStatus.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "implantStatus",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/implantStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1283"
    }
  ],
  "version" : "1.0.0",
  "name" : "ImplantStatus",
  "title" : "Implant Status",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "A set codes that define the functional status of an implanted device.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/implantStatus",
  "content" : "complete",
  "concept" : [
    {
      "code" : "functional",
      "display" : "Functional",
      "definition" : "The implanted device is working normally."
    },
    {
      "code" : "non-functional",
      "display" : "Non-Functional",
      "definition" : "The implanted device is not working."
    },
    {
      "code" : "disabled",
      "display" : "Disabled",
      "definition" : "The implanted device has been turned off."
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "the functional status of the implant has not been determined."
    }
  ]
}

```
