# GuideParameterCode - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GuideParameterCode**

## CodeSystem: GuideParameterCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/guide-parameter-code | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:GuideParameterCode |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1421 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code of parameter that is input to the guide. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [GuideParameterCode](ValueSet-guide-parameter-code.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "guide-parameter-code",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/guide-parameter-code",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1421"
    }
  ],
  "version" : "1.0.0",
  "name" : "GuideParameterCode",
  "title" : "GuideParameterCode",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code of parameter that is input to the guide.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/guide-parameter-code",
  "content" : "complete",
  "concept" : [
    {
      "code" : "apply",
      "display" : "Apply Metadata Value",
      "definition" : "If the value of this string 0..* parameter is one of the metadata fields then all conformance resources will have any specified [Resource].[field] overwritten with the ImplementationGuide.[field], where field is one of: version, date, status, publisher, contact, copyright, experimental, jurisdiction, useContext."
    },
    {
      "code" : "path-resource",
      "display" : "Resource Path",
      "definition" : "The value of this string 0..* parameter is a subfolder of the build context's location that is to be scanned to load resources. Scope is (if present) a particular resource type."
    },
    {
      "code" : "path-pages",
      "display" : "Pages Path",
      "definition" : "The value of this string 0..1 parameter is a subfolder of the build context's location that contains files that are part of the html content processed by the builder."
    },
    {
      "code" : "path-tx-cache",
      "display" : "Terminology Cache Path",
      "definition" : "The value of this string 0..1 parameter is a subfolder of the build context's location that is used as the terminology cache. If this is not present, the terminology cache is on the local system, not under version control."
    },
    {
      "code" : "expansion-parameter",
      "display" : "Expansion Profile",
      "definition" : "The value of this string 0..* parameter is a parameter (name=value) when expanding value sets for this implementation guide. This is particularly used to specify the versions of published terminologies such as SNOMED CT."
    },
    {
      "code" : "rule-broken-links",
      "display" : "Broken Links Rule",
      "definition" : "The value of this string 0..1 parameter is either \"warning\" or \"error\" (default = \"error\"). If the value is \"warning\" then IG build tools allow the IG to be considered successfully build even when there is no internal broken links."
    },
    {
      "code" : "generate-xml",
      "display" : "Generate XML",
      "definition" : "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in XML format. If not present, the Publication Tool decides whether to generate XML."
    },
    {
      "code" : "generate-json",
      "display" : "Generate JSON",
      "definition" : "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in JSON format. If not present, the Publication Tool decides whether to generate JSON."
    },
    {
      "code" : "generate-turtle",
      "display" : "Generate Turtle",
      "definition" : "The value of this boolean 0..1 parameter specifies whether the IG publisher creates examples in Turtle format. If not present, the Publication Tool decides whether to generate Turtle."
    },
    {
      "code" : "html-template",
      "display" : "HTML Template",
      "definition" : "The value of this string singleton parameter is the name of the file to use as the builder template for each generated page (see templating)."
    }
  ]
}

```
