# CopyNumberEvent - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CopyNumberEvent**

## CodeSystem: CopyNumberEvent 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/copy-number-event | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CopyNumberEvent |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1087 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Copy Number Event. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CopyNumberEvent](ValueSet-copy-number-event.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "copy-number-event",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/copy-number-event",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1087"
    }
  ],
  "version" : "1.0.0",
  "name" : "CopyNumberEvent",
  "title" : "CopyNumberEvent",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Copy Number Event.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/copy-number-event",
  "content" : "complete",
  "concept" : [
    {
      "code" : "amp",
      "display" : "amplification",
      "definition" : "amplification."
    },
    {
      "code" : "del",
      "display" : "deletion",
      "definition" : "deletion."
    },
    {
      "code" : "lof",
      "display" : "loss of function",
      "definition" : "loss of function."
    }
  ]
}

```
