# Contributor Summary Type - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contributor Summary Type**

## CodeSystem: Contributor Summary Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/contributor-summary-type | *Version*:1.0.0 | | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[HL7 (FHIR Project)](http://hl7.org/fhir) | *Computable Name*:ContributorSummaryType |

 
Used to code author list statement, contributorship statement, and such. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ContributorSummaryType](ValueSet-contributor-summary-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "contributor-summary-type",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/contributor-summary-type",
  "version" : "1.0.0",
  "name" : "ContributorSummaryType",
  "title" : "Contributor Summary Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-01-20T16:55:11+11:00",
  "publisher" : "HL7 (FHIR Project)",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org/fhir"
        },
        {
          "system" : "email",
          "value" : "fhir@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Used to code author list statement, contributorship statement, and such.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/contributor-summary-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "author-string",
      "display" : "Author string",
      "definition" : "Display of the author list as a complete string."
    },
    {
      "code" : "contributorship-list",
      "display" : "Contributorship list",
      "definition" : "Display of the list of contributors as a complete string."
    },
    {
      "code" : "contributorship-statement",
      "display" : "Contributorship statement",
      "definition" : "Compiled summary of contributions."
    },
    {
      "code" : "acknowledgement-list",
      "display" : "Acknowledgment list",
      "definition" : "Display of the list of acknowledged parties as a complete string."
    },
    {
      "code" : "acknowledgment-statement",
      "display" : "Acknowledgment statement",
      "definition" : "Statement of acknowledgment of contributions beyond those compiled for formal contributorship statements."
    },
    {
      "code" : "funding-statement",
      "display" : "Funding statement",
      "definition" : "Statement of financial support for the creation of the cited artifact."
    },
    {
      "code" : "competing-interests-statement",
      "display" : "Competing interests statement",
      "definition" : "Statement of completing interests related to the creation of the cited artifact. Also called conflicts of interest or declaration of interests."
    }
  ]
}

```
