# ConformanceExpectation - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ConformanceExpectation**

## CodeSystem: ConformanceExpectation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/conformance-expectation | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ConformanceExpectation |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1271 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ConformanceExpectation](ValueSet-conformance-expectation.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "conformance-expectation",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "url" : "http://terminology.hl7.org/CodeSystem/conformance-expectation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1271"
    }
  ],
  "version" : "1.0.0",
  "name" : "ConformanceExpectation",
  "title" : "ConformanceExpectation",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the degree of adherence to a specified behavior or capability expected for a system to be deemed conformant with a specification.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/conformance-expectation",
  "content" : "complete",
  "concept" : [
    {
      "code" : "SHALL",
      "display" : "SHALL",
      "definition" : "Support for the specified capability is required to be considered conformant."
    },
    {
      "code" : "SHOULD",
      "display" : "SHOULD",
      "definition" : "Support for the specified capability is strongly encouraged, and failure to support it should only occur after careful consideration."
    },
    {
      "code" : "MAY",
      "display" : "MAY",
      "definition" : "Support for the specified capability is not necessary to be considered conformant, and the requirement should be considered strictly optional."
    },
    {
      "code" : "SHOULD-NOT",
      "display" : "SHOULD-NOT",
      "definition" : "Support for the specified capability is strongly discouraged and should occur only after careful consideration."
    }
  ]
}

```
