# Claim Information Category Codes - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Claim Information Category Codes**

## CodeSystem: Claim Information Category Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/claiminformationcategory | *Version*:1.0.1 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ClaimInformationCategoryCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1163 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes sample Information Category codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ClaimInformationCategoryCodes](ValueSet-claim-informationcategory.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "claiminformationcategory",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/claiminformationcategory",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1163"
    }
  ],
  "version" : "1.0.1",
  "name" : "ClaimInformationCategoryCodes",
  "title" : "Claim Information Category Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes sample Information Category codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/claim-informationcategory",
  "content" : "complete",
  "concept" : [
    {
      "code" : "info",
      "display" : "Information",
      "definition" : "Codes conveying additional situation and condition information."
    },
    {
      "code" : "discharge",
      "display" : "Discharge",
      "definition" : "Discharge status and discharge to locations."
    },
    {
      "code" : "onset",
      "display" : "Onset",
      "definition" : "Period, start or end dates of aspects of the Condition."
    },
    {
      "code" : "related",
      "display" : "Related Services",
      "definition" : "Nature and date of the related event e.g. Last exam, service, X-ray etc."
    },
    {
      "code" : "exception",
      "display" : "Exception",
      "definition" : "Insurance policy exceptions."
    },
    {
      "code" : "material",
      "display" : "Materials Forwarded",
      "definition" : "Materials being forwarded, e.g. Models, molds, images, documents."
    },
    {
      "code" : "attachment",
      "display" : "Attachment",
      "definition" : "Materials attached such as images, documents and resources."
    },
    {
      "code" : "missingtooth",
      "display" : "Missing Tooth",
      "definition" : "Teeth which are missing for any reason, for example: prior extraction, never developed."
    },
    {
      "code" : "prosthesis",
      "display" : "Prosthesis",
      "definition" : "The type of prosthesis and date of supply if a previously supplied prosthesis."
    },
    {
      "code" : "other",
      "display" : "Other",
      "definition" : "Other information identified by the type.system."
    },
    {
      "code" : "hospitalized",
      "display" : "Hospitalized",
      "definition" : "An indication that the patient was hospitalized, the period if known otherwise a Yes/No (boolean)."
    },
    {
      "code" : "employmentimpacted",
      "display" : "EmploymentImpacted",
      "definition" : "An indication that the patient was unable to work, the period if known otherwise a Yes/No (boolean)."
    },
    {
      "code" : "externalcause",
      "display" : "External Caause",
      "definition" : "The external cause of an illness or injury."
    },
    {
      "code" : "patientreasonforvisit",
      "display" : "Patient Reason for Visit",
      "definition" : "The reason for the patient visit."
    }
  ]
}

```
