# Care Service Accessibility - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Care Service Accessibility**

## CodeSystem: Care Service Accessibility 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/care-service-accessibility | *Version*:1.0.0 | | |
| Active as of 2025-11-15 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CareServiceAccessibility |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CareServiceAccessibility](ValueSet-care-service-accessibility.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "care-service-accessibility",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/care-service-accessibility",
  "version" : "1.0.0",
  "name" : "CareServiceAccessibility",
  "title" : "Care Service Accessibility",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-15T12:56:11-07:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes that can be used to describe care service accessibility options offered by a practitioner or at a location. ",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/care-service-accessibility",
  "content" : "complete",
  "concept" : [
    {
      "code" : "cultcomp",
      "display" : "cultural competence",
      "definition" : "Provides services that meet the social, cultural, and linguistic needs of persons."
    },
    {
      "code" : "handiaccess",
      "display" : "handicap accessible",
      "definition" : "Provides access to persons with disabilities."
    },
    {
      "code" : "adacomp",
      "display" : "ADA compliant",
      "definition" : "Provides access which complies with the Americans with Disabilities Act and/or amendments."
    },
    {
      "code" : "pubtrans",
      "display" : "public transit options",
      "definition" : "Provides access using public transportation modes."
    },
    {
      "code" : "anssrvc",
      "display" : "answering service",
      "definition" : "Provides capability to communicate when intended recipient is not immediately available."
    },
    {
      "code" : "cognitive",
      "display" : "cognitive",
      "definition" : "Provides services for cognitively impaired persons."
    },
    {
      "code" : "mobility",
      "display" : "mobility",
      "definition" : "Provides services for mobility impaired persons."
    }
  ]
}

```
