# Appropriateness Score - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Appropriateness Score**

## CodeSystem: Appropriateness Score 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/appropriateness-score | *Version*:2.0.0 | |
| Active as of 2022-10-18 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AppropriatenessScore |
| *Other Identifiers:*http://hl7.org/fhir/us/qicore/CodeSystem/appropriateness-score (use: old, ) | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The scoring for appropriateness of an action based upon RAND. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AppropriatenessScore](ValueSet-appropriateness-score.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "appropriateness-score",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "url" : "http://terminology.hl7.org/CodeSystem/appropriateness-score",
  "identifier" : [
    {
      "use" : "old",
      "value" : "http://hl7.org/fhir/us/qicore/CodeSystem/appropriateness-score"
    }
  ],
  "version" : "2.0.0",
  "name" : "AppropriatenessScore",
  "title" : "Appropriateness Score",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-10-18",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The scoring for appropriateness of an action based upon RAND.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/appropriateness-score",
  "content" : "complete",
  "concept" : [
    {
      "code" : "extremely-inappropriate",
      "display" : "Extremely Inappropriate",
      "definition" : "The action is extremely inappropriate"
    },
    {
      "code" : "inappropriate",
      "display" : "Inappropriate",
      "definition" : "The action is inappropriate"
    },
    {
      "code" : "probably-inappropriate",
      "display" : "Probably Inappropriate",
      "definition" : "The action is probably inappropriate"
    },
    {
      "code" : "uncertain-inappropriate",
      "display" : "Uncertain Inappropriate",
      "definition" : "The appropriateness of the action is uncertain, leaning towards inappropriate"
    },
    {
      "code" : "uncertain",
      "display" : "Uncertain",
      "definition" : "The appropriateness of the action is uncertain"
    },
    {
      "code" : "uncertain-appropriate",
      "display" : "Uncertain Appropriate",
      "definition" : "The appropriateness of the action is uncertain, leaning towards appropriate"
    },
    {
      "code" : "probably-appropriate",
      "display" : "Probably Appropriate",
      "definition" : "The action is probably appropriate"
    },
    {
      "code" : "appropriate",
      "display" : "Appropriate",
      "definition" : "The action is appropriate"
    },
    {
      "code" : "extremely-appropriate",
      "display" : "Extremely Appropriate",
      "definition" : "The action is extremely appropriate"
    }
  ]
}

```
