# AdverseEventCausalityMethod - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AdverseEventCausalityMethod**

## CodeSystem: AdverseEventCausalityMethod 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/adverse-event-causality-method | *Version*:2.0.0 | | |
| Active as of 2024-08-28 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AdverseEventCausalityMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1255 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This code system contains methods for assessing causality. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AdverseEventCausalityMethod](ValueSet-adverse-event-causality-method.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "adverse-event-causality-method",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/adverse-event-causality-method",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1255"
    }
  ],
  "version" : "2.0.0",
  "name" : "AdverseEventCausalityMethod",
  "title" : "AdverseEventCausalityMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-08-28T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system contains methods for assessing causality.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/adverse-event-causality-method",
  "content" : "complete",
  "concept" : [
    {
      "code" : "probability-scale",
      "display" : "Probability Scale",
      "definition" : "A scale for assessing the probability of causality."
    },
    {
      "code" : "bayesian",
      "display" : "Bayesian",
      "definition" : "Analysis technique using prior and posterior distribution to assess the probability of causality."
    },
    {
      "code" : "checklist",
      "display" : "Checklist",
      "definition" : "A list of criteria used to assess the probability of causality."
    }
  ]
}

```
