# ADA Universal Tooth Designation System - HL7 Terminology (THO) v7.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ADA Universal Tooth Designation System**

## CodeSystem: ADA Universal Tooth Designation System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ADAUniversalToothDesignationSystem | *Version*:1.0.1 | |
| Active as of 2024-05-23 | *Responsible:*American Dental Association | *Computable Name*:ADAUniversalToothDesignationSystem |
| **Copyright/Legal**: No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf | | |

 
The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994. 
The universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America. 
Teeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32). 
Supernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32). 
The Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. 
A Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ADAUniversalToothDesignationSystem",
  "url" : "http://terminology.hl7.org/CodeSystem/ADAUniversalToothDesignationSystem",
  "version" : "1.0.1",
  "name" : "ADAUniversalToothDesignationSystem",
  "title" : "ADA Universal Tooth Designation System",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-05-23T00:00:00-00:00",
  "publisher" : "American Dental Association",
  "contact" : [
    {
      "name" : "American Dental Association; 211 East Chicago Avenue Chicago, IL 60610-2678"
    }
  ],
  "description" : "The American Dental Association (ADA) accepted the Universal/National Tooth Designation System and the ISO/ANSI/ADA Specification No. 3950 for Designation System for Teeth and Areas of the Oral Cavity as the human tooth and oral cavity enumeration schemas in 1994.\r\n\r\nThe universal tooth designation or numbering system is accepted and approved by the ADA and is the most commonly used system used by dental professionals in America.\r\n\r\nTeeth are numbered 1-32, starting with the third molar (1) on the right side of the upper arch, following around the arch to the third molar (16) on the left side, and descending to the lower third molar (17) on the left side, and following that arch to the terminus of the lower jaw, the lower right third molar (32).\r\n\r\nSupernumerary teeth are identified by the numbers 51 through 82, beginning with the area of the upper right third molar, following around the upper arch and continuing on the lower arch to the area of the lower right third molar (e.g., supernumerary #51 is adjacent to the upper right molar #1; supernumerary #82 is adjacent to the lower right third molar #32).\r\n\r\nThe Universal Numbering System can be found in the ADA Dental Claim Form. For more information see here: https://www.ada.org/publications/cdt/ada-dental-claim-form. \r\n\r\nA Statement of Understanding (SOU) between ADA and HL7 exists here: http://www.hl7.org/documentcenter/public/mou/ADA%20HL7%20SOU%202021_signed.pdf",
  "copyright" : "No official copyright statement is available. For general information see paper form located here : https://www.ada.org/-/media/project/ada-organization/ada/ada-org/files/publications/cdt/v2019adadentalclaimcompletioninstructions_v3_2022feb.pdf",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "Permanent maxillary right third molar tooth",
      "definition" : "Permanent maxillary right third molar tooth; Universal designation 1; ISO designation 18"
    },
    {
      "code" : "2",
      "display" : "Permanent maxillary right second molar tooth",
      "definition" : "Permanent maxillary right second molar tooth; Universal designation 2; ISO designation 17"
    },
    {
      "code" : "3",
      "display" : "Permanent maxillary right first molar tooth",
      "definition" : "Permanent maxillary right first molar tooth; Universal designation 3; ISO designation 16"
    },
    {
      "code" : "4",
      "display" : "Permanent maxillary right second premolar tooth",
      "definition" : "Permanent maxillary right second premolar tooth; Universal designation 4; ISO designation 15"
    },
    {
      "code" : "5",
      "display" : "Permanent maxillary right first premolar tooth",
      "definition" : "Permanent maxillary right first premolar tooth; Universal designation 5; ISO designation 14"
    },
    {
      "code" : "6",
      "display" : "Permanent maxillary right canine tooth",
      "definition" : "Permanent maxillary right canine tooth; Universal designation 6; ISO designation 13"
    },
    {
      "code" : "7",
      "display" : "Permanent maxillary right lateral incisor tooth",
      "definition" : "Permanent maxillary right lateral incisor tooth; Universal designation 7; ISO designation 12"
    },
    {
      "code" : "8",
      "display" : "Permanent maxillary right central incisor tooth",
      "definition" : "Permanent maxillary right central incisor tooth; Universal designation 8; ISO designation 11"
    },
    {
      "code" : "9",
      "display" : "Permanent maxillary left central incisor tooth",
      "definition" : "Permanent maxillary left central incisor tooth; Universal designation 9; ISO designation 21"
    },
    {
      "code" : "10",
      "display" : "Permanent maxillary left lateral incisor tooth",
      "definition" : "Permanent maxillary left lateral incisor tooth; Universal designation 10; ISO designation 22"
    },
    {
      "code" : "11",
      "display" : "Permanent maxillary left canine tooth",
      "definition" : "Permanent maxillary left canine tooth; Universal designation 11; ISO designation 23"
    },
    {
      "code" : "12",
      "display" : "Permanent maxillary left first premolar tooth",
      "definition" : "Permanent maxillary left first premolar tooth; Universal designation 12; ISO designation 24"
    },
    {
      "code" : "13",
      "display" : "Permanent maxillary left second premolar tooth",
      "definition" : "Permanent maxillary left second premolar tooth; Universal designation 13; ISO designation 25"
    },
    {
      "code" : "14",
      "display" : "Permanent maxillary left first molar tooth",
      "definition" : "Permanent maxillary left first molar tooth; Universal designation 14; ISO designation 26"
    },
    {
      "code" : "15",
      "display" : "Permanent maxillary left second molar tooth",
      "definition" : "Permanent maxillary left second molar tooth; Universal designation 15; ISO designation 27"
    },
    {
      "code" : "16",
      "display" : "Permanent maxillary left third molar tooth",
      "definition" : "Permanent maxillary left third molar tooth; Universal designation 16; ISO designation 28"
    },
    {
      "code" : "17",
      "display" : "Permanent mandibular left third molar tooth",
      "definition" : "Permanent mandibular left third molar tooth; Universal designation 17; ISO designation 38"
    },
    {
      "code" : "18",
      "display" : "Permanent mandibular left second molar tooth",
      "definition" : "Permanent mandibular left second molar tooth; Universal designation 18; ISO designation 37"
    },
    {
      "code" : "19",
      "display" : "Permanent mandibular left second molar tooth",
      "definition" : "Permanent mandibular left first molar tooth; Universal designation 19; ISO designation 36"
    },
    {
      "code" : "20",
      "display" : "Permanent mandibular left second premolar tooth",
      "definition" : "Permanent mandibular left second premolar tooth; Universal designation 20; ISO designation 35"
    },
    {
      "code" : "21",
      "display" : "Permanent mandibular lower left first premolar tooth",
      "definition" : "Permanent mandibular left first premolar tooth; Universal designation 21; ISO designation 34"
    },
    {
      "code" : "22",
      "display" : "Permanent mandibular left canine tooth",
      "definition" : "Permanent mandibular left canine tooth; Universal designation 22; ISO designation 33"
    },
    {
      "code" : "23",
      "display" : "Permanent mandibular left lateral incisor tooth",
      "definition" : "Permanent mandibular left lateral incisor tooth; Universal designation 23; ISO designation 32"
    },
    {
      "code" : "24",
      "display" : "Permanent mandibular left central incisor tooth",
      "definition" : "Permanent mandibular left central incisor tooth; Universal designation 24; ISO designation 31"
    },
    {
      "code" : "25",
      "display" : "Permanent mandibular right central incisor tooth",
      "definition" : "Permanent mandibular right central incisor tooth; Universal designation 25; ISO designation 41"
    },
    {
      "code" : "26",
      "display" : "Permanent mandibular right lateral incisor tooth",
      "definition" : "Permanent mandibular right lateral incisor tooth; Universal designation 26; ISO designation 42"
    },
    {
      "code" : "27",
      "display" : "Permanent mandibular right canine tooth",
      "definition" : "Permanent mandibular right canine tooth; Universal designation 27; ISO designation 43"
    },
    {
      "code" : "28",
      "display" : "Permanent mandibular right first premolar tooth",
      "definition" : "Permanent mandibular right first premolar tooth; Universal designation 28; ISO designation 44"
    },
    {
      "code" : "29",
      "display" : "Permanent mandibular right second premolar tooth",
      "definition" : "Permanent mandibular right second premolar tooth; Universal designation 29; ISO designation 45"
    },
    {
      "code" : "30",
      "display" : "Permanent mandibular right first molar tooth",
      "definition" : "Permanent mandibular right first molar tooth; Universal designation 30; ISO designation 46"
    },
    {
      "code" : "31",
      "display" : "Permanent mandibular right second molar tooth",
      "definition" : "Permanent mandibular right second molar tooth; Universal designation 31; ISO designation 47"
    },
    {
      "code" : "32",
      "display" : "Permanent mandibular right third molar tooth",
      "definition" : "Permanent mandibular right third molar tooth; Universal designation 32; ISO designation 48"
    },
    {
      "code" : "51",
      "display" : "Supernumerary permanent maxillary right third molar tooth",
      "definition" : "Supernumerary permanent maxillary right third molar tooth, Universal designation 51"
    },
    {
      "code" : "52",
      "display" : "Supernumerary permanent maxillary right second molar tooth",
      "definition" : "Supernumerary permanent maxillary right second molar tooth; Universal designation 52"
    },
    {
      "code" : "53",
      "display" : "Supernumerary permanent maxillary right first molar tooth",
      "definition" : "Supernumerary permanent maxillary right first molar tooth; Universal designation 53"
    },
    {
      "code" : "54",
      "display" : "Supernumerary permanent maxillary right second premolar tooth",
      "definition" : "Supernumerary permanent maxillary right second premolar tooth; Universal designation 54"
    },
    {
      "code" : "55",
      "display" : "Supernumerary permanent maxillary right first premolar tooth",
      "definition" : "Supernumerary permanent maxillary right first premolar tooth; Universal designation 55"
    },
    {
      "code" : "56",
      "display" : "Supernumerary permanent maxillary right canine tooth",
      "definition" : "Supernumerary permanent maxillary right canine tooth; Universal designation 56"
    },
    {
      "code" : "57",
      "display" : "Supernumerary permanent maxillary right lateral incisor tooth",
      "definition" : "Supernumerary permanent maxillary right lateral incisor tooth; Universal designation 57"
    },
    {
      "code" : "58",
      "display" : "Supernumerary permanent maxillary right central incisor tooth",
      "definition" : "Supernumerary permanent maxillary right central incisor tooth; Universal designation 58"
    },
    {
      "code" : "59",
      "display" : "Supernumerary permanent maxillary left central incisor tooth",
      "definition" : "Supernumerary permanent maxillary left central incisor tooth; Universal designation 59"
    },
    {
      "code" : "60",
      "display" : "Supernumerary permanent maxillary left lateral incisor tooth",
      "definition" : "Supernumerary permanent maxillary left lateral incisor tooth; Universal designation 60"
    },
    {
      "code" : "61",
      "display" : "Supernumerary permanent maxillary left canine tooth",
      "definition" : "Supernumerary permanent maxillary left canine tooth; Universal designation 61"
    },
    {
      "code" : "62",
      "display" : "Supernumerary permanent maxillary left first premolar tooth",
      "definition" : "Supernumerary permanent maxillary left first premolar tooth, Universal designation 62"
    },
    {
      "code" : "63",
      "display" : "Supernumerary permanent maxillary left second premolar tooth",
      "definition" : "Supernumerary permanent maxillary left second premolar tooth; Universal designation 63"
    },
    {
      "code" : "64",
      "display" : "Supernumerary permanent maxillary left first molar tooth",
      "definition" : "Supernumerary permanent maxillary left first molar tooth; Universal designation 64"
    },
    {
      "code" : "65",
      "display" : "Supernumerary permanent maxillary left second molar tooth",
      "definition" : "Supernumerary permanent maxillary left second molar tooth; Universal designation 65"
    },
    {
      "code" : "66",
      "display" : "Supernumerary permanent maxillary left third molar tooth",
      "definition" : "Supernumerary permanent maxillary left third molar tooth; Universal designation 66"
    },
    {
      "code" : "67",
      "display" : "Supernumerary permanent mandibular left third molar tooth",
      "definition" : "Supernumerary permanent mandibular left third molar tooth; Universal designation 67"
    },
    {
      "code" : "68",
      "display" : "Supernumerary permanent mandibular left second molar tooth",
      "definition" : "Supernumerary permanent mandibular left second molar tooth; Universal designation 68"
    },
    {
      "code" : "69",
      "display" : "Supernumerary permanent mandibular left first molar tooth",
      "definition" : "Supernumerary permanent mandibular left first molar tooth; Universal designation 69"
    },
    {
      "code" : "70",
      "display" : "Supernumerary permanent mandibular left second premolar tooth",
      "definition" : "Supernumerary permanent mandibular left second premolar tooth; Universal designation 70"
    },
    {
      "code" : "71",
      "display" : "Supernumerary permanent mandibular left first premolar tooth",
      "definition" : "Supernumerary permanent mandibular left first premolar tooth ; Universal designation 71"
    },
    {
      "code" : "72",
      "display" : "Supernumerary permanent mandibular left canine tooth",
      "definition" : "Supernumerary permanent mandibular left canine tooth; Universal designation 72"
    },
    {
      "code" : "73",
      "display" : "Supernumerary permanent mandibular left lateral incisor tooth",
      "definition" : "Supernumerary permanent mandibular left lateral incisor tooth; Universal designation 73"
    },
    {
      "code" : "74",
      "display" : "Supernumerary permanent mandibular left central incisor tooth",
      "definition" : "Supernumerary permanent mandibular left central incisor tooth; Universal designation 74"
    },
    {
      "code" : "75",
      "display" : "Supernumerary permanent mandibular right central incisor tooth",
      "definition" : "Supernumerary permanent mandibular right central incisor tooth; Universal designation 75"
    },
    {
      "code" : "76",
      "display" : "Supernumerary permanent mandibular right lateral incisor tooth",
      "definition" : "Supernumerary permanent mandibular right lateral incisor tooth; Universal designation 76"
    },
    {
      "code" : "77",
      "display" : "Supernumerary permanent mandibular right canine tooth",
      "definition" : "Supernumerary permanent mandibular right canine tooth; Universal designation 77"
    },
    {
      "code" : "78",
      "display" : "Supernumerary permanent mandibular right first premolar tooth",
      "definition" : "Supernumerary permanent mandibular right first premolar tooth; Universal designation 78"
    },
    {
      "code" : "79",
      "display" : "Supernumerary permanent mandibular right second premolar tooth",
      "definition" : "Supernumerary permanent mandibular right second premolar tooth; Universal designation 79"
    },
    {
      "code" : "80",
      "display" : "Supernumerary permanent mandibular right first molar tooth",
      "definition" : "Supernumerary permanent mandibular right first molar tooth; Universal designation 80"
    },
    {
      "code" : "81",
      "display" : "Supernumerary permanent mandibular right second molar tooth",
      "definition" : "Supernumerary permanent mandibular right second molar tooth; Universal designation 81"
    },
    {
      "code" : "82",
      "display" : "Supernumerary permanent mandibular right third molar tooth",
      "definition" : "Supernumerary permanent mandibular right third molar tooth; Universal designation 82"
    },
    {
      "code" : "A",
      "display" : "Deciduous maxillary right second molar tooth",
      "definition" : "Deciduous maxillary right second molar tooth; Universal designation A; ISO designation 55"
    },
    {
      "code" : "B",
      "display" : "Deciduous maxillary right first molar tooth",
      "definition" : "Deciduous maxillary right first molar tooth; Universal designation B; ISO designation 54"
    },
    {
      "code" : "C",
      "display" : "Deciduous maxillary right canine tooth",
      "definition" : "Deciduous maxillary right canine tooth; Universal designation C; ISO designation 53"
    },
    {
      "code" : "D",
      "display" : "Deciduous maxillary upper right lateral incisor tooth",
      "definition" : "Deciduous maxillary right lateral incisor tooth; Universal designation D; ISO designation 52"
    },
    {
      "code" : "E",
      "display" : "Deciduous maxillary right central incisor tooth",
      "definition" : "Deciduous maxillary right central incisor tooth; Universal designation E; ISO designation 51"
    },
    {
      "code" : "F",
      "display" : "Deciduous maxillary left central incisor tooth",
      "definition" : "Deciduous maxillary left central incisor tooth; Universal designation F; ISO designation 61"
    },
    {
      "code" : "G",
      "display" : "Deciduous maxillary left lateral incisor tooth",
      "definition" : "Deciduous maxillary left lateral incisor tooth; Universal designation G; ISO designation 62"
    },
    {
      "code" : "H",
      "display" : "Deciduous maxillary left canine tooth",
      "definition" : "Deciduous maxillary left canine tooth; Universal designation H; ISO designation 63"
    },
    {
      "code" : "I",
      "display" : "Deciduous maxillary left first molar tooth",
      "definition" : "Deciduous maxillary left first molar tooth; Universal designation I; ISO designation 64"
    },
    {
      "code" : "J",
      "display" : "Deciduous maxillary left second molar tooth",
      "definition" : "Deciduous maxillary left second molar tooth; Universal designation J; ISO designation 65"
    },
    {
      "code" : "K",
      "display" : "Deciduous mandibular left second molar tooth",
      "definition" : "Deciduous mandibular left second molar tooth; Universal designation K; ISO designation 75"
    },
    {
      "code" : "L",
      "display" : "Deciduous mandibular left first molar tooth",
      "definition" : "Deciduous mandibular left first molar tooth; Universal designation L; ISO designation 74"
    },
    {
      "code" : "M",
      "display" : "Deciduous mandibular left canine tooth",
      "definition" : "Deciduous mandibular left canine tooth; Universal designation M; ISO designation 73"
    },
    {
      "code" : "N",
      "display" : "Deciduous mandibular left lateral incisor tooth",
      "definition" : "Deciduous mandibular left lateral incisor tooth; Universal designation N; ISO designation 72"
    },
    {
      "code" : "O",
      "display" : "Deciduous mandibular left central incisor tooth",
      "definition" : "Deciduous mandibular left central incisor tooth: Universal designation O; ISO designation 71"
    },
    {
      "code" : "P",
      "display" : "Deciduous mandibular right central incisor tooth",
      "definition" : "Deciduous mandibular right central incisor tooth; Universal designation P; ISO designation 81"
    },
    {
      "code" : "Q",
      "display" : "Deciduous mandibular right lateral incisor tooth",
      "definition" : "Deciduous mandibular right lateral incisor tooth; Universal designation Q; ISO designation 82"
    },
    {
      "code" : "R",
      "display" : "Deciduous mandibular right canine tooth",
      "definition" : "Deciduous mandibular right canine tooth; Universal designation R; ISO designation 83"
    },
    {
      "code" : "S",
      "display" : "Deciduous mandibular right first molar tooth",
      "definition" : "Deciduous mandibular right first molar tooth: Universal designation S; ISO designation 84"
    },
    {
      "code" : "T",
      "display" : "Deciduous mandibular right second molar tooth",
      "definition" : "Deciduous mandibular right second molar tooth; Universal designation T; ISO designation 85"
    },
    {
      "code" : "FS",
      "display" : "Supernumerary deciduous maxillary left central incisor tooth",
      "definition" : "Supernumerary deciduous maxillary left central incisor tooth; Universal designation FS"
    },
    {
      "code" : "IS",
      "display" : "Supernumerary deciduous maxillary left first molar tooth",
      "definition" : "Supernumerary deciduous maxillary left first molar tooth; Universal designation IS"
    },
    {
      "code" : "GS",
      "display" : "Supernumerary deciduous maxillary left lateral incisor tooth",
      "definition" : "Supernumerary deciduous maxillary left lateral incisor tooth; Universal designation GS"
    },
    {
      "code" : "JS",
      "display" : "Supernumerary deciduous maxillary left second molar tooth",
      "definition" : "Supernumerary deciduous maxillary left second molar tooth; Universal designation JS"
    },
    {
      "code" : "CS",
      "display" : "Supernumerary deciduous maxillary right canine tooth",
      "definition" : "Supernumerary deciduous maxillary right canine tooth; Universal designation CS"
    },
    {
      "code" : "ES",
      "display" : "Supernumerary deciduous maxillary right central incisor tooth",
      "definition" : "Supernumerary deciduous maxillary right central incisor tooth; Universal designation ES"
    },
    {
      "code" : "BS",
      "display" : "Supernumerary deciduous maxillary right first molar tooth",
      "definition" : "Supernumerary deciduous maxillary right first molar tooth; Universal designation BS"
    },
    {
      "code" : "DS",
      "display" : "Supernumerary deciduous maxillary right lateral incisor tooth",
      "definition" : "Supernumerary deciduous maxillary right lateral incisor tooth; Universal designation DS"
    },
    {
      "code" : "AS",
      "display" : "Supernumerary deciduous maxillary right second molar tooth",
      "definition" : "Supernumerary deciduous maxillary right second molar tooth; Universal designation AS"
    }
  ]
}

```
